/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ChecksumUtil;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class VdbFileWriter {
    public static final int FORM_JAR = 1;
    public static final int FORM_ZIP = 2;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int WRITING_ARCHIVE_SUCCESSFUL = 1001;
    public static final int WRITING_ARCHIVE_WITH_WARNINGS = 1002;
    public static final int WRITING_ARCHIVE_WITH_ERRORS = 1003;
    public static final int WRITING_ARCHIVE_WITH_ERRORS_AND_WARNINGS = 1004;
    public static final int UNABLE_TO_ADD_FOLDER_TO_ARCHIVE = 1005;
    public static final int UNEXPECTED_EXCEPTION = 1006;
    public static final int ERROR_COMPUTING_CHECKSUM = 1007;
    public static final int ERROR_CLOSING_CONTENT_STREAM = 1008;
    public static final int UNABLE_TO_DELETE_TEMP_CONTENTS_FILE = 1009;
    public static final int CONTENTS_NOT_FOUND = 1010;
    public static final int ERROR_WRITING_CONTENTS = 1011;
    private static final String PLUGIN_ID = "com.metamatrix.vdb.edit";
    protected static final int AMOUNT_OF_WORK_PER_ENTRY = 100;
    private final IPath path;
    private final int bufferSize;
    private final List archiveEntryInfos;
    private ZipOutputStream archiveStream;
    private final int form;

    public VdbFileWriter(IPath pathToArchive, int form) {
        this(pathToArchive, form, 4096);
    }

    public VdbFileWriter(IPath pathToArchive, int form, int bufferSize) {
        ArgCheck.isNotNull(pathToArchive);
        ArgCheck.isPositive(bufferSize);
        VdbFileWriter.argCheckForm(form);
        this.path = pathToArchive;
        this.bufferSize = bufferSize;
        this.archiveEntryInfos = new ArrayList();
        this.form = form;
    }

    public static void argCheckForm(int form) {
        if (form != 1 && form != 2) {
            Object[] params = new Object[]{new Integer(form)};
            String msg = VdbEditPlugin.Util.getString("VdbFileWriter.invalid_form", params);
            ArgCheck.isTrue(false, msg);
        }
    }

    public IPath getPath() {
        return this.path;
    }

    public void open() throws IOException {
        if (this.archiveStream == null) {
            this.archiveStream = this.openArchiveOutputStream(this.path);
        }
    }

    public void addEntry(IPath pathInArchive, File contents) throws IOException {
        this.addEntry(pathInArchive, contents, null, false);
    }

    public void addEntry(IPath pathInArchive, File contents, String comment, boolean isContentsFileTemporary) throws IOException {
        ArgCheck.isNotNull(pathInArchive);
        ArgCheck.isNotNull(contents);
        if (!this.checkDuplicateEntry(pathInArchive)) {
            Path contentsPath = new Path(contents.getCanonicalPath());
            ArchiveEntryInfo entry = new ArchiveEntryInfo(pathInArchive, contentsPath, comment, isContentsFileTemporary);
            this.getArchiveEntryInfos().add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus write(IProgressMonitor progressMonitor) {
        this.assertWriterIsOpen();
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        Object[] taskParams = new Object[]{this.path};
        String taskName = VdbEditPlugin.Util.getString("VdbFileWriter.taskName", taskParams);
        int totalWork = this.getArchiveEntryInfos().size() * 100 * 2;
        monitor.beginTask(taskName, totalWork);
        ArrayList<Status> problems = new ArrayList<Status>();
        try {
            Iterator iter = this.getArchiveEntryInfos().iterator();
            while (iter.hasNext()) {
                ArchiveEntryInfo entryInfo = (ArchiveEntryInfo)iter.next();
                this.writeToArchive(entryInfo, problems, monitor);
            }
        }
        catch (Throwable e2) {
            int code = 1006;
            Object[] params = new Object[]{this.path};
            String msg = VdbEditPlugin.Util.getString("VdbFileWriter.Unexpected_exception_while_writing_vdb_file", params);
            Status status = new Status(4, PLUGIN_ID, 1006, msg, null);
            problems.add(status);
        }
        finally {
            monitor.done();
        }
        return this.createSingleIStatus(problems.toArray(new IStatus[problems.size()]));
    }

    public void close() throws IOException {
        if (this.archiveStream != null) {
            this.archiveStream.close();
        }
    }

    protected List getArchiveEntryInfos() {
        return this.archiveEntryInfos;
    }

    protected void assertWriterIsOpen() {
        if (this.archiveStream == null) {
            String msg = VdbEditPlugin.Util.getString("VdbFileWriter.Writer_must_be_open_before_calling");
            throw new IllegalStateException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void writeToArchive(ArchiveEntryInfo info, List problems, IProgressMonitor monitor) {
        block46: {
            this.assertWriterIsOpen();
            entryContents = info.pathToContents.toFile();
            if (entryContents.isDirectory()) {
                params = new Object[]{info.pathToContents, this.path};
                msg = VdbEditPlugin.Util.getString("VdbFileWriter.Contents_path_is_directory", params);
                status = new Status(4, "com.metamatrix.vdb.edit", 1005, msg, null);
                problems.add(status);
                return;
            }
            stream = null;
            try {
                block45: {
                    block43: {
                        try {
                            stream = new FileInputStream(entryContents);
                        }
                        catch (FileNotFoundException e1) {
                            params = new Object[]{info.pathToContents, this.path};
                            msg = VdbEditPlugin.Util.getString("VdbFileWriter.Contents_not_found", params);
                            status = new Status(4, "com.metamatrix.vdb.edit", 1010, msg, e1);
                            problems.add(status);
                            var26_17 = null;
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    params = new Object[]{info.pathToContents, this.path};
                                    msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_closing_content_stream", params);
                                    status = new Status(2, "com.metamatrix.vdb.edit", 1008, msg, e);
                                    problems.add(status);
                                }
                            }
                            if (info.isTemporaryContentsFile && !(success = entryContents.delete())) {
                                params = new Object[]{info.pathToContents, this.path};
                                msg = VdbEditPlugin.Util.getString("VdbFileWriter.Unable_to_delete_contents_file", params);
                                status = new Status(2, "com.metamatrix.vdb.edit", 1009, msg, null);
                                problems.add(status);
                            }
                            return;
                        }
                        stream = new BufferedInputStream(stream);
                        sizeInBytes = 0L;
                        crc32 = new CRC32();
                        try {
                            sizeInBytes = ChecksumUtil.computeChecksum(stream, crc32);
                            var14_41 = null;
                            ** if (stream == null) goto lbl-1000
                        }
                        catch (Throwable var13_58) {
                            var14_42 = null;
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    params = new Object[]{info.pathToContents, this.path};
                                    msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_closing_content_stream_for_crc", params);
                                    status = new Status(2, "com.metamatrix.vdb.edit", 1008, msg, e);
                                    problems.add(status);
                                }
                            }
                            throw var13_58;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                params = new Object[]{info.pathToContents, this.path};
                                msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_closing_content_stream_for_crc", params);
                                status = new Status(2, "com.metamatrix.vdb.edit", 1008, msg, e);
                                problems.add(status);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block43;
                            catch (Exception e) {
                                params = new Object[]{info.pathToContents, this.path};
                                msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_computing_checksum", params);
                                status = new Status(4, "com.metamatrix.vdb.edit", 1007, msg, e);
                                problems.add(status);
                                var14_41 = null;
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException e) {
                                        params = new Object[]{info.pathToContents, this.path};
                                        msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_closing_content_stream_for_crc", params);
                                        status = new Status(2, "com.metamatrix.vdb.edit", 1008, msg, e);
                                        problems.add(status);
                                    }
                                }
                            }
                        }
                    }
                    entry = this.createArchiveEntry(info.pathInArchive.toString());
                    entry.setCrc(crc32.getValue());
                    entry.setSize(sizeInBytes);
                    entry.setTime(entryContents.lastModified());
                    if (info.comment != null && info.comment.trim().length() != 0) {
                        entry.setComment(info.comment);
                    }
                    monitor.worked(100);
                    try {
                        stream = new FileInputStream(entryContents);
                    }
                    catch (FileNotFoundException e1) {
                        params = new Object[]{info.pathToContents, this.path};
                        msg = VdbEditPlugin.Util.getString("VdbFileWriter.Contents_not_found_for_adding", params);
                        status = new Status(4, "com.metamatrix.vdb.edit", 1010, msg, e1);
                        problems.add(status);
                        var26_18 = null;
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                params = new Object[]{info.pathToContents, this.path};
                                msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_closing_content_stream", params);
                                status = new Status(2, "com.metamatrix.vdb.edit", 1008, msg, e);
                                problems.add(status);
                            }
                        }
                        if (info.isTemporaryContentsFile && !(success = entryContents.delete())) {
                            params = new Object[]{info.pathToContents, this.path};
                            msg = VdbEditPlugin.Util.getString("VdbFileWriter.Unable_to_delete_contents_file", params);
                            status = new Status(2, "com.metamatrix.vdb.edit", 1009, msg, null);
                            problems.add(status);
                        }
                        return;
                    }
                    stream = new BufferedInputStream(stream);
                    buffer = new byte[this.bufferSize];
                    n = 0;
                    this.archiveStream.putNextEntry(entry);
                    while ((n = stream.read(buffer)) > -1) {
                        this.archiveStream.write(buffer, 0, n);
                    }
                    var20_62 = null;
                    try {
                        this.archiveStream.closeEntry();
                    }
                    catch (IOException e2) {
                        params = new Object[]{info.pathToContents, this.path};
                        msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_closing_archive_entry", params);
                        status = new Status(4, "com.metamatrix.vdb.edit", 1011, msg, e2);
                        problems.add(status);
                    }
                    break block45;
                    {
                        catch (IOException ex) {
                            params = new Object[]{info.pathToContents, this.path};
                            msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_writing_contents", params);
                            status = new Status(4, "com.metamatrix.vdb.edit", 1011, msg, ex);
                            problems.add(status);
                            var20_63 = null;
                            try {
                                this.archiveStream.closeEntry();
                            }
                            catch (IOException e2) {
                                params = new Object[]{info.pathToContents, this.path};
                                msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_closing_archive_entry", params);
                                status = new Status(4, "com.metamatrix.vdb.edit", 1011, msg, e2);
                                problems.add(status);
                            }
                            break block45;
                        }
                        catch (Throwable ex) {
                            params = new Object[]{info.pathToContents, this.path};
                            msg = VdbEditPlugin.Util.getString("VdbFileWriter.Unexpected_error_writing_contents", params);
                            status = new Status(4, "com.metamatrix.vdb.edit", 1011, msg, ex);
                            problems.add(status);
                            var20_64 = null;
                            try {
                                this.archiveStream.closeEntry();
                            }
                            catch (IOException e2) {
                                params = new Object[]{info.pathToContents, this.path};
                                msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_closing_archive_entry", params);
                                status = new Status(4, "com.metamatrix.vdb.edit", 1011, msg, e2);
                                problems.add(status);
                            }
                        }
                    }
                    catch (Throwable var19_82) {
                        var20_65 = null;
                        try {
                            this.archiveStream.closeEntry();
                        }
                        catch (IOException e2) {
                            params = new Object[]{info.pathToContents, this.path};
                            msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_closing_archive_entry", params);
                            status = new Status(4, "com.metamatrix.vdb.edit", 1011, msg, e2);
                            problems.add(status);
                        }
                        throw var19_82;
                    }
                }
                monitor.worked(100);
                var26_19 = null;
                if (stream == null) break block46;
            }
            catch (Throwable var25_83) {
                var26_20 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        params = new Object[]{info.pathToContents, this.path};
                        msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_closing_content_stream", params);
                        status = new Status(2, "com.metamatrix.vdb.edit", 1008, msg, e);
                        problems.add(status);
                    }
                }
                if (info.isTemporaryContentsFile && !(success = entryContents.delete())) {
                    params = new Object[]{info.pathToContents, this.path};
                    msg = VdbEditPlugin.Util.getString("VdbFileWriter.Unable_to_delete_contents_file", params);
                    status = new Status(2, "com.metamatrix.vdb.edit", 1009, msg, null);
                    problems.add(status);
                }
                throw var25_83;
            }
            try {
                stream.close();
            }
            catch (IOException e) {
                params = new Object[]{info.pathToContents, this.path};
                msg = VdbEditPlugin.Util.getString("VdbFileWriter.Error_closing_content_stream", params);
                status = new Status(2, "com.metamatrix.vdb.edit", 1008, msg, e);
                problems.add(status);
            }
        }
        if (info.isTemporaryContentsFile && !(success = entryContents.delete())) {
            params = new Object[]{info.pathToContents, this.path};
            msg = VdbEditPlugin.Util.getString("VdbFileWriter.Unable_to_delete_contents_file", params);
            status = new Status(2, "com.metamatrix.vdb.edit", 1009, msg, null);
            problems.add(status);
        }
    }

    protected IStatus createSingleIStatus(IStatus[] problems) {
        IStatus result = null;
        if (problems.length == 0) {
            int code = 1001;
            Object[] params = new Object[]{this.path};
            String msg = VdbEditPlugin.Util.getString("VdbFileWriter.Writing_vdb_file_completed", params);
            result = new Status(0, PLUGIN_ID, 1001, msg, null);
        } else if (problems.length == 1) {
            result = problems[0];
        } else {
            int numErrors = 0;
            int numWarnings = 0;
            for (int i2 = 0; i2 < problems.length; ++i2) {
                if (problems[i2].getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (problems[i2].getSeverity() != 4) continue;
                ++numErrors;
            }
            if (numWarnings != 0 && numErrors == 0) {
                Object[] params = new Object[]{new Integer(numWarnings)};
                String msg = VdbEditPlugin.Util.getString("VdbFileWriter.Writing_vdb_file_completed_with_warnings", params);
                result = new MultiStatus(PLUGIN_ID, 1002, problems, msg, null);
            } else if (numWarnings == 0 && numErrors != 0) {
                Object[] params = new Object[]{new Integer(numErrors)};
                String msg = VdbEditPlugin.Util.getString("VdbFileWriter.Writing_vdb_file_resulted_in_errors", params);
                result = new MultiStatus(PLUGIN_ID, 1003, problems, msg, null);
            } else if (numWarnings != 0 && numErrors != 0) {
                Object[] params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
                String msg = VdbEditPlugin.Util.getString("VdbFileWriter.Writing_vdb_file_resulted_in_warnings_and_errors", params);
                result = new MultiStatus(PLUGIN_ID, 1004, problems, msg, null);
            } else {
                String msg = VdbEditPlugin.Util.getString("VdbFileWriter.Writing_vdb_file_completed_with_no_warnings_or_errors");
                result = new MultiStatus(PLUGIN_ID, 1001, problems, msg, null);
            }
        }
        return result;
    }

    protected ZipOutputStream openArchiveOutputStream(IPath archiveFilePath) throws IOException {
        File archiveFile = new File(archiveFilePath.toOSString());
        if (!archiveFile.exists()) {
            archiveFile.createNewFile();
        }
        OutputStream ostream = new FileOutputStream(archiveFile);
        ostream = new BufferedOutputStream(ostream);
        if (this.form == 2) {
            return new ZipOutputStream(ostream);
        }
        Manifest manifest = new Manifest();
        Attributes attribs = manifest.getMainAttributes();
        attribs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        return new JarOutputStream(ostream, manifest);
    }

    protected ZipEntry createArchiveEntry(String name) {
        if (this.form == 2) {
            return new ZipEntry(name);
        }
        return new JarEntry(name);
    }

    protected boolean checkDuplicateEntry(IPath pathInArchive) {
        if (this.getArchiveEntryInfos() != null) {
            Iterator i2 = this.getArchiveEntryInfos().iterator();
            while (i2.hasNext()) {
                ArchiveEntryInfo entryInfo = (ArchiveEntryInfo)i2.next();
                if (((Object)entryInfo.pathInArchive).equals(pathInArchive)) {
                    return true;
                }
                IPath potentialPath = pathInArchive.makeAbsolute();
                IPath existingPath = entryInfo.pathInArchive.makeAbsolute();
                if (((Object)existingPath).equals(potentialPath)) {
                    return true;
                }
                potentialPath = pathInArchive.makeRelative();
                existingPath = entryInfo.pathInArchive.makeRelative();
                if (!((Object)existingPath).equals(potentialPath)) continue;
                return true;
            }
        }
        return false;
    }

    protected class ArchiveEntryInfo {
        protected final IPath pathInArchive;
        protected final IPath pathToContents;
        protected final String comment;
        protected final boolean isTemporaryContentsFile;

        protected ArchiveEntryInfo(IPath pathInArchive, IPath pathToContents, String comment, boolean tempContents) {
            this.pathInArchive = pathInArchive;
            this.pathToContents = pathToContents;
            this.comment = comment;
            this.isTemporaryContentsFile = tempContents;
        }
    }
}

