/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.internal.core.container.DefaultResourceFinder;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;

public class VdbContainerResourceFinder
extends DefaultResourceFinder {
    public VdbContainerResourceFinder(Container container) {
        super(container);
    }

    protected void resolveSchemaDirectives(XSDResourceImpl eResource, boolean recurse, Set visited, Set unresolvedResourceURIs) {
        if (eResource != null && !visited.contains(eResource)) {
            if (!eResource.isLoaded()) {
                try {
                    eResource.load(this.getContainer().getLoadOptions());
                }
                catch (IOException err) {
                    String msg = ModelerCore.Util.getString("DefaultResourceFinder.Error_loading_resource", eResource);
                    ModelerCore.Util.log(4, msg);
                }
            }
            visited.add(eResource);
            Iterator i2 = eResource.getSchema().eContents().iterator();
            while (i2.hasNext()) {
                EObject eObj = (EObject)i2.next();
                if (!(eObj instanceof XSDSchemaDirective)) continue;
                XSDSchema resolvedSchema = ((XSDSchemaDirective)eObj).getResolvedSchema();
                if (resolvedSchema == null) {
                    XSDSchemaDirective directive = (XSDSchemaDirective)eObj;
                    XSDResourceImpl refdResource = null;
                    String location = directive.getSchemaLocation();
                    if (this.isWebServicelURL(location)) {
                        refdResource = (XSDResourceImpl)this.getContainer().getResource(URI.createURI(location), false);
                    } else {
                        URI schemaLocationURI;
                        URI baseLocationURI = eResource.getURI();
                        URI uRI = schemaLocationURI = baseLocationURI.isFile() ? URI.createURI(location, false) : URI.createURI(location);
                        if (baseLocationURI.isHierarchical() && !baseLocationURI.isRelative() && schemaLocationURI.isRelative()) {
                            schemaLocationURI = schemaLocationURI.resolve(baseLocationURI);
                        }
                        refdResource = (XSDResourceImpl)this.getContainer().getResource(schemaLocationURI, false);
                    }
                    if (refdResource != null) {
                        resolvedSchema = refdResource.getSchema();
                        directive.setResolvedSchema(resolvedSchema);
                        if (directive instanceof XSDImport) {
                            ((XSDSchemaImpl)resolvedSchema).imported((XSDImport)directive);
                        } else if (directive instanceof XSDInclude) {
                            ((XSDSchemaImpl)resolvedSchema).included((XSDInclude)directive);
                        } else if (directive instanceof XSDRedefine) {
                            ((XSDSchemaImpl)resolvedSchema).redefined((XSDRedefine)directive);
                        }
                    }
                }
                if (resolvedSchema != null && resolvedSchema.eIsProxy()) {
                    resolvedSchema = (XSDSchema)EcoreUtil.resolve((EObject)resolvedSchema, eResource.getResourceSet());
                }
                if (resolvedSchema == null || resolvedSchema.eResource() == null || resolvedSchema.eResource().getResourceSet() == null) {
                    String location = ((XSDSchemaDirective)eObj).getSchemaLocation();
                    int endIndex = location.lastIndexOf("?vdbToken=true");
                    int beginIndex = "http://vdb.metamatrix.com".length();
                    if (endIndex > 0 && beginIndex < endIndex) {
                        location = location.substring("http://vdb.metamatrix.com".length(), endIndex);
                    }
                    URI unresolvedURI = URI.createURI(location);
                    unresolvedResourceURIs.add(unresolvedURI);
                    continue;
                }
                if (!recurse || resolvedSchema == null) continue;
                this.resolveSchemaDirectives((XSDResourceImpl)resolvedSchema.eResource(), recurse, visited, unresolvedResourceURIs);
            }
        }
    }

    protected boolean isWebServicelURL(String url) {
        if (!StringUtil.isEmpty(url)) {
            int endIndex = url.lastIndexOf("?vdbToken=true");
            int beginIndex = "http://vdb.metamatrix.com".length();
            if (endIndex > 0 && beginIndex < endIndex) {
                return true;
            }
        }
        return false;
    }
}

