/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.edit;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.jdom.Document;

public interface VdbGenerationContext {
    public Resource[] getModels();

    public Resource[] getModels(String var1);

    public ModelHelper getModelHelper();

    public ModelObjectHelper getObjectHelper();

    public void addErrorMessage(String var1, int var2, Throwable var3);

    public void addWarningMessage(String var1, int var2);

    public void addInfoMessage(String var1, int var2);

    public void setProgressMessage(String var1);

    public String getProgressMessage();

    public boolean addGeneratedArtifact(String var1, String var2);

    public boolean addGeneratedArtifact(String var1, Document var2);

    public boolean addGeneratedArtifact(String var1, InputStream var2);

    public boolean addGeneratedArtifact(String var1, File var2);

    public Map getGeneratedArtifactsByPath();

    public File getTemporaryDirectory();

    public List getProblems();

    public static final class ModelType {
        public static final ModelType PHYSICAL = new ModelType(com.metamatrix.metamodels.core.ModelType.PHYSICAL_LITERAL);
        public static final ModelType CONFIGURATION = new ModelType(com.metamatrix.metamodels.core.ModelType.CONFIGURATION_LITERAL);
        public static final ModelType EXTENSION = new ModelType(com.metamatrix.metamodels.core.ModelType.EXTENSION_LITERAL);
        public static final ModelType FUNCTION = new ModelType(com.metamatrix.metamodels.core.ModelType.FUNCTION_LITERAL);
        public static final ModelType LOGICAL = new ModelType(com.metamatrix.metamodels.core.ModelType.LOGICAL_LITERAL);
        public static final ModelType MATERIALIZATION = new ModelType(com.metamatrix.metamodels.core.ModelType.MATERIALIZATION_LITERAL);
        public static final ModelType METAMODEL = new ModelType(com.metamatrix.metamodels.core.ModelType.METAMODEL_LITERAL);
        public static final ModelType TYPE = new ModelType(com.metamatrix.metamodels.core.ModelType.TYPE_LITERAL);
        public static final ModelType UNKNOWN = new ModelType(com.metamatrix.metamodels.core.ModelType.UNKNOWN_LITERAL);
        public static final ModelType VDB_ARCHIVE = new ModelType(com.metamatrix.metamodels.core.ModelType.VDB_ARCHIVE_LITERAL);
        public static final ModelType VIRTUAL = new ModelType(com.metamatrix.metamodels.core.ModelType.VIRTUAL_LITERAL);
        public static final ModelType[] ALL_MODEL_TYPES = new ModelType[]{PHYSICAL, CONFIGURATION, EXTENSION, FUNCTION, LOGICAL, MATERIALIZATION, METAMODEL, TYPE, UNKNOWN, VDB_ARCHIVE, VIRTUAL};
        private final com.metamatrix.metamodels.core.ModelType type;

        public static final ModelType getModelType(com.metamatrix.metamodels.core.ModelType type) {
            int v2 = type.getValue();
            for (int i2 = 0; i2 != ALL_MODEL_TYPES.length; ++i2) {
                ModelType modelType = ALL_MODEL_TYPES[i2];
                if (modelType.getValue() != v2) continue;
                return modelType;
            }
            return null;
        }

        private ModelType(com.metamatrix.metamodels.core.ModelType type) {
            this.type = type;
        }

        public int getValue() {
            return this.type.getValue();
        }

        public String getDisplayName() {
            return this.type.getDisplayName();
        }

        public String getName() {
            return this.type.getName();
        }

        public String toString() {
            return this.type.getName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModelType) {
                ModelType that = (ModelType)obj;
                return this.type.equals(that.type);
            }
            return false;
        }

        public boolean isVirtual() {
            return this == VIRTUAL;
        }

        public boolean isPhysical() {
            return this == PHYSICAL;
        }
    }

    public static interface ModelHelper {
        public String getUuid(Resource var1);

        public String getName(Resource var1);

        public String getPath(Resource var1);

        public String getTargetNamespaceUri(Resource var1);

        public String getPrimaryMetamodelUri(Resource var1);

        public String getDescription(Resource var1);

        public Properties getProperties(Resource var1);

        public ModelType getModelType(Resource var1);

        public boolean isVisible(Resource var1);
    }

    public static interface ModelObjectHelper {
        public String getUuid(EObject var1);

        public String getDescription(EObject var1);

        public boolean hasErrors(EObject var1);

        public boolean hasWarnings(EObject var1);

        public Properties getProperties(EObject var1);
    }
}

