/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.metadata.ModelerMetadata;
import com.metamatrix.modeler.transformation.metadata.QueryMetadataContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;

public class VdbMetadata
extends ModelerMetadata {
    public VdbMetadata(QueryMetadataContext context) {
        super(context);
    }

    protected Collection findMetadataRecords(char recordType, String entityName, boolean isPartialName) throws MetaMatrixComponentException {
        Collection sysObjects;
        EObject eObj;
        LinkedList<EObject> eObjects = new LinkedList<EObject>();
        String uuid = null;
        if (StringUtil.startsWithIgnoreCase(entityName, "mmuuid")) {
            uuid = entityName.toLowerCase();
        } else {
            try {
                String shortName = super.getShortElementName(entityName);
                if (StringUtil.startsWithIgnoreCase(shortName, "mmuuid")) {
                    uuid = shortName.toLowerCase();
                }
            }
            catch (QueryMetadataException e2) {
                throw new MetaMatrixComponentException((Throwable)e2);
            }
        }
        if (uuid != null && (eObj = this.lookupEObject(uuid)) != null && (eObj.eContainer() != null || eObj.eResource() != null)) {
            eObjects.add(eObj);
        }
        if (eObjects.isEmpty() && !(sysObjects = this.findSystemMetadataRecords(recordType, entityName, isPartialName)).isEmpty()) {
            return sysObjects;
        }
        if (eObjects.isEmpty()) {
            IEntryResult[] results = this.queryIndex(recordType, entityName, isPartialName);
            Collection records = this.findMetadataRecords(results);
            if (StringUtil.startsWithIgnoreCase(entityName, "mmuuid")) {
                this.filterMetadataRecordForUUID(entityName, records);
            }
            return records;
        }
        if (!eObjects.isEmpty()) {
            ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(eObjects.size());
            Iterator eObjIter = eObjects.iterator();
            while (eObjIter.hasNext()) {
                MetadataRecord record = this.createMetadataRecord(recordType, (EObject)eObjIter.next());
                if (record == null) continue;
                records.add(record);
            }
            return records;
        }
        return Collections.EMPTY_LIST;
    }

    protected EObject lookupEObject(String uuid) throws MetaMatrixComponentException {
        ArgCheck.isNotEmpty(uuid);
        return (EObject)this.getContainer().getEObjectFinder().find(uuid);
    }

    protected Index[] getIndexes(char recordType, IndexSelector selector) throws MetaMatrixComponentException {
        try {
            String indexName = IndexUtil.getIndexFileNameForRecordType(recordType);
            return IndexUtil.getIndexes(indexName, selector);
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException((Throwable)e2, TransformationPlugin.Util.getString("TransformationMetadata.Error_trying_to_obtain_index_file_using_IndexSelector_1", selector));
        }
    }
}

