/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.aspects.validation.rules;

import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationMappingHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.query.o.j.l;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class ProcedureParameterValidationHelper {
    public void validateProcedureParameters(l command, SqlTransformationMappingRoot transMappingRoot, ValidationResult validationResult) {
        boolean mappingClass = false;
        if (transMappingRoot.getOutputs().size() > 0 && transMappingRoot.getOutputs().get(0) instanceof MappingClass) {
            mappingClass = true;
        }
        Iterator sources = TransformationHelper.getTransformationSources(transMappingRoot).iterator();
        ArrayList params = new ArrayList();
        while (sources.hasNext()) {
            EObject source = (EObject)sources.next();
            if (!SqlAspectHelper.isTable(source)) continue;
            params.addAll(TransformationHelper.getTargetAttributes(source));
        }
        TransformationMappingHelper.removeNonParameterColumnAttributes(params);
        List attrsInAP = TransformationHelper.getTransformationTargetAttributesInAccessPattern(transMappingRoot);
        TransformationMappingHelper.removeSelectableColumnAttributes(attrsInAP);
        List columns = TransformationHelper.getTransformationTargetAttributes(transMappingRoot);
        TransformationMappingHelper.removeSelectableColumnAttributes(columns);
        HashSet inputs = new HashSet(columns);
        inputs.removeAll(attrsInAP);
        this.validateNonSelectableColumns(mappingClass, inputs, validationResult);
    }

    private void validateNonSelectableColumns(boolean mappingClass, Set nonSelectableInputs, ValidationResult validationResult) {
        Iterator i2 = nonSelectableInputs.iterator();
        while (i2.hasNext()) {
            ValidationProblemImpl typeProblem;
            EObject column = (EObject)i2.next();
            SqlColumnAspect columnAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect(column);
            if (columnAspect.getDefaultValue(column) != null) continue;
            if (mappingClass) {
                typeProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("ProcedureParameterValidationHelper.No_default_for_mapping_class_parameter", columnAspect.getName(column)));
                validationResult.addProblem(typeProblem);
                continue;
            }
            if (columnAspect.getNullType(column) == 1) continue;
            i2.remove();
            if (columnAspect.isAutoIncrementable(column)) continue;
            typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("ProcedureParameterValidationHelper.Non-selectable_column", columnAspect.getName(column)));
            validationResult.addProblem(typeProblem);
        }
    }
}

