/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.aspects.validation.rules;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.MappingClassColumn;
import com.metamatrix.metamodels.transformation.MappingClassSet;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.metamodels.xml.XmlContainerNode;
import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.util.XmlDocumentUtil;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.query.o.h.k;
import com.metamatrix.query.o.i.a;
import com.metamatrix.query.o.j.af;
import com.metamatrix.query.o.j.ao;
import com.metamatrix.query.o.j.l;
import com.metamatrix.query.o.j.r;
import com.metamatrix.query.o.j.s;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDTypeDefinition;

public class MappingClassTransformationValidationHelper {
    public void validate(l command, SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        EObject targetObj = transRoot.getTarget();
        if (!(targetObj instanceof MappingClass)) {
            return;
        }
        MappingClass mappingClass = (MappingClass)targetObj;
        if (mappingClass != null && mappingClass.isRecursionAllowed() && mappingClass.isRecursive() && mappingClass.eResource() instanceof EmfResource) {
            this.validateRecursiveMappingClass(mappingClass, validationResult);
        } else if (command instanceof af) {
            this.validate((af)command, mappingClass, validationResult);
        } else if (command instanceof r) {
            this.validate((r)command, mappingClass, validationResult);
        } else {
            ValidationProblemImpl errorProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("MappingClassTransformationRule.Non-Query_NonUnion_transformation"));
            validationResult.addProblem(errorProblem);
        }
    }

    void validate(af query, MappingClass mappingClass, ValidationResult validationResult) {
        ValidationProblem problem1 = this.checkInputParamInSelect(query, mappingClass);
        if (problem1 != null) {
            validationResult.addProblem(problem1);
            return;
        }
        ValidationProblem problem2 = this.checkInputParamInCriteria(query, mappingClass);
        if (problem2 != null) {
            validationResult.addProblem(problem2);
            return;
        }
    }

    void validate(r setQuery, MappingClass mappingClass, ValidationResult validationResult) {
        boolean hasInputParamInCriteria = false;
        ValidationProblem inputCriteriaProblem = null;
        Iterator iter = setQuery.i7().iterator();
        while (iter.hasNext()) {
            af query = (af)iter.next();
            ValidationProblem problem1 = this.checkInputParamInSelect(query, mappingClass);
            if (problem1 != null) {
                validationResult.addProblem(problem1);
                return;
            }
            ValidationProblem problem2 = this.checkInputParamInCriteria(query, mappingClass);
            if (problem2 != null && !hasInputParamInCriteria) {
                inputCriteriaProblem = problem2;
                continue;
            }
            hasInputParamInCriteria = true;
        }
        if (!hasInputParamInCriteria) {
            validationResult.addProblem(inputCriteriaProblem);
        }
    }

    ValidationProblem checkInputParamInSelect(af query, MappingClass mappingClass) {
        s selectClause = query.jf();
        Collection elementSymbols = k.e8(selectClause, true);
        Iterator iter = elementSymbols.iterator();
        while (iter.hasNext()) {
            a symbol = (a)iter.next();
            if (!StringUtil.startsWithIgnoreCase(symbol.ak(), "INPUT")) continue;
            return new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.InputParam_In_Mapping_Class_Transform", mappingClass.getName()));
        }
        return null;
    }

    ValidationProblem checkInputParamInCriteria(af query, MappingClass mappingClass) {
        if (mappingClass.isRecursive()) {
            boolean foundInParam = false;
            ao criteriaClause = query.jm();
            if (criteriaClause != null) {
                Collection elementSymbols = k.e8(criteriaClause, true);
                Iterator iter = elementSymbols.iterator();
                while (iter.hasNext()) {
                    a symbol = (a)iter.next();
                    if (!StringUtil.startsWithIgnoreCase(symbol.ak(), "INPUT")) continue;
                    foundInParam = true;
                }
            }
            if (!foundInParam) {
                return new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("MappingClassTransformationRule.No_INPUT_Parameters_In_Criteria", mappingClass.getName()));
            }
        }
        return null;
    }

    void validateRecursiveMappingClass(MappingClass mc, ValidationResult validationResult) {
        EmfResource eResource = (EmfResource)mc.eResource();
        ModelContents contents = eResource.getModelContents();
        if (contents != null) {
            TreeMappingRoot tmr;
            Object obj;
            MappingClassSet mcset = (MappingClassSet)mc.eContainer();
            List treeMappingRoots = contents.getTransformations(mcset.getTarget());
            HashMap xmlDocNodeToMappingClass = new HashMap();
            Iterator iter = treeMappingRoots.iterator();
            while (iter.hasNext()) {
                obj = iter.next();
                if (!(obj instanceof TreeMappingRoot)) continue;
                tmr = (TreeMappingRoot)obj;
                Assertion.isEqual(1, tmr.getInputs().size());
                Iterator outIter = tmr.getOutputs().iterator();
                while (outIter.hasNext()) {
                    xmlDocNodeToMappingClass.put(outIter.next(), tmr.getInputs().get(0));
                }
            }
            iter = treeMappingRoots.iterator();
            while (iter.hasNext()) {
                ValidationProblemImpl errorProblem;
                String msg;
                obj = iter.next();
                if (!(obj instanceof TreeMappingRoot) || (tmr = (TreeMappingRoot)obj).getInputs().get(0) != mc) continue;
                XmlElement element = (XmlElement)tmr.getOutputs().get(0);
                MappingClass rootMappingClass = this.getRecusionRootMappingClass(element, xmlDocNodeToMappingClass);
                if (rootMappingClass == null) {
                    msg = TransformationPlugin.Util.getString("MappingClassTransformationRule.Mapping_Class_Is_Null_For_{0}_0", mc.getName());
                    errorProblem = new ValidationProblemImpl(0, 4, msg);
                    validationResult.addProblem(errorProblem);
                }
                if (rootMappingClass == null) continue;
                if (mc.getColumns().size() != rootMappingClass.getColumns().size()) {
                    msg = TransformationPlugin.Util.getString("MappingClassTransformationRule.Mismatch_Number_Of_Column_{0}_AND_{1}_1", rootMappingClass.getName(), mc.getName());
                    errorProblem = new ValidationProblemImpl(0, 4, msg);
                    validationResult.addProblem(errorProblem);
                    continue;
                }
                EList childColumns = mc.getColumns();
                EList rootColumns = rootMappingClass.getColumns();
                int n2 = rootColumns.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ValidationProblemImpl errorProblem2;
                    String msg2;
                    MappingClassColumn rootCol = (MappingClassColumn)rootColumns.get(i2);
                    MappingClassColumn childCol = (MappingClassColumn)childColumns.get(i2);
                    if (!rootCol.getName().equalsIgnoreCase(childCol.getName())) {
                        msg2 = TransformationPlugin.Util.getString("MappingClassTransformationRule.Mismatch_Number_Column_Name_{0}_AND_{1}_2", rootMappingClass.getName(), mc.getName());
                        errorProblem2 = new ValidationProblemImpl(0, 4, msg2);
                        validationResult.addProblem(errorProblem2);
                    }
                    if (rootCol.getType() == childCol.getType()) continue;
                    msg2 = TransformationPlugin.Util.getString("MappingClassTransformationRule.Mismatch_Column_Type_{0}_AND_{1}_3", rootMappingClass.getName(), mc.getName());
                    errorProblem2 = new ValidationProblemImpl(0, 4, msg2);
                    validationResult.addProblem(errorProblem2);
                }
            }
        }
    }

    private MappingClass getRecusionRootMappingClass(XmlElement xmlElement, Map xmlDocNodeToMappingClass) {
        MappingClass mc = (MappingClass)xmlDocNodeToMappingClass.get(xmlElement);
        if (mc != null && mc.isRecursionAllowed() && mc.isRecursive()) {
            XSDComponent xsdComponent = xmlElement.getXsdComponent();
            XSDTypeDefinition type = XmlDocumentUtil.findXSDType((XSDComponent)xsdComponent);
            if (xsdComponent == null) {
                return null;
            }
            for (EObject owner = xmlElement.eContainer(); owner != null; owner = owner.eContainer()) {
                if (!(owner instanceof XmlElement)) continue;
                XSDComponent ownerXsdComponent = ((XmlElement)owner).getXsdComponent();
                XSDTypeDefinition ownerType = XmlDocumentUtil.findXSDType((XSDComponent)ownerXsdComponent);
                if (type == null || type != ownerType) continue;
                mc = (MappingClass)xmlDocNodeToMappingClass.get(owner);
                if (mc != null) {
                    return mc;
                }
                if (!(owner.eContainer() instanceof XmlContainerNode) || (mc = (MappingClass)xmlDocNodeToMappingClass.get(owner.eContainer())) == null) continue;
                return mc;
            }
        }
        return null;
    }
}

