/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.PluginUtilImpl;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.query.function.g;
import com.metamatrix.query.function.k.a;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.BundleContext;

public class TransformationPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.metamatrix.modeler.transformation";
    private static final String BUNDLE_NAME = "com.metamatrix.modeler.transformation.i18n";
    public static final PluginUtil Util = new PluginUtilImpl("com.metamatrix.modeler.transformation", "com.metamatrix.modeler.transformation.i18n", ResourceBundle.getBundle("com.metamatrix.modeler.transformation.i18n"));
    public static final boolean DEBUG = false;
    public static final String DELIMITER = ".";
    private static TransformationPlugin TRANSFORMATION_PLUGIN;

    public TransformationPlugin() {
        TRANSFORMATION_PLUGIN = this;
    }

    public static TransformationPlugin getDefault() {
        return TRANSFORMATION_PLUGIN;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)Util).initializePlatformLogger(this);
        this.initializeFunctionLibraryManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFunctionLibraryManager() {
        String file = this.getUserDefinedFunctionFileUri();
        if (file != null) {
            boolean startedTxn = ModelerCore.startTxn(false, false, null, this);
            try {
                URI uri = URI.createFileURI(file);
                g.a(new a(uri));
            }
            catch (Exception e2) {
                String message = e2.getMessage();
                Util.log(4, e2, message);
            }
            finally {
                if (startedTxn) {
                    ModelerCore.commitTxn();
                }
            }
        }
    }

    private String getUserDefinedFunctionFileUri() {
        URL configFileUrl = null;
        try {
            URL installUrl = Platform.resolve(this.getBundle().getEntry("/"));
            configFileUrl = new URL(installUrl.toString() + "../../config/FunctionDefinitions.xmi");
            configFileUrl = Platform.resolve(configFileUrl);
            File functionsFile = this.getFile(configFileUrl);
            if (functionsFile != null && functionsFile.exists()) {
                return configFileUrl.getFile();
            }
            configFileUrl = new URL(installUrl.toString() + "../../../config/FunctionDefinitions.xmi");
            functionsFile = this.getFile(configFileUrl = Platform.resolve(configFileUrl));
            if (functionsFile != null && functionsFile.exists()) {
                return configFileUrl.getFile();
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        String message = Util.getString("TransformationPlugin.noFunctionDefinitionFileMessage", configFileUrl);
        Util.log(2, message);
        return null;
    }

    protected File getFile(URL url) {
        String path = url.getPath();
        File result = new File(path);
        return result;
    }

    public static class EXTENSION_POINT {

        public static class USER_DEFINED_FUNCTION_MODEL {
            public static final String ID = "userDefinedFunctionModel";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.transformation.userDefinedFunctionModel";

            public static class ATTRIBUTES {
                public static final String URL = "url";
            }

            public static class ELEMENTS {
                public static final String MODEL = "model";
            }
        }
    }
}

