/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.query.o.h.i;
import com.metamatrix.query.o.i.a;
import com.metamatrix.query.o.i.f;
import com.metamatrix.query.o.i.k;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class SqlSymbolUUIDMappingVisitor
extends i {
    private static final char SEPARATOR_CHAR = '.';
    private static final int UUID_LENGTH = 43;
    private Collection emfResources = Collections.EMPTY_LIST;

    protected k getMappedSymbol(k symbol) {
        if (symbol instanceof f) {
            return this.mapGroupSymbol((f)symbol);
        }
        if (symbol instanceof a) {
            return this.mapElementSymbol((a)symbol);
        }
        return symbol;
    }

    public void setResources(Collection eResources) {
        if (eResources != null) {
            this.emfResources = new ArrayList();
            Iterator iter = eResources.iterator();
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                if (!(resource instanceof EmfResource)) continue;
                this.emfResources.add(resource);
            }
        }
    }

    private f mapGroupSymbol(f groupSymbol) {
        f result = (f)groupSymbol.clone();
        String groupName = groupSymbol.ar() != null ? groupSymbol.ar() : groupSymbol.ak();
        EObject groupEObject = (EObject)this.getGroupIDFromName(groupName);
        if (groupEObject == null) {
            throw new RuntimeException("Error using MetaObjectSymbolMappingVisitor: LanguageObjects must be resolved first");
        }
        String newName = SqlSymbolUUIDMappingVisitor.getSqlEObjectFullName(groupEObject);
        this.setGroupSymbolName(result, newName);
        return result;
    }

    private a mapElementSymbol(a elementSymbol) {
        a result = (a)elementSymbol.clone();
        EObject elementEObject = (EObject)this.getElementIDFromName(elementSymbol.ak());
        f gSymbol = elementSymbol.bc();
        f mappedGroupSymbol = null;
        if (gSymbol != null) {
            mappedGroupSymbol = (f)this.getMappedSymbol(gSymbol);
        } else if (elementEObject != null) {
            String fullName = SqlSymbolUUIDMappingVisitor.getSqlEObjectParentName(elementEObject);
            if (fullName == null) {
                throw new RuntimeException("Error using MetaObjectSymbolMappingVisitor: LanguageObjects must be resolved first");
            }
            mappedGroupSymbol = new f(fullName);
        }
        result.bm(mappedGroupSymbol);
        this.setElementSymbolToName(result, elementEObject);
        return result;
    }

    private void setGroupSymbolName(f gSymbol, String name) {
        if (gSymbol != null) {
            String symbolDefn = gSymbol.ar();
            if (symbolDefn != null) {
                gSymbol.aw(name);
            } else {
                gSymbol.ai(name);
            }
        }
    }

    private void setElementSymbolToName(a eSymbol, EObject elementEObject) {
        f gSymbol = eSymbol.bc();
        if (elementEObject != null && gSymbol != null) {
            if (gSymbol.ar() != null) {
                String name = SqlSymbolUUIDMappingVisitor.getSqlEObjectName(elementEObject);
                eSymbol.ai(gSymbol.ak() + '.' + name);
            } else {
                String fullName = SqlSymbolUUIDMappingVisitor.getSqlEObjectFullName(elementEObject);
                eSymbol.ai(fullName);
            }
            eSymbol.bd(true);
        }
    }

    private Object getElementIDFromName(String elemName) {
        Object elemID = null;
        String uuid = SqlSymbolUUIDMappingVisitor.getUuidString(elemName);
        if (uuid != null) {
            return this.findEObjectInResourceSet(uuid);
        }
        return elemID;
    }

    private Object getGroupIDFromName(String grpName) {
        Object grpID = null;
        String uuid = SqlSymbolUUIDMappingVisitor.getUuidString(grpName);
        if (uuid != null) {
            return this.findEObjectInResourceSet(grpName);
        }
        return grpID;
    }

    public static String getUuidString(String str) {
        if (str == null) {
            return null;
        }
        String strLower = str.toLowerCase();
        int index = strLower.indexOf("mmuuid");
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            return strLower;
        }
        if (strLower.length() == index + 43) {
            return strLower.substring(index);
        }
        if (strLower.length() > index + 43) {
            return strLower.substring(index, index + 43);
        }
        return null;
    }

    private EObject findEObjectInResourceSet(String uuid) {
        Iterator iter = this.emfResources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            EObject eObj = resource.getEObject(uuid);
            if (eObj == null) continue;
            return eObj;
        }
        return null;
    }

    public static String getSqlEObjectName(EObject eObject) {
        String returnString = "NULL";
        SqlAspect aspect = SqlSymbolUUIDMappingVisitor.getSqlAspect(eObject);
        if (aspect != null) {
            returnString = aspect.getName(eObject);
        }
        return returnString;
    }

    public static String getSqlEObjectFullName(EObject eObject) {
        String returnString = "NULL";
        SqlAspect aspect = SqlSymbolUUIDMappingVisitor.getSqlAspect(eObject);
        if (aspect != null) {
            returnString = aspect.getFullName(eObject);
        }
        return returnString;
    }

    protected static String getSqlEObjectParentName(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        EObject parent = eObject.eContainer();
        if (parent != null) {
            SqlAspect parentAspect = SqlSymbolUUIDMappingVisitor.getSqlAspect(parent);
            while (parentAspect != null) {
                if (parentAspect instanceof SqlTableAspect) {
                    return parentAspect.getName(parent);
                }
                if ((parent = parent.eContainer()) != null) {
                    parentAspect = SqlSymbolUUIDMappingVisitor.getSqlAspect(parent);
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    protected static String getSqlEObjectParentFullName(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        EObject parent = eObject.eContainer();
        if (parent != null) {
            SqlAspect parentAspect = SqlSymbolUUIDMappingVisitor.getSqlAspect(parent);
            while (parentAspect != null) {
                if (parentAspect instanceof SqlTableAspect) {
                    return parentAspect.getFullName(parent);
                }
                if ((parent = parent.eContainer()) != null) {
                    parentAspect = SqlSymbolUUIDMappingVisitor.getSqlAspect(parent);
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    protected static SqlAspect getSqlAspect(EObject eObject) {
        return AspectManager.getSqlAspect(eObject);
    }
}

