/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.modeler.internal.transformation.util.SqlConstants;

public final class SqlStringUtil
implements SqlConstants {
    public static int getSelectIndex(String SQLString) {
        int selectReturnIndx;
        int selectSpaceIndx = SqlStringUtil.getSelectSpaceIndex(SQLString);
        if (selectSpaceIndx > (selectReturnIndx = SqlStringUtil.getSelectReturnIndex(SQLString))) {
            return selectSpaceIndx;
        }
        return selectReturnIndx;
    }

    private static int getSelectSpaceIndex(String SQLString) {
        String SQLUpper = SQLString.toUpperCase();
        int index = SQLUpper.indexOf("SELECT ");
        return index;
    }

    private static int getSelectReturnIndex(String SQLString) {
        String SQLUpper = SQLString.toUpperCase();
        int index = SQLUpper.indexOf("SELECT\n");
        return index;
    }

    public static int getFromIndex(String SQLString) {
        int fromReturnIndx;
        int fromSpaceIndx = SqlStringUtil.getFromSpaceIndex(SQLString);
        if (fromSpaceIndx > (fromReturnIndx = SqlStringUtil.getFromReturnIndex(SQLString))) {
            return fromSpaceIndx;
        }
        return fromReturnIndx;
    }

    private static int getFromSpaceIndex(String SQLString) {
        String SQLUpper = SQLString.toUpperCase();
        int startIndex = 0;
        int index = SQLUpper.indexOf("FROM ", startIndex);
        while (index > 0) {
            String preceding = SQLString.substring(index - 1, index);
            if ("\n".equals(preceding) || " ".equals(preceding)) {
                return index;
            }
            startIndex = index + 1;
            index = SQLUpper.indexOf("FROM ", startIndex);
        }
        if (SQLUpper.endsWith("FROM")) {
            index = SQLUpper.lastIndexOf("FROM");
        }
        return index;
    }

    private static int getFromReturnIndex(String SQLString) {
        String SQLUpper = SQLString.toUpperCase();
        int startIndex = 0;
        int index = SQLUpper.indexOf("FROM\n", startIndex);
        while (index > 0) {
            String preceding = SQLString.substring(index - 1, index);
            if ("\n".equals(preceding) || " ".equals(preceding)) {
                return index;
            }
            startIndex = index + 1;
            index = SQLUpper.indexOf("FROM\n", startIndex);
        }
        if (SQLUpper.endsWith("FROM")) {
            index = SQLUpper.lastIndexOf("FROM");
        }
        return index;
    }

    public static int getWhereIndex(String SQLString) {
        int whereReturnIndx;
        int whereSpaceIndx = SqlStringUtil.getWhereSpaceIndex(SQLString);
        if (whereSpaceIndx > (whereReturnIndx = SqlStringUtil.getWhereReturnIndex(SQLString))) {
            return whereSpaceIndx;
        }
        return whereReturnIndx;
    }

    private static int getWhereSpaceIndex(String SQLString) {
        String SQLUpper = SQLString.toUpperCase();
        int startIndex = 0;
        int index = SQLUpper.indexOf("WHERE ", startIndex);
        while (index > 0) {
            String preceding = SQLString.substring(index - 1, index);
            if ("\n".equals(preceding) || " ".equals(preceding)) {
                return index;
            }
            startIndex = index + 1;
            index = SQLUpper.indexOf("WHERE ", startIndex);
        }
        if (SQLString.endsWith("WHERE")) {
            index = SQLUpper.lastIndexOf("WHERE");
        }
        return index;
    }

    private static int getWhereReturnIndex(String SQLString) {
        String SQLUpper = SQLString.toUpperCase();
        int startIndex = 0;
        int index = SQLUpper.indexOf("WHERE\n", startIndex);
        while (index > 0) {
            String preceding = SQLString.substring(index - 1, index);
            if ("\n".equals(preceding) || " ".equals(preceding)) {
                return index;
            }
            startIndex = index + 1;
            index = SQLUpper.indexOf("WHERE\n", startIndex);
        }
        if (SQLString.endsWith("WHERE")) {
            index = SQLUpper.lastIndexOf("WHERE");
        }
        return index;
    }

    public static String getSelectString(String SQLString, boolean includeSelect) {
        int selectIndex = SqlStringUtil.getSelectIndex(SQLString);
        int fromIndex = SqlStringUtil.getFromIndex(SQLString);
        int whereIndex = SqlStringUtil.getWhereIndex(SQLString);
        String result = "";
        int offset = "SELECT".length();
        if (includeSelect) {
            offset = 0;
        }
        if (selectIndex != -1) {
            result = fromIndex != -1 ? SQLString.substring(selectIndex + offset, fromIndex) : (whereIndex != -1 ? SQLString.substring(selectIndex + offset, whereIndex) : SQLString.substring(selectIndex + offset));
        }
        return result;
    }

    public static String getFromString(String SQLString, boolean includeFrom) {
        int fromIndex = SqlStringUtil.getFromIndex(SQLString);
        int whereIndex = SqlStringUtil.getWhereIndex(SQLString);
        String result = "";
        int offset = "FROM".length();
        if (includeFrom) {
            offset = 0;
        }
        if (fromIndex != -1) {
            result = whereIndex != -1 ? SQLString.substring(fromIndex + offset, whereIndex) : SQLString.substring(fromIndex + offset);
        }
        return result;
    }

    public static String getWhereString(String SQLString, boolean includeWhere) {
        int whereIndex = SqlStringUtil.getWhereIndex(SQLString);
        String result = "";
        int offset = "WHERE".length();
        if (includeWhere) {
            offset = 0;
        }
        if (whereIndex != -1) {
            result = SQLString.substring(whereIndex + offset);
        }
        return result;
    }

    public static boolean hasSelect(String SQLString) {
        String selectString = SqlStringUtil.getSelectString(SQLString, false);
        return selectString.trim().length() > 0;
    }

    public static boolean hasFrom(String SQLString) {
        String fromString = SqlStringUtil.getFromString(SQLString, false);
        return fromString.trim().length() > 0;
    }

    public static boolean hasWhere(String SQLString) {
        String whereString = SqlStringUtil.getWhereString(SQLString, false);
        return whereString.trim().length() > 0;
    }

    public static String appendToFrom(String SQLString, String appendString) {
        String selectString = SqlStringUtil.getSelectString(SQLString, true);
        String whereString = SqlStringUtil.getWhereString(SQLString, true);
        if (!SqlStringUtil.hasFrom(SQLString)) {
            return selectString + "FROM" + " " + appendString + " " + whereString;
        }
        String fromString = SqlStringUtil.getFromString(SQLString, true);
        return selectString + fromString + "," + appendString + " " + whereString;
    }

    public static String replaceSelect(String SQLString, String selectString) {
        String fromString = SqlStringUtil.getFromString(SQLString, true);
        String whereString = SqlStringUtil.getWhereString(SQLString, false);
        whereString = whereString.trim().length() != 0 ? SqlStringUtil.getWhereString(SQLString, true) : "";
        StringBuffer resultBuffer = new StringBuffer(selectString.trim());
        if (selectString.trim().length() != 0) {
            resultBuffer.append(" ");
        }
        resultBuffer.append(fromString.trim());
        if (fromString.trim().length() != 0 && whereString.trim().length() != 0) {
            resultBuffer.append(" ");
        }
        resultBuffer.append(whereString.trim());
        return resultBuffer.toString();
    }

    public static String replaceFrom(String SQLString, String fromString) {
        String selectString = SqlStringUtil.getSelectString(SQLString, true);
        String whereString = SqlStringUtil.getWhereString(SQLString, true);
        StringBuffer resultBuffer = new StringBuffer(selectString.trim());
        if (selectString.trim().length() != 0) {
            resultBuffer.append(" ");
        }
        resultBuffer.append(fromString.trim());
        if (fromString.trim().length() != 0 && whereString.trim().length() != 0) {
            resultBuffer.append(" ");
        }
        resultBuffer.append(whereString.trim());
        return resultBuffer.toString();
    }

    public static void replaceAll(StringBuffer source, String search, String replace) {
        if (source != null && search != null && search.length() > 0 && replace != null) {
            int start = source.toString().indexOf(search);
            while (start > -1) {
                int end = start + search.length();
                source.replace(start, end, replace);
                start = source.toString().indexOf(search, start + replace.length());
            }
        }
    }
}

