/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.UUID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.transformation.util.SqlSymbolUUIDMappingVisitor;
import com.metamatrix.modeler.internal.transformation.util.SymbolUUIDMappingVisitor;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.query.d.b;
import com.metamatrix.query.f.c.e;
import com.metamatrix.query.o.g.d;
import com.metamatrix.query.o.j.l;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class SqlConverter {
    public static final char DELIMITER_CHAR = '.';
    private static final String PREFIXED_OBJECT_ID_KEY = ".mmuuid:";
    private static final String PREFIXED_OBJECT_ID_KEY_UCASE = '.' + UUID.PROTOCOL_UCASE + ':';
    private static final String DELIMITED_PROTOCOL = "mmuuid:";
    private static final String DELIMITED_PROTOCOL_UCASE = UUID.PROTOCOL_UCASE + ':';
    private static final int DELIMITED_PROTOCOL_LENGTH = "mmuuid:".length();
    private static final SymbolUUIDMappingVisitor MAPPING_VISITOR = new SymbolUUIDMappingVisitor();
    private static final List SYSTEM_RESOURCES = Arrays.asList(ModelerCore.getSystemVdbResources());
    static /* synthetic */ Class class$com$metamatrix$metamodels$transformation$SqlTransformationMappingRoot;

    public static String convertToUID(String sqlString, EObject transMappingRoot, int cmdType) {
        return SqlConverter.convertToUID(sqlString, transMappingRoot, cmdType, false);
    }

    public static String convertToUID(String sqlString, EObject transMappingRoot, int cmdType, boolean scopeSearch) {
        return SqlConverter.convertSql(sqlString, transMappingRoot, cmdType, true, scopeSearch, null);
    }

    public static String convertToString(String sqlString, EObject transMappingRoot, int cmdType) {
        return SqlConverter.convertToString(sqlString, transMappingRoot, cmdType, false, null);
    }

    public static String convertToString(String sqlString, EObject transMappingRoot, int cmdType, boolean restrictSearch) {
        return SqlConverter.convertSql(sqlString, transMappingRoot, cmdType, false, restrictSearch, null);
    }

    public static String convertToString(String sqlString, EObject transMappingRoot, int cmdType, boolean restrictSearch, ValidationContext context) {
        return SqlConverter.convertSql(sqlString, transMappingRoot, cmdType, false, restrictSearch, context);
    }

    private static synchronized String convertSql(String sqlString, EObject transMappingRoot, int cmdType, boolean convertSymbolsToUUIDs, boolean restrictSearch, ValidationContext context) {
        if (StringUtil.isEmpty(sqlString)) {
            return null;
        }
        ArgCheck.isInstanceOf(class$com$metamatrix$metamodels$transformation$SqlTransformationMappingRoot == null ? (class$com$metamatrix$metamodels$transformation$SqlTransformationMappingRoot = SqlConverter.class$("com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot")) : class$com$metamatrix$metamodels$transformation$SqlTransformationMappingRoot, transMappingRoot);
        SqlTransformationMappingRoot sqlTransMappingRoot = (SqlTransformationMappingRoot)transMappingRoot;
        TransformationValidator validator = new TransformationValidator(sqlTransMappingRoot, context, false, restrictSearch);
        try {
            e validationResult = validator.validateSql(sqlString, cmdType, !convertSymbolsToUUIDs, false);
            if (convertSymbolsToUUIDs && !validationResult.isValidatable()) {
                return null;
            }
            if (validationResult.isValidatable()) {
                l command = validationResult.getCommand();
                MAPPING_VISITOR.convertToUUID(convertSymbolsToUUIDs);
                MAPPING_VISITOR.setQueryMetadata(validator.getQueryMetadata());
                d.d5(command, MAPPING_VISITOR);
                String newString = command.toString();
                if (!convertSymbolsToUUIDs && StringUtil.indexOfIgnoreCase(newString, "mmuuid") != -1) {
                    Container container = context != null ? context.getResourceContainer() : ModelerCore.getContainer(sqlTransMappingRoot);
                    return SqlConverter.convertUUIDsToFullNames(newString, container);
                }
                return newString;
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (!convertSymbolsToUUIDs && StringUtil.indexOfIgnoreCase(sqlString, "mmuuid") != -1) {
            Container container = context != null ? context.getResourceContainer() : ModelerCore.getContainer(sqlTransMappingRoot);
            return SqlConverter.convertUUIDsToFullNames(sqlString, container);
        }
        return sqlString;
    }

    public static synchronized String convertSql(String sqlString, ResourceSet resourceSet, int cmdType) {
        List eResources = resourceSet != null ? resourceSet.getResources() : Collections.EMPTY_LIST;
        return SqlConverter.convertSql(sqlString, eResources, cmdType);
    }

    public static synchronized String convertSql(String sqlString, Collection eResources, int cmdType) {
        if (StringUtil.isEmpty(sqlString)) {
            return null;
        }
        ArgCheck.isNotNull(eResources);
        l command = null;
        try {
            b parser = new b();
            command = parser.f(sqlString);
        }
        catch (Exception e2) {
            TransformationPlugin.Util.log(4, e2, e2.getLocalizedMessage());
        }
        if (command != null) {
            SqlSymbolUUIDMappingVisitor sqlMappingVisitor = new SqlSymbolUUIDMappingVisitor();
            sqlMappingVisitor.setResources(eResources);
            d.d5(command, sqlMappingVisitor);
            String newString = command.toString();
            return newString;
        }
        return null;
    }

    public static String convertUUIDsToFullNames(String uuidString, Container containerContext) {
        String result;
        int i2;
        if (containerContext == null) {
            return uuidString;
        }
        StringBuffer buf = new StringBuffer();
        String idToken = "mmuuid";
        int uuidLength = 43;
        if (uuidString == null) {
            return buf.toString();
        }
        boolean requiresSpecialProcessing = false;
        int index = uuidString.indexOf("mmuuid");
        if (index == -1) {
            return uuidString;
        }
        buf.append(uuidString.substring(0, index));
        while (index != -1) {
            String id = null;
            try {
                id = uuidString.substring(index, index + 43);
                ObjectID uuid = IDGenerator.getInstance().stringToObject(id, "mmuuid");
                EObject obj = (EObject)containerContext.getEObjectFinder().find(uuid);
                if (obj != null) {
                    SqlAspect aspect = AspectManager.getSqlAspect(obj);
                    String name = null;
                    if (aspect != null) {
                        name = index > 0 && uuidString.charAt(index - 1) == '.' ? aspect.getName(obj) : aspect.getFullName(obj);
                    }
                    if (!StringUtil.isEmpty(name)) {
                        buf.append(name);
                    } else if (uuidString.charAt(index + 43) == ',') {
                        ++index;
                    } else {
                        requiresSpecialProcessing = true;
                    }
                } else {
                    obj = SqlConverter.findEobjectInSystemResources(((Object)uuid).toString());
                    buf.append(id);
                }
                int nextIndex = uuidString.indexOf("mmuuid", index + 43);
                if (nextIndex == -1) {
                    buf.append(uuidString.substring(index + 43));
                    break;
                }
                buf.append(uuidString.substring(index + 43, nextIndex));
                index = nextIndex;
            }
            catch (InvalidIDException e2) {
                buf.append(id);
                int nextIndex = uuidString.indexOf("mmuuid", index + 43);
                buf.append(uuidString.substring(index + 43, nextIndex));
                index = nextIndex;
            }
        }
        if (requiresSpecialProcessing && (i2 = StringUtil.indexOfIgnoreCase(result = buf.toString().toUpperCase(), "WHERE")) > -1) {
            boolean done = false;
            while (!done) {
                char next;
                if ((next = buf.charAt(--i2)) == ',') {
                    done = true;
                    buf.deleteCharAt(i2);
                    continue;
                }
                if (!Character.isLetterOrDigit(next)) continue;
                done = true;
            }
        }
        return buf.toString();
    }

    public static String convertUUIDsToFullNames(String uuidString, Collection eResources) {
        String result;
        int i2;
        StringBuffer buf = new StringBuffer();
        int uuidLength = 43;
        if (uuidString == null) {
            return buf.toString();
        }
        boolean requiresSpecialProcessing = false;
        int index = uuidString.indexOf("mmuuid");
        if (index == -1) {
            return uuidString;
        }
        buf.append(uuidString.substring(0, index));
        while (index != -1) {
            String id = null;
            try {
                id = uuidString.substring(index, index + 43);
                ObjectID uuid = IDGenerator.getInstance().stringToObject(id, "mmuuid");
                EObject obj = SqlConverter.findEObjectInResourceSet(((Object)uuid).toString(), eResources);
                if (obj != null) {
                    SqlAspect aspect = AspectManager.getSqlAspect(obj);
                    String name = null;
                    if (aspect != null) {
                        name = index > 0 && uuidString.charAt(index - 1) == '.' ? aspect.getName(obj) : aspect.getFullName(obj);
                    }
                    if (!StringUtil.isEmpty(name)) {
                        buf.append(name);
                    } else if (uuidString.charAt(index + 43) == ',') {
                        ++index;
                    } else {
                        requiresSpecialProcessing = true;
                    }
                } else {
                    buf.append(id);
                }
                int nextIndex = uuidString.indexOf("mmuuid", index + 43);
                if (nextIndex == -1) {
                    buf.append(uuidString.substring(index + 43));
                    break;
                }
                buf.append(uuidString.substring(index + 43, nextIndex));
                index = nextIndex;
            }
            catch (InvalidIDException e2) {
                buf.append(id);
                int nextIndex = uuidString.indexOf("mmuuid", index + 43);
                buf.append(uuidString.substring(index + 43, nextIndex));
                index = nextIndex;
            }
        }
        if (requiresSpecialProcessing && (i2 = StringUtil.indexOfIgnoreCase(result = buf.toString().toUpperCase(), "WHERE")) > -1) {
            boolean done = false;
            while (!done) {
                char next;
                if ((next = buf.charAt(--i2)) == ',') {
                    done = true;
                    buf.deleteCharAt(i2);
                    continue;
                }
                if (!Character.isLetterOrDigit(next)) continue;
                done = true;
            }
        }
        return buf.toString();
    }

    private static EObject findEObjectInResourceSet(String uuid, Collection eResources) {
        Iterator iter = eResources.iterator();
        while (iter.hasNext()) {
            EObject eObj;
            Resource resource = (Resource)iter.next();
            if (!(resource instanceof EmfResource)) continue;
            if (!resource.isLoaded()) {
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException e2) {
                    TransformationPlugin.Util.log(4, e2.getLocalizedMessage());
                }
            }
            if ((eObj = resource.getEObject(uuid)) == null) continue;
            return eObj;
        }
        return SqlConverter.findEobjectInSystemResources(uuid);
    }

    private static EObject findEobjectInSystemResources(String uuid) {
        Iterator iter = SYSTEM_RESOURCES.iterator();
        while (iter.hasNext()) {
            EObject eObj;
            Resource resource = (Resource)iter.next();
            if (!(resource instanceof EmfResource) || (eObj = resource.getEObject(uuid)) == null) continue;
            return eObj;
        }
        return null;
    }

    public static boolean isStringifiedUUID(String str) {
        boolean result = false;
        try {
            String string = SqlConverter.stripPrefixFromUUID(str);
            int index = string.indexOf(DELIMITED_PROTOCOL);
            if (index == -1) {
                index = string.indexOf(DELIMITED_PROTOCOL_UCASE);
            }
            if (index != -1) {
                string = string.substring(index += DELIMITED_PROTOCOL_LENGTH);
                UUID.stringToObject(string);
                result = true;
            } else {
                result = false;
            }
        }
        catch (InvalidIDException e2) {
            result = false;
        }
        return result;
    }

    public static String stripPrefixFromUUID(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(PREFIXED_OBJECT_ID_KEY);
        if (index == -1) {
            index = str.indexOf(PREFIXED_OBJECT_ID_KEY_UCASE);
        }
        if (index != -1) {
            return str.substring(index + 1);
        }
        return str;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

