/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.query.function.a;
import com.metamatrix.query.function.b;
import com.metamatrix.query.function.g;
import com.metamatrix.query.o.i.c;
import com.metamatrix.query.o.i.e;
import com.metamatrix.query.o.i.s;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class RuntimeTypeConverter {
    private boolean[] compatible;
    private boolean explicitMatch;
    private ArrayList primaryCandidates;
    private boolean[] primaryConverted;
    private boolean primaryLocked;
    private String primaryName = "Primary";
    private Object primaryObj;
    private List primaryResults;
    private int primarySize;
    private ArrayList secondaryCandidates;
    private boolean[] secondaryConverted;
    private boolean secondaryLocked;
    private String secondaryName = "Secondary";
    private Object secondaryObj;
    private List secondaryResults;
    private int secondarySize;
    private int size;
    private boolean unwrap;
    static /* synthetic */ Class class$com$metamatrix$common$types$NullType;

    public RuntimeTypeConverter(List thePrimaryCandidates, List theSecondaryCandidates) {
        this(thePrimaryCandidates, false, theSecondaryCandidates, false);
    }

    public RuntimeTypeConverter(List thePrimaryCandidates, boolean thePrimaryCandidatesLockedFlag, List theSecondaryCandidates, boolean theSecondaryCandidatesLockedFlag) {
        if (thePrimaryCandidates == null || theSecondaryCandidates == null) {
            throw new IllegalArgumentException("RuntimeTypeConverter.init:Primary or secondary candidate list is null.");
        }
        this.primarySize = thePrimaryCandidates.size();
        this.secondarySize = theSecondaryCandidates.size();
        this.size = Math.max(this.primarySize, this.secondarySize);
        this.primaryCandidates = new ArrayList(this.primarySize);
        this.primaryCandidates.addAll(thePrimaryCandidates);
        this.primaryLocked = thePrimaryCandidatesLockedFlag;
        this.primaryConverted = new boolean[this.primarySize];
        this.primaryResults = (List)this.primaryCandidates.clone();
        this.secondaryCandidates = new ArrayList(this.secondarySize);
        this.secondaryCandidates.addAll(theSecondaryCandidates);
        this.secondaryLocked = theSecondaryCandidatesLockedFlag;
        this.secondaryConverted = new boolean[this.secondarySize];
        this.secondaryResults = (List)this.secondaryCandidates.clone();
        this.compatible = new boolean[this.size];
        this.explicitMatch = false;
        this.unwrap = true;
        this.setCompatibility();
        this.setExplicitMatch();
    }

    public boolean canChangeType(Object theObject) {
        return theObject != null && TransformationHelper.isSqlColumn(theObject);
    }

    private boolean canConvert(Object theCandidate, String theType) {
        return this.convert(theCandidate, theType) != null;
    }

    public boolean canConvertPrimaryCandidate(int theIndex) {
        boolean result;
        this.validateIndex(theIndex, this.size, "canConvertPrimaryCandidate(Object, String)");
        boolean bl = result = !this.primaryLocked && !this.isCompatible(theIndex) && theIndex < this.primarySize && theIndex < this.secondarySize;
        if (result) {
            Object candidate = this.primaryCandidates.get(theIndex);
            String type = RuntimeTypeConverter.getRuntimeType(this.secondaryCandidates.get(theIndex));
            result = this.canConvert(candidate, type);
        }
        return result;
    }

    public boolean canConvertSecondaryCandidate(int theIndex) {
        boolean result;
        this.validateIndex(theIndex, this.size, "canConvertSecondaryCandidate(Object, String)");
        boolean bl = result = !this.secondaryLocked && !this.isCompatible(theIndex) && theIndex < this.primarySize && theIndex < this.secondarySize;
        if (result) {
            Object candidate = this.secondaryCandidates.get(theIndex);
            String type = RuntimeTypeConverter.getRuntimeType(this.primaryCandidates.get(theIndex));
            result = this.canConvert(candidate, type);
        }
        return result;
    }

    public boolean changeType(int theIndex, Object theType, boolean thePrimaryFlag) {
        Object obj;
        ArrayList candidates;
        Object candidate;
        this.validateIndex(theIndex, thePrimaryFlag ? this.primarySize : this.secondarySize, "changeType(int, ObjectReference, boolean)");
        boolean result = false;
        if (!this.isCompatible(theIndex) && this.canChangeType(candidate = (candidates = thePrimaryFlag ? this.primaryCandidates : this.secondaryCandidates).get(theIndex)) && (obj = this.convert(candidate, RuntimeTypeConverter.getRuntimeType(theType))) != null) {
            List candidateResults = thePrimaryFlag ? this.primaryResults : this.secondaryResults;
            candidateResults.set(theIndex, obj);
            boolean[] converted = thePrimaryFlag ? this.primaryConverted : this.secondaryConverted;
            converted[theIndex] = true;
            this.compatible[theIndex] = true;
            result = true;
        }
        return result;
    }

    public void commit() {
    }

    public boolean convert() {
        boolean result = true;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.isCompatible(i2) || this.convertSecondaryCandidate(i2) || this.convertPrimaryCandidate(i2)) continue;
            result = false;
        }
        return result;
    }

    private Object convert(Object theCandidate, String theRuntimeType) {
        e result = null;
        String primaryType = RuntimeTypeConverter.getRuntimeType(theCandidate);
        if ((DataTypeManager.isExplicitConversion(primaryType, theRuntimeType) || DataTypeManager.isImplicitConversion(primaryType, theRuntimeType)) && !(theCandidate instanceof EObject) && theCandidate instanceof s) {
            result = this.createConversionFunction((s)theCandidate, primaryType, theRuntimeType);
        }
        return result;
    }

    public boolean convertPrimaryCandidate(int theIndex) {
        this.validateIndex(theIndex, this.primarySize, "convertPrimaryCandidate(int)");
        if (!this.compatible[theIndex] && !this.primaryLocked && theIndex < this.secondarySize) {
            Object secondaryCandidate;
            String secondaryType;
            this.primaryConverted[theIndex] = false;
            Object primaryCandidate = this.getBaseObject(this.primaryCandidates.get(theIndex));
            Object obj = this.convert(primaryCandidate, secondaryType = RuntimeTypeConverter.getRuntimeType(secondaryCandidate = this.getBaseObject(this.secondaryCandidates.get(theIndex))));
            if (obj != null) {
                this.primaryResults.set(theIndex, obj);
                this.primaryConverted[theIndex] = true;
                this.compatible[theIndex] = true;
            }
        }
        return this.primaryConverted[theIndex];
    }

    public boolean convertSecondaryCandidate(int theIndex) {
        this.validateIndex(theIndex, this.secondarySize, "convertSecondaryCandidate(int)");
        if (!this.compatible[theIndex] && !this.secondaryLocked && theIndex < this.primarySize) {
            this.secondaryConverted[theIndex] = false;
            Object primaryCandidate = this.getBaseObject(this.primaryCandidates.get(theIndex));
            String primaryType = RuntimeTypeConverter.getRuntimeType(primaryCandidate);
            Object secondaryCandidate = this.getBaseObject(this.secondaryCandidates.get(theIndex));
            Object obj = this.convert(secondaryCandidate, primaryType);
            if (obj != null) {
                this.secondaryResults.set(theIndex, obj);
                this.secondaryConverted[theIndex] = true;
                this.compatible[theIndex] = true;
            }
        }
        return this.secondaryConverted[theIndex];
    }

    public e createConversionFunction(s theExpression, String theOriginalTypeName, String theNewTypeName) {
        Class originalType = DataTypeManager.getDataTypeClass(theOriginalTypeName);
        b library = g.b();
        a fd = library.f("convert", new Class[]{originalType, DataTypeManager.DefaultDataClasses.STRING});
        e function = new e(fd.c(), new s[]{theExpression, new c(theNewTypeName)});
        function.bu(DataTypeManager.getDataTypeClass(theNewTypeName));
        function.bt(fd);
        return function;
    }

    private Object getBaseObject(Object theObj) {
        String functionName;
        Object result = theObj;
        if (this.unwrap && theObj instanceof e && ((functionName = ((e)theObj).bx()).equals("cast") || functionName.equals("convert"))) {
            result = this.getBaseObject(((e)theObj).bw(0));
        }
        return result;
    }

    private Object getCandidateResultAt(int theIndex, boolean thePrimaryFlag) {
        this.validateIndex(theIndex, thePrimaryFlag ? this.primarySize : this.secondarySize, "getCandidateResultAt(int, boolean");
        List candidates = thePrimaryFlag ? this.primaryResults : this.secondaryResults;
        return candidates.get(theIndex);
    }

    private List getCandidateResults(boolean thePrimaryFlag) {
        int numCandidates = thePrimaryFlag ? this.primarySize : this.secondarySize;
        ArrayList<Object> result = new ArrayList<Object>(numCandidates);
        for (int i2 = 0; i2 < numCandidates; ++i2) {
            result.add(this.getCandidateResultAt(i2, thePrimaryFlag));
        }
        return result;
    }

    public int getIncompatibleCount() {
        int result = 0;
        for (int i2 = 0; i2 < this.compatible.length; ++i2) {
            if (this.isCompatible(i2)) continue;
            ++result;
        }
        return result;
    }

    private String getName(boolean thePrimaryFlag) {
        Object obj;
        String result = thePrimaryFlag ? this.primaryName : this.secondaryName;
        Object object = obj = thePrimaryFlag ? this.primaryObj : this.secondaryObj;
        if (obj != null && obj instanceof EObject && TransformationHelper.isSqlColumn(obj)) {
            EObject eObj = (EObject)obj;
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect(eObj);
            result = columnAspect.getFullName(eObj);
        }
        return result;
    }

    public Object getPrimaryCandidateAt(int theIndex) {
        this.validateIndex(theIndex, this.primarySize, "getPrimaryCandidateAt(int)");
        return this.primaryCandidates.get(theIndex);
    }

    public List getPrimaryCandidates() {
        return this.primaryCandidates;
    }

    public String getPrimaryName() {
        return this.getName(true);
    }

    public Object getPrimaryObject() {
        return this.primaryObj;
    }

    public Object getPrimaryResultAt(int theIndex) {
        return this.getCandidateResultAt(theIndex, true);
    }

    public List getPrimaryResults() {
        return this.getCandidateResults(true);
    }

    public static Class getRuntimeClass(Object theObj) {
        Class result = null;
        if (theObj instanceof EObject && TransformationHelper.isSqlColumn(theObj)) {
            String type = RuntimeTypeConverter.getRuntimeType(theObj);
            if (type == null) {
                result = class$com$metamatrix$common$types$NullType == null ? (class$com$metamatrix$common$types$NullType = RuntimeTypeConverter.class$("com.metamatrix.common.types.NullType")) : class$com$metamatrix$common$types$NullType;
            } else if (type != null) {
                result = DataTypeManager.getDataTypeClass(type);
            }
        } else if (theObj instanceof s) {
            result = ((s)theObj).ag();
        } else {
            throw new IllegalArgumentException("RuntimeTypeConverter.getRuntimeClass:Class cannot be determined.");
        }
        return result;
    }

    public static String getRuntimeType(Object theObj) {
        String type = null;
        if (theObj instanceof EObject) {
            EObject eObj = (EObject)theObj;
            DatatypeManager dtMgr = ModelerCore.getDatatypeManager(eObj, true);
            if (TransformationHelper.isSqlColumn(theObj)) {
                SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect(eObj);
                type = columnAspect.getRuntimeType(eObj);
            } else if (dtMgr.isSimpleDatatype((EObject)theObj)) {
                return eObj == null ? "" : dtMgr.getRuntimeTypeName(eObj);
            }
        } else if (theObj instanceof s) {
            Class objClass = ((s)theObj).ag();
            type = objClass == null ? DataTypeManager.getDataTypeName(class$com$metamatrix$common$types$NullType == null ? (class$com$metamatrix$common$types$NullType = RuntimeTypeConverter.class$("com.metamatrix.common.types.NullType")) : class$com$metamatrix$common$types$NullType) : DataTypeManager.getDataTypeName(objClass);
        } else {
            throw new IllegalArgumentException("RuntimeTypeConverter.getRuntimeType:Object type cannot be determined for <" + theObj + ">.");
        }
        return type;
    }

    public Object getSecondaryCandidateAt(int theIndex) {
        this.validateIndex(theIndex, this.secondarySize, "getSecondaryCandidateAt(int)");
        return this.secondaryCandidates.get(theIndex);
    }

    public List getSecondaryCandidates() {
        return this.secondaryCandidates;
    }

    public String getSecondaryName() {
        return this.getName(false);
    }

    public Object getSecondaryObject() {
        return this.secondaryObj;
    }

    public Object getSecondaryResultAt(int theIndex) {
        return this.getCandidateResultAt(theIndex, false);
    }

    public List getSecondaryResults() {
        return this.getCandidateResults(false);
    }

    public boolean getUnwrapExistingConversions() {
        return this.unwrap;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isCompatible() {
        return this.getIncompatibleCount() == 0;
    }

    public boolean isCompatible(int theIndex) {
        this.validateIndex(theIndex, this.size, "isCompatible(int)");
        return this.compatible[theIndex];
    }

    public static boolean isCompatible(String theFirstType, String theSecondType) {
        return theFirstType.equals(theSecondType) || DataTypeManager.getTransform(theFirstType, theSecondType) != null;
    }

    public boolean isConverted() {
        boolean converted = false;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!this.isConverted(i2)) continue;
            converted = true;
            break;
        }
        return converted;
    }

    public boolean isConverted(int theIndex) {
        this.validateIndex(theIndex, this.size, "isConverted(int)");
        boolean result = false;
        if (theIndex < this.primarySize) {
            result = this.isPrimaryConverted(theIndex);
        }
        if (!result && theIndex < this.secondarySize) {
            result = this.isSecondaryConverted(theIndex);
        }
        return result;
    }

    public static boolean isExplicitMatch(Object primaryObj, Object secondaryObj) {
        boolean isExplicitMatch = false;
        if (primaryObj != null && secondaryObj != null) {
            ArrayList<Object> primaryList = new ArrayList<Object>(1);
            ArrayList<Object> secondaryList = new ArrayList<Object>(1);
            primaryList.add(primaryObj);
            secondaryList.add(secondaryObj);
            RuntimeTypeConverter rtc = new RuntimeTypeConverter(primaryList, true, secondaryList, true);
            isExplicitMatch = rtc.isExplicitMatch();
        }
        return isExplicitMatch;
    }

    public boolean isExplicitMatch() {
        return this.explicitMatch;
    }

    public boolean isExplicitMatch(int theIndex) {
        this.validateIndex(theIndex, this.size, "isExplicitMatch(int)");
        boolean result = false;
        if (theIndex < this.primarySize && theIndex < this.secondarySize) {
            Object primaryCandidate = this.primaryCandidates.get(theIndex);
            String primaryType = RuntimeTypeConverter.getRuntimeType(primaryCandidate);
            Object secondaryCandidate = this.secondaryCandidates.get(theIndex);
            String secondaryType = RuntimeTypeConverter.getRuntimeType(secondaryCandidate);
            result = primaryType.equals(secondaryType);
        }
        return result;
    }

    public boolean isLocked() {
        return this.isPrimaryLocked() && this.isSecondaryLocked();
    }

    public boolean isPrimaryConverted(int theIndex) {
        this.validateIndex(theIndex, this.size, "isPrimaryConverted(int)");
        return theIndex < this.primarySize ? this.primaryConverted[theIndex] : false;
    }

    public boolean isPrimaryLocked() {
        return this.primaryLocked;
    }

    public boolean isSecondaryConverted(int theIndex) {
        this.validateIndex(theIndex, this.size, "isSecondaryConverted(int)");
        return theIndex < this.secondarySize ? this.secondaryConverted[theIndex] : false;
    }

    public boolean isSecondaryLocked() {
        return this.secondaryLocked;
    }

    private void resetCandidate(int theIndex, boolean thePrimaryFlag) {
        this.validateIndex(theIndex, thePrimaryFlag ? this.primarySize : this.secondarySize, "resetCandidate(int, boolean");
        if (this.isConverted(theIndex)) {
            ArrayList candidates = thePrimaryFlag ? this.primaryCandidates : this.secondaryCandidates;
            List convertedCandidates = thePrimaryFlag ? this.primaryResults : this.secondaryResults;
            boolean[] convertedFlags = thePrimaryFlag ? this.primaryConverted : this.secondaryConverted;
            convertedCandidates.set(theIndex, candidates.get(theIndex));
            convertedFlags[theIndex] = false;
            this.setCompatibility(theIndex);
        }
    }

    public void resetPrimaryCandidate(int theIndex) {
        this.resetCandidate(theIndex, true);
    }

    public void resetSecondaryCandidate(int theIndex) {
        this.resetCandidate(theIndex, false);
    }

    private void setCandidate(int theIndex, Object theCandidate, boolean thePrimaryFlag) {
        this.validateIndex(theIndex, thePrimaryFlag ? this.primarySize : this.secondarySize, "setCandidate(int, Object, boolean");
        ArrayList candidates = thePrimaryFlag ? this.primaryCandidates : this.secondaryCandidates;
        candidates.set(theIndex, theCandidate);
        List convertedCandidates = thePrimaryFlag ? this.primaryResults : this.secondaryResults;
        convertedCandidates.set(theIndex, theCandidate);
        this.setCompatibility(theIndex);
        this.setExplicitMatch(theIndex);
    }

    private void setCompatibility() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.setCompatibility(i2);
        }
    }

    private void setCompatibility(int theIndex) {
        this.validateIndex(theIndex, this.size, "setCompatibility(int)");
        boolean result = false;
        if (theIndex < this.primarySize && theIndex < this.secondarySize) {
            Object secondary;
            String secondaryType;
            Object primary = this.getPrimaryResultAt(theIndex);
            String primaryType = RuntimeTypeConverter.getRuntimeType(primary);
            result = RuntimeTypeConverter.isCompatible(primaryType, secondaryType = RuntimeTypeConverter.getRuntimeType(secondary = this.getSecondaryResultAt(theIndex))) || RuntimeTypeConverter.isCompatible(secondaryType, primaryType);
        }
        this.compatible[theIndex] = result;
    }

    private void setExplicitMatch() {
        boolean match = true;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.isExplicitMatch(i2)) continue;
            match = false;
            break;
        }
        this.explicitMatch = match;
    }

    private void setExplicitMatch(int theIndex) {
        boolean match = this.isExplicitMatch(theIndex);
        if (match != this.explicitMatch) {
            if (match) {
                boolean foundOne = false;
                for (int i2 = 0; i2 < this.size; ++i2) {
                    if (this.isExplicitMatch(i2)) continue;
                    foundOne = true;
                    break;
                }
                if (!foundOne) {
                    this.explicitMatch = true;
                }
            } else {
                this.explicitMatch = false;
            }
        }
    }

    public void setPrimaryCandidate(int theIndex, Object theCandidate) {
        this.setCandidate(theIndex, theCandidate, true);
    }

    public void setPrimaryName(String theName) {
        this.primaryName = theName;
    }

    public void setPrimaryObject(Object theObject) {
        this.primaryObj = theObject;
    }

    public void setSecondaryCandidate(int theIndex, Object theCandidate) {
        this.setCandidate(theIndex, theCandidate, false);
    }

    public void setSecondaryName(String theName) {
        this.secondaryName = theName;
    }

    public void setSecondaryObject(Object theObject) {
        this.secondaryObj = theObject;
    }

    public String toString() {
        return this.getPrimaryName() + "<->" + this.getSecondaryName();
    }

    public void setUnwrapExistingConversions(boolean theUnwrapFlag) {
        this.unwrap = theUnwrapFlag;
    }

    private void validateIndex(int theIndex, int theSize, String theMethod) {
        if (theSize <= theIndex) {
            throw new IllegalArgumentException(this.getClass().getName() + "." + theMethod + ":Index <" + theIndex + "> is invalid for size of <" + theSize + ">.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

