/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.transaction.SourcedNotification;
import com.metamatrix.modeler.core.workspace.ModelProject;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelResourceReloadVetoListener;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceNotification;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceNotificationListener;
import com.metamatrix.modeler.core.workspace.Openable;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.workspace.DeltaProcessor;
import com.metamatrix.modeler.internal.core.workspace.ModelBufferManager;
import com.metamatrix.modeler.internal.core.workspace.ModelFolderImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelFolderInfo;
import com.metamatrix.modeler.internal.core.workspace.ModelProjectImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelProjectInfo;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceCache;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceItemImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceItemInfo;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceNotificationImpl;
import com.metamatrix.modeler.internal.core.workspace.SearchIndexResourceVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;

public class ModelWorkspaceManager {
    public static boolean VERBOSE = false;
    public static boolean ZIP_ACCESS_VERBOSE = false;
    private static ModelWorkspaceManager manager;
    private ModelWorkspaceImpl modelWorkspace = new ModelWorkspaceImpl();
    private final DeltaProcessor deltaProcessor;
    protected ModelWorkspaceCache cache = new ModelWorkspaceCache();
    protected Container container;
    private final Collection workspaceListeners = new ArrayList();
    private final Collection resourceReloadVetoListeners = new ArrayList();
    protected Map perProjectInfo = new HashMap(5);
    private int indexType = 0;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public static final ModelWorkspaceManager getModelWorkspaceManager() {
        if (manager == null) {
            manager = new ModelWorkspaceManager();
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                workspace.addResourceChangeListener(manager.getDeltaProcessor(), 31);
                manager.initModelWorkspace(workspace);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                ModelerCore.Util.log(4, ModelerCore.Util.getString("ModelWorkspaceManager.Error_encountered_starting_ModelWorkspaceManager_1"));
            }
        }
        return manager;
    }

    public static final void shutdown() throws CoreException {
        if (manager != null) {
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                workspace.removeResourceChangeListener(manager.getDeltaProcessor());
                manager.shutdownManager();
            }
            catch (CoreException e2) {
                throw e2;
            }
            catch (Throwable t2) {
                throw new CoreException(new Status(4, "com.metamatrix.modeler.core", 1, ModelerCore.Util.getString("ModelWorkspaceManager.Error_encountered_shutting_down_ModelWorkspaceManager_2"), t2));
            }
            finally {
                manager = null;
            }
        }
    }

    private ModelWorkspaceManager() {
        this.deltaProcessor = new DeltaProcessor(this);
        try {
            this.addChangeNotifier(ModelerCore.getModelContainer());
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ModelWorkspaceManager.Error_adding_ChangeNotifier_to_the_model_container_{0}_1", e2.getMessage()));
        }
    }

    private void initModelWorkspace(IWorkspace workspace) throws CoreException {
        ArgCheck.isNotNull(workspace);
        ModelIResourceCollectorVisitor resourceVisitor = new ModelIResourceCollectorVisitor();
        workspace.getRoot().accept(resourceVisitor);
        List resources = resourceVisitor.getResources();
        IResourceComparator comparator = new IResourceComparator();
        Collections.sort(resources, comparator);
        Iterator resourceIter = resources.iterator();
        while (resourceIter.hasNext()) {
            IResource resource = (IResource)resourceIter.next();
            ModelWorkspaceItem workspaceItem = ModelWorkspaceManager.create(resource, null);
            if (resource.getType() != 4 && resource.getType() != 8 || !(workspaceItem instanceof Openable)) continue;
            ((Openable)((Object)workspaceItem)).open(null);
        }
    }

    public DeltaProcessor getDeltaProcessor() {
        return this.deltaProcessor;
    }

    public void addModelResourceReloadVetoListener(ModelResourceReloadVetoListener listener) {
        ArgCheck.isNotNull(listener);
        if (this.resourceReloadVetoListeners.contains(listener)) {
            return;
        }
        this.resourceReloadVetoListeners.add(listener);
    }

    public void removeModelResourceReloadVetoListener(ModelResourceReloadVetoListener listener) {
        ArgCheck.isNotNull(listener);
        this.resourceReloadVetoListeners.remove(listener);
    }

    public void removeAllModelResourceReloadVetoListeners() {
        this.resourceReloadVetoListeners.clear();
    }

    Collection getModelResourceReloadVetoListeners() {
        return new ArrayList(this.resourceReloadVetoListeners);
    }

    public boolean canReload(ModelResource modelResource) {
        Collection listeners = this.getModelResourceReloadVetoListeners();
        if (listeners.size() != 0) {
            Iterator iter = this.getModelResourceReloadVetoListeners().iterator();
            while (iter.hasNext()) {
                ModelResourceReloadVetoListener listener = (ModelResourceReloadVetoListener)iter.next();
                boolean canReload = listener.canReload(modelResource);
                if (canReload) continue;
                return false;
            }
        }
        return true;
    }

    public void addNotificationListener(ModelWorkspaceNotificationListener listener) {
        ArgCheck.isNotNull(listener);
        if (this.workspaceListeners.contains(listener)) {
            return;
        }
        this.workspaceListeners.add(listener);
    }

    public void removeNotificationListener(ModelWorkspaceNotificationListener listener) {
        this.workspaceListeners.remove(listener);
    }

    public void removeAllNotificationListeners() {
        this.workspaceListeners.clear();
    }

    Collection getNotificationListeners() {
        return new ArrayList(this.workspaceListeners);
    }

    public void fire(ModelWorkspaceNotification notification) throws CoreException {
        ArgCheck.isNotNull(notification);
        IResourceDelta delta = notification.getDelta();
        int eventType = notification.getEventType();
        boolean reloadedResource = false;
        if (delta != null && notification.isPostChange()) {
            reloadedResource = this.changeWorkspace(notification);
        }
        if (notification.isPreDelete()) {
            reloadedResource = this.changeWorkspace(notification);
        }
        if (eventType == 52 && notification.isProject() && notification.getNotifier() instanceof IProject) {
            this.deleteIndexes((IProject)notification.getNotifier());
        }
        Iterator listenIter = this.getNotificationListeners().iterator();
        block9: while (listenIter.hasNext()) {
            ModelWorkspaceNotificationListener listener = (ModelWorkspaceNotificationListener)listenIter.next();
            switch (eventType) {
                case 3: {
                    listener.notifyAdd(notification);
                    continue block9;
                }
                case 4: {
                    listener.notifyRemove(notification);
                    continue block9;
                }
                case 7: {
                    listener.notifyMove(notification);
                    continue block9;
                }
                case 1: {
                    listener.notifyRename(notification);
                    continue block9;
                }
                case 50: {
                    listener.notifyChanged(notification);
                    if (!reloadedResource) continue block9;
                    ModelWorkspaceNotificationImpl reloadedNotification = new ModelWorkspaceNotificationImpl(53, notification.getDelta(), ((ModelWorkspaceNotificationImpl)notification).getChangeEvent());
                    listener.notifyReloaded(reloadedNotification);
                    continue block9;
                }
                case 51: {
                    listener.notifyOpen(notification);
                    continue block9;
                }
                case 52: {
                    listener.notifyClosing(notification);
                    continue block9;
                }
            }
            throw new ModelerCoreException(ModelerCore.Util.getString("ModelWorkspaceManager.Illegal_notification,_notification_type_not_recognized___1") + eventType);
        }
    }

    public boolean deleteIndexes(IResource theResource) throws CoreException {
        return this.deleteIndexes(theResource, new SearchIndexResourceVisitor());
    }

    public boolean deleteIndexes(IResource theResource, SearchIndexResourceVisitor theVisitor) throws CoreException {
        theResource.accept(theVisitor);
        File[] indexFiles = theVisitor.getIndexFiles();
        return IndexUtil.deleteIndexFiles(indexFiles, true);
    }

    private boolean changeWorkspace(ModelWorkspaceNotification notification) throws CoreException {
        IResource resource = (IResource)notification.getNotifier();
        IProject iProject = resource.getProject();
        if (iProject.exists() && iProject.isOpen() && !ModelerCore.hasModelNature(iProject)) {
            return false;
        }
        if (resource.getType() == 1) {
            if (!ModelUtil.isModelFile(resource, false) && !ModelUtil.isVdbArchiveFile(resource)) {
                return false;
            }
            this.setIndexType(0);
        } else if (resource.getType() != 4 && resource.getType() != 2) {
            return false;
        }
        ModelProjectImpl project = (ModelProjectImpl)this.modelWorkspace.findModelProject(resource);
        int eventType = ((ModelWorkspaceNotificationImpl)notification).getEventType();
        switch (eventType) {
            case 3: {
                this.add(resource, project);
                break;
            }
            case 4: {
                this.remove(resource);
                break;
            }
            case 7: {
                break;
            }
            case 1: {
                IPath oldPath = notification.getDelta().getMovedFromPath();
                ModelWorkspaceItem oldItem = this.modelWorkspace.getWorkspaceItem(oldPath, resource.getType());
                if (oldItem == null || oldItem.getResource() == null) break;
                this.remove(oldItem.getResource());
                this.add(resource, project);
                break;
            }
            case 50: {
                ModelWorkspaceItem resourceItem;
                if (resource.getType() != 1 || (resourceItem = this.modelWorkspace.getWorkspaceItem(resource.getFullPath(), resource.getType())) == null || !(resourceItem instanceof ModelResourceImpl)) break;
                ModelResourceImpl model = (ModelResourceImpl)resourceItem;
                return model.processContentsChange(notification);
            }
            case 51: {
                if (!(resource instanceof IProject)) break;
                if (project == null) {
                    project = new ModelProjectImpl((IProject)resource, this.modelWorkspace);
                    ModelWorkspaceItemInfo parentInfo = (ModelWorkspaceItemInfo)this.getInfo(this.modelWorkspace);
                    if (parentInfo != null) {
                        parentInfo.addChild(project);
                    }
                }
                project.open(null);
                break;
            }
            default: {
                throw new ModelerCoreException(ModelerCore.Util.getString("ModelWorkspaceManager.Illegal_notification,_notification_type_not_recognized___1") + eventType);
            }
        }
        return false;
    }

    private void add(IResource resource, ModelProjectImpl project) {
        ModelWorkspaceItem resourceItem = this.modelWorkspace.getWorkspaceItem(resource.getFullPath(), resource.getType());
        if (resourceItem != null) {
            return;
        }
        Openable newResource = null;
        ModelWorkspaceItem parentItem = null;
        if (resource instanceof IProject && project == null) {
            newResource = project = new ModelProjectImpl((IProject)resource, this.modelWorkspace);
            parentItem = this.modelWorkspace;
        } else if (!(resource instanceof IProject)) {
            if (project == null) {
                String msg = resource == null ? ModelerCore.Util.getString("ModelWorkspaceManager.Encountered_null_project_for_resource_of_type_{0}_1", resource) : ModelerCore.Util.getString("ModelWorkspaceManager.Encountered_null_project_for_resource_of_type_{0}_1", resource.getClass().getName());
                ModelerCore.Util.log(2, msg);
                return;
            }
            try {
                if (ModelerCore.DEBUG_MODEL_WORKSPACE || ModelerCore.DEBUG_MODEL_WORKSPACE_EVENT) {
                    Object[] params = new Object[]{resource};
                    String debugMsg = ModelerCore.Util.getString("ModelWorkspaceManager.DEBUG.Creating_ModelResource_instance_for_0_2", params);
                    ModelerCore.Util.log(1, debugMsg);
                }
                if (resource.getType() == 1) {
                    newResource = project.createModelResource((IFile)resource);
                } else if (resource.getType() == 2) {
                    newResource = project.createModelFolder((IFolder)resource);
                }
                parentItem = this.modelWorkspace.getParent(resource);
            }
            catch (Exception e2) {
                ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ModelWorkspaceManager.Error_creating_new_model_workspace_item___{0}_1", e2.getMessage()));
            }
        } else if (resource instanceof IProject && project != null) {
            parentItem = this.modelWorkspace;
        } else {
            ModelerCore.Util.log(4, ModelerCore.Util.getString("ModelWorkspaceManager.Unable_to_create_workspace_item_for_{0}_2", resource.getFullPath()));
            return;
        }
        if (parentItem == null) {
            parentItem = this.modelWorkspace.getParent(resource);
            ModelerCore.Util.log(4, ModelerCore.Util.getString("ModelWorkspaceManager.Unable_to_find_parent_item_for_{0})_3", resource.getFullPath()));
            return;
        }
        ModelWorkspaceItemInfo parentInfo = (ModelWorkspaceItemInfo)this.getInfo(parentItem);
        if (parentInfo != null) {
            parentInfo.addChild((ModelWorkspaceItem)((Object)newResource));
        }
    }

    private void remove(IResource resource) throws CoreException {
        ModelWorkspaceItemInfo parentInfo;
        ModelWorkspaceItem parentItem;
        ModelWorkspaceItem resourceItem = this.modelWorkspace.getWorkspaceItem(resource.getFullPath(), resource.getType());
        this.removeResourcesRecursively(resource);
        if (resourceItem instanceof Openable) {
            ((Openable)((Object)resourceItem)).close();
        }
        if ((parentItem = this.modelWorkspace.getParent(resource)) != null && (parentInfo = (ModelWorkspaceItemInfo)this.getInfo(parentItem)) != null) {
            parentInfo.removeChild(resourceItem);
        }
    }

    private void removeResourcesRecursively(IResource resource) throws CoreException {
        ArgCheck.isNotNull(resource);
        int resourceType = resource.getType();
        if (resource.getLocation() != null && resourceType == 1) {
            ModelWorkspaceItem resourceItem;
            String searchIndexFileName;
            File searchIndexFile;
            String runtimeIndexFileName = IndexUtil.getRuntimeIndexFileName(resource);
            File runtimeIndexFile = new File(IndexUtil.INDEX_PATH, runtimeIndexFileName);
            if (runtimeIndexFile.exists()) {
                runtimeIndexFile.delete();
            }
            if ((searchIndexFile = new File(IndexUtil.INDEX_PATH, searchIndexFileName = IndexUtil.getSearchIndexFileName(resource))).exists()) {
                searchIndexFile.delete();
            }
            if ((resourceItem = this.modelWorkspace.getWorkspaceItem(resource.getFullPath(), 1)) != null && resourceItem instanceof ModelResourceImpl) {
                ((ModelResourceImpl)resourceItem).removeEmfResource();
            }
        }
        if (resource.exists() && resource.isAccessible() && resourceType != 1) {
            class ResourceVisitor
            implements IResourceVisitor {
                List resources = new ArrayList();

                ResourceVisitor() {
                }

                public boolean visit(IResource resource) {
                    if (this.isIncludedResource(resource)) {
                        this.resources.add(resource);
                    }
                    return true;
                }

                public List getFileResources() {
                    return this.resources;
                }

                private boolean isIncludedResource(IResource resource) {
                    if (resource == null || !resource.exists()) {
                        return false;
                    }
                    return ModelUtil.isModelFile(resource) || ModelUtil.isXsdFile(resource) || ModelUtil.isVdbArchiveFile(resource);
                }
            }
            ResourceVisitor visitor = new ResourceVisitor();
            resource.accept(visitor);
            List childResources = visitor.getFileResources();
            Iterator rscIter = childResources.iterator();
            while (rscIter.hasNext()) {
                IResource child = (IResource)rscIter.next();
                this.removeResourcesRecursively(child);
            }
        }
    }

    void setIndexType(int type) {
        this.indexType = type;
    }

    public Collection getNonIndexedResources(int indexType) throws CoreException {
        if (this.indexType == 3 || this.indexType == indexType) {
            return Collections.EMPTY_LIST;
        }
        this.setIndexType(indexType);
        class ResourceVisitor
        implements IResourceVisitor {
            Collection resources = new ArrayList();
            private final /* synthetic */ int val$indexType;

            ResourceVisitor(int val$indexType) {
                this.val$indexType = val$indexType;
            }

            public boolean visit(IResource resource) throws CoreException {
                ModelWorkspaceItem modelWorkspaceItem;
                if (resource != null && resource.getType() == 1 && (modelWorkspaceItem = ModelWorkspaceManager.this.findModelWorkspaceItem(resource)) != null && modelWorkspaceItem instanceof ModelResource) {
                    ModelResource mResource = (ModelResource)modelWorkspaceItem;
                    int modelIndexType = mResource.getIndexType();
                    switch (this.val$indexType) {
                        case 3: {
                            if (modelIndexType == 3) break;
                            this.resources.add(mResource.getResource());
                            break;
                        }
                        case 1: {
                            if (modelIndexType == 3 || modelIndexType == 1) break;
                            this.resources.add(mResource.getResource());
                            break;
                        }
                        case 2: {
                            if (modelIndexType == 3 || modelIndexType == 2) break;
                            this.resources.add(mResource.getResource());
                            break;
                        }
                    }
                }
                return true;
            }

            public Collection getResources() {
                return this.resources;
            }
        }
        ResourceVisitor visitor = new ResourceVisitor(indexType);
        ModelProject[] projects = ModelerCore.getModelWorkspace().getModelProjects();
        for (int i2 = 0; i2 < projects.length; ++i2) {
            ModelProject mProject = projects[i2];
            if (mProject == null || !mProject.isOpen()) continue;
            mProject.getProject().accept(visitor);
        }
        return visitor.getResources();
    }

    private void shutdownManager() throws CoreException {
        if (this.container != null) {
            try {
                if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelWorkspaceManager.DEBUG.Shutting_down_model_container"));
                }
                this.container.shutdown();
                if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelWorkspaceManager.DEBUG.Completed_shuting_down_model_container"));
                }
            }
            catch (ModelerCoreException e2) {
                throw new CoreException(new Status(4, "com.metamatrix.modeler.core", 1, ModelerCore.Util.getString("ModelWorkspaceManager.Error_shutting_down_the_model_container_2"), e2));
            }
            finally {
                this.container = null;
            }
        }
        if (this.workspaceListeners != null) {
            this.workspaceListeners.clear();
        }
    }

    public ModelWorkspace getModelWorkspace() {
        return this.modelWorkspace;
    }

    public Object getInfo(ModelWorkspaceItem item) {
        return this.cache.getInfo(item);
    }

    protected Object peekAtInfo(ModelWorkspaceItem item) {
        return this.cache.peekAtInfo(item);
    }

    public void removeInfo(ModelWorkspaceItem item) {
        this.cache.removeInfo(item);
    }

    public void putInfo(ModelWorkspaceItem item, Object info) {
        this.cache.putInfo(item, info);
    }

    public Container getModelContainer() throws CoreException {
        if (this.container == null) {
            this.container = ModelerCore.getModelContainer();
        }
        return this.container;
    }

    public static ModelResource create(IFile file, ModelProject project) {
        if (file == null || !ModelerCore.hasModelNature(file.getProject())) {
            return null;
        }
        if (project == null) {
            project = manager.getModelWorkspace().getModelProject(file);
        }
        if (file.getFileExtension() != null && ModelUtil.isModelFile(file)) {
            try {
                ModelResource resource = (ModelResource)project.findModelWorkspaceItem(file);
                if (resource != null) {
                    return resource;
                }
                resource = (ModelResource)ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(file, true);
                return resource;
            }
            catch (ModelWorkspaceException e2) {
                return null;
            }
        }
        return null;
    }

    public static ModelWorkspaceItem create(IFolder folder, ModelProject project) {
        if (project == null) {
            project = manager.getModelWorkspace().getModelProject(folder);
        }
        try {
            ModelWorkspaceItem folderItem = project.findModelWorkspaceItem(folder);
            if (folderItem != null) {
                return folderItem;
            }
            folderItem = (ModelResource)ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(folder, true);
            return folderItem;
        }
        catch (ModelWorkspaceException e2) {
            return null;
        }
    }

    public static ModelWorkspaceItem create(IResource resource, ModelProject project) {
        if (resource == null || resource.getProject() != null && !ModelerCore.hasModelNature(resource.getProject())) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return ModelerCore.create((IProject)resource);
            }
            case 1: {
                return ModelWorkspaceManager.create((IFile)resource, project);
            }
            case 2: {
                return ModelWorkspaceManager.create((IFolder)resource, project);
            }
            case 8: {
                return ModelerCore.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public ModelWorkspaceItem getHandleFromMemento(String memento) throws ModelWorkspaceException {
        if (memento == null) {
            return null;
        }
        ModelWorkspace modelWorkspace = this.getModelWorkspace();
        if (memento.equals("")) {
            return modelWorkspace;
        }
        return null;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public ModelResource findModelResource(Resource resource) {
        ArgCheck.isNotNull(resource);
        return ModelBufferManager.getDefaultBufferManager().getModelResource(resource);
    }

    public ModelWorkspaceItem findModelWorkspaceItem(IResource resource) throws ModelWorkspaceException {
        ArgCheck.isNotNull(resource);
        return this.findModelWorkspaceItem(resource, false);
    }

    public ModelWorkspaceItem findModelWorkspaceItem(IPath resourcePath, int resourceType) throws ModelWorkspaceException {
        ArgCheck.isNotNull(resourcePath);
        return this.modelWorkspace.getWorkspaceItem(resourcePath, resourceType);
    }

    public ModelWorkspaceItem findModelWorkspaceItem(IResource resource, boolean createIfRequired) throws ModelWorkspaceException {
        ModelProject modelProject;
        ArgCheck.isNotNull(resource);
        IProject proj = resource.getProject();
        if (!ModelerCore.hasModelNature(proj)) {
            return null;
        }
        IPath pathInProject = resource.getProjectRelativePath();
        ModelWorkspaceItem parent = modelProject = this.getModelWorkspace().getModelProject(proj);
        int numFolders = pathInProject.segmentCount();
        if (resource instanceof IFile) {
            if (!ModelUtil.isModelFile(resource)) {
                return null;
            }
            --numFolders;
        }
        for (int i2 = 0; i2 < numFolders; ++i2) {
            String folderName = pathInProject.segment(i2);
            ModelWorkspaceItem child = parent.getChild(folderName);
            if (child == null) {
                IFolder underlyingFolder = proj.getFolder(pathInProject.uptoSegment(i2 + 1));
                Assertion.isNotNull(underlyingFolder);
                ModelFolderImpl newFolder = new ModelFolderImpl(underlyingFolder, parent);
                Object parentInfo = ((ModelWorkspaceItemImpl)parent).getItemInfo();
                if (parentInfo instanceof ModelFolderInfo) {
                    ((ModelFolderInfo)parentInfo).addChild(newFolder);
                    parent = newFolder;
                    continue;
                }
                if (!(parentInfo instanceof ModelProjectInfo)) continue;
                ((ModelProjectInfo)parentInfo).addChild(newFolder);
                parent = newFolder;
                continue;
            }
            parent = child;
        }
        if (resource instanceof IFile) {
            ModelWorkspaceItem result = parent.getChild(resource);
            if (result == null && createIfRequired) {
                String name = resource.getName();
                result = new ModelResourceImpl(parent, name);
            }
            return result;
        }
        return parent;
    }

    private void addChangeNotifier(Container container) {
        ChangeNotifier notifier;
        if (container != null && (notifier = container.getChangeNotifier()) != null) {
            notifier.addListener(new NotificationProcessor());
        }
    }

    public boolean isModelOpen(IResource theResource) {
        ArgCheck.isNotNull(theResource);
        boolean result = false;
        if (ModelUtil.isModelFile(theResource, true)) {
            try {
                ModelWorkspaceItem item = this.findModelWorkspaceItem(theResource, false);
                if (item != null) {
                    result = this.getInfo(item) != null;
                }
            }
            catch (ModelWorkspaceException modelWorkspaceException) {
                // empty catch block
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NotificationProcessor
    implements INotifyChangedListener {
        private NotificationProcessor() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.isTouch()) {
                return;
            }
            if (notification instanceof SourcedNotification) {
                Collection chain = ((SourcedNotification)notification).getNotifications();
                Iterator iter = chain.iterator();
                while (iter.hasNext()) {
                    Notification n2 = (Notification)iter.next();
                    this.checkResourceForIndexing(n2);
                }
            } else {
                this.checkResourceForIndexing(notification);
            }
        }

        private void checkResourceForIndexing(Notification notification) {
            Object target = notification.getNotifier();
            if (notification.isTouch()) {
                return;
            }
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.refreshResourceIndexType(target);
                    break;
                }
            }
        }

        private void refreshResourceIndexType(Object obj) {
            ModelResource mResource;
            Resource eResource;
            if (obj == null) {
                return;
            }
            if (obj instanceof Resource && ((Resource)obj).isModified()) {
                ModelResource mResource2 = ModelWorkspaceManager.this.findModelResource((Resource)obj);
                if (mResource2 != null) {
                    if (mResource2.getIndexType() == 0) {
                        return;
                    }
                    mResource2.refreshIndexType();
                    ModelWorkspaceManager.this.setIndexType(0);
                }
            } else if (obj instanceof EObject && ((EObject)obj).eResource() != null && (eResource = ((EObject)obj).eResource()).isModified() && (mResource = ModelWorkspaceManager.this.findModelResource(eResource)) != null) {
                if (mResource.getIndexType() == 0) {
                    return;
                }
                mResource.setIndexType(0);
                ModelWorkspaceManager.this.setIndexType(0);
            }
        }
    }

    private class IResourceComparator
    implements Comparator {
        public int compare(Object rsc1, Object rsc2) {
            ArgCheck.isInstanceOf(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = ModelWorkspaceManager.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource, rsc1);
            ArgCheck.isInstanceOf(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = ModelWorkspaceManager.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource, rsc2);
            IResource resource1 = (IResource)rsc1;
            IResource resource2 = (IResource)rsc2;
            return resource2.getType() - resource1.getType();
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject == this) {
                return true;
            }
            return anObject != null && anObject.getClass() == this.getClass();
        }
    }

    private class ModelIResourceCollectorVisitor
    implements IResourceVisitor {
        List resources = new ArrayList();

        private ModelIResourceCollectorVisitor() {
        }

        public boolean visit(IResource resource) {
            if (this.isIncludedResource(resource)) {
                this.resources.add(resource);
                if (resource.getType() != 1) {
                    return true;
                }
            }
            return false;
        }

        public List getResources() {
            return this.resources;
        }

        private boolean isIncludedResource(IResource resource) {
            if (resource == null || !resource.exists()) {
                return false;
            }
            if (resource.getType() == 4) {
                return ModelerCore.hasModelNature((IProject)resource);
            }
            if (resource.getType() == 1) {
                return ModelUtil.isModelFile(resource) || ModelUtil.isXsdFile(resource) || ModelUtil.isVdbArchiveFile(resource);
            }
            return true;
        }
    }
}

