/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelProject;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceVisitor;
import com.metamatrix.modeler.core.workspace.Openable;
import com.metamatrix.modeler.internal.core.workspace.InternalOpenable;
import com.metamatrix.modeler.internal.core.workspace.ModelStatusImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceItemInfo;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.PlatformObject;

public abstract class ModelWorkspaceItemImpl
extends PlatformObject
implements ModelWorkspaceItem {
    protected static final int MINIMUM_VALID_TYPE = 1;
    protected static final int MAXIMUM_VALID_TYPE = 11;
    protected int occurrenceCount = 1;
    protected boolean opening = false;
    protected boolean closing = false;
    protected final int fType;
    protected final ModelWorkspaceItemImpl fParent;
    protected final String fName;
    protected static final Object NO_INFO = new Object();

    protected ModelWorkspaceItemImpl(int type, ModelWorkspaceItem parent, String name) throws IllegalArgumentException {
        if (type < 1 || type > 11) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("element.invalidType"));
        }
        this.fType = type;
        this.fParent = (ModelWorkspaceItemImpl)parent;
        this.fName = name;
        if (this.fParent != null) {
            try {
                ModelWorkspaceItemInfo info = (ModelWorkspaceItemInfo)this.fParent.getItemInfo();
                info.addChild(this);
            }
            catch (ModelWorkspaceException e2) {
                ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ModelWorkspaceItemImpl.Error_trying_to_create_a_modelWorksapceItem_{0}_under_the_parent_{1}_1", name, this.fParent.getItemName()));
            }
        }
    }

    public String getItemName() {
        return this.fName;
    }

    public int getItemType() {
        return this.fType;
    }

    public ModelWorkspace getModelWorkspace() {
        ModelWorkspaceItem current = this;
        do {
            if (!(current instanceof ModelWorkspace)) continue;
            return (ModelWorkspace)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public ModelProject getModelProject() {
        ModelWorkspaceItem current = this;
        do {
            if (!(current instanceof ModelProject)) continue;
            return (ModelProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public IResource getCorrespondingResource() throws ModelWorkspaceException {
        return null;
    }

    public Openable getOpenable() {
        return this.getOpenableParent();
    }

    public Openable getOpenableParent() {
        return (Openable)((Object)this.fParent);
    }

    public int hashCode() {
        if (this.fParent == null) {
            return super.hashCode();
        }
        return HashCodeUtil.hashCode(this.fParent.hashCode(), this.fName.hashCode());
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean isAncestorOf(ModelWorkspaceItem item) {
        ModelWorkspaceItem parent;
        if (item == null) {
            return false;
        }
        for (parent = item.getParent(); parent != null && !parent.equals(this); parent = parent.getParent()) {
        }
        return parent != null;
    }

    public ModelWorkspaceItem getParent() {
        return this.fParent;
    }

    public ModelWorkspaceItem[] getChildren() throws ModelWorkspaceException {
        return ((ModelWorkspaceItemInfo)this.getItemInfo()).getChildren();
    }

    public ArrayList getChildrenOfType(int type) throws ModelWorkspaceException {
        ModelWorkspaceItem[] children = this.getChildren();
        int size = children.length;
        ArrayList<ModelWorkspaceItem> list = new ArrayList<ModelWorkspaceItem>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            ModelWorkspaceItem elt = children[i2];
            if (elt.getItemType() != type) continue;
            list.add(elt);
        }
        return list;
    }

    public ModelWorkspaceItem getFirstChildrenOfType(int type) throws ModelWorkspaceException {
        ModelWorkspaceItem[] children = this.getChildren();
        int size = children.length;
        for (int i2 = 0; i2 < size; ++i2) {
            ModelWorkspaceItem elt = children[i2];
            if (elt.getItemType() != type) continue;
            return elt;
        }
        return null;
    }

    public boolean isStructureKnown() throws ModelWorkspaceException {
        return ((ModelWorkspaceItemInfo)this.getItemInfo()).isStructureKnown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getItemInfo() throws ModelWorkspaceException {
        ModelWorkspaceManager manager;
        ModelWorkspaceManager modelWorkspaceManager = manager = ModelWorkspaceManager.getModelWorkspaceManager();
        synchronized (manager) {
            Object info = manager.getInfo(this);
            if (info == null) {
                this.openHierarchy();
                info = manager.getInfo(this);
                if (info == null) {
                    throw this.newNotPresentException();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return info;
        }
    }

    protected void openHierarchy() throws ModelWorkspaceException {
        if (this instanceof InternalOpenable) {
            ((InternalOpenable)((Object)this)).openWhenClosed(null);
        } else {
            Openable openableParent = this.getOpenableParent();
            if (openableParent != null) {
                ModelWorkspaceItemInfo openableParentInfo = (ModelWorkspaceItemInfo)ModelWorkspaceManager.getModelWorkspaceManager().getInfo((ModelWorkspaceItem)((Object)openableParent));
                if (openableParentInfo == null) {
                    if (openableParent instanceof InternalOpenable) {
                        ((InternalOpenable)((Object)openableParent)).openWhenClosed(null);
                    }
                } else {
                    throw this.newNotPresentException();
                }
            }
        }
    }

    protected void opening(Object info) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ModelWorkspaceException {
        this.closing = true;
        boolean wasVerbose = ModelWorkspaceManager.VERBOSE;
        try {
            Object info = ModelWorkspaceManager.getModelWorkspaceManager().peekAtInfo(this);
            if (info != null) {
                if (ModelWorkspaceManager.VERBOSE) {
                    System.out.println("CLOSING Element (" + Thread.currentThread() + "): " + this.toStringWithAncestors());
                    wasVerbose = true;
                    ModelWorkspaceManager.VERBOSE = false;
                }
                ModelWorkspaceItem[] children = ((ModelWorkspaceItemInfo)info).getChildren();
                int size = children.length;
                for (int i2 = 0; i2 < size; ++i2) {
                    ModelWorkspaceItemImpl child = (ModelWorkspaceItemImpl)children[i2];
                    child.close();
                }
                this.closing(info);
                ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
                if (wasVerbose) {
                    System.out.println("-> Package cache size = " + ModelWorkspaceManager.getModelWorkspaceManager().cache.pkgSize());
                    System.out.println("-> Openable cache filling ratio = " + ModelWorkspaceManager.getModelWorkspaceManager().cache.openableFillingRatio() + "%");
                }
            }
        }
        catch (ModelWorkspaceException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            ModelerCore.Util.log(t2);
        }
        finally {
            ModelWorkspaceManager.VERBOSE = wasVerbose;
            this.closing = false;
        }
    }

    protected void closing(Object info) throws ModelWorkspaceException {
    }

    protected void removeInfo() {
        Object info = ModelWorkspaceManager.getModelWorkspaceManager().peekAtInfo(this);
        if (info != null) {
            ModelWorkspaceItem[] children = ((ModelWorkspaceItemInfo)info).getChildren();
            int size = children.length;
            for (int i2 = 0; i2 < size; ++i2) {
                ModelWorkspaceItemImpl child = (ModelWorkspaceItemImpl)children[i2];
                child.removeInfo();
            }
            ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.fParent == null) {
            return super.equals(o2);
        }
        if (o2 instanceof ModelWorkspaceItemImpl) {
            ModelWorkspaceItemImpl other = (ModelWorkspaceItemImpl)o2;
            if (this.fType != other.fType) {
                return false;
            }
            return this.fName.equals(other.fName) && this.fParent.equals(other.fParent) && this.occurrenceCount == other.occurrenceCount;
        }
        return false;
    }

    public boolean exists() {
        try {
            this.getItemInfo();
            return true;
        }
        catch (ModelWorkspaceException modelWorkspaceException) {
            return false;
        }
    }

    protected ModelWorkspaceException newNotPresentException() {
        return new ModelWorkspaceException(new ModelStatusImpl(969, this));
    }

    protected void setOccurrenceCount(int count) {
        this.occurrenceCount = count;
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = tab; i2 > 0; --i2) {
            buffer.append("  ");
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        ModelWorkspaceItemImpl parent = (ModelWorkspaceItemImpl)this.getParent();
        if (parent != null && parent.getParent() != null) {
            buffer.append(" [in ");
            parent.toStringInfo(0, buffer, NO_INFO);
            parent.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof ModelWorkspaceItemInfo)) {
            return;
        }
        ModelWorkspaceItem[] children = ((ModelWorkspaceItemInfo)info).getChildren();
        for (int i2 = 0; i2 < children.length; ++i2) {
            buffer.append("\n");
            ((ModelWorkspaceItemImpl)children[i2]).toString(tab + 1, buffer);
        }
    }

    public Object toStringInfo(int tab, StringBuffer buffer) {
        Object info = ModelWorkspaceManager.getModelWorkspaceManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info);
        return info;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append(this.getItemName());
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    public void accept(ModelWorkspaceVisitor visitor, int depth) throws ModelWorkspaceException {
        ArgCheck.isNotNull(visitor);
        if (depth != 2 && depth != 1 && depth != 0) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("ModelWorkspaceItemImpl.Invalid_visitor_depth"));
        }
        if (!visitor.visit(this) || depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        ModelWorkspaceItem[] children = this.getChildren();
        for (int i2 = 0; i2 < children.length; ++i2) {
            children[i2].accept(visitor, nextDepth);
        }
    }

    public ModelWorkspaceItem getChild(IResource resource) throws ModelWorkspaceException {
        ArgCheck.isNotNull(resource);
        String resourceName = resource.getName();
        return this.getChild(resourceName);
    }

    public ModelWorkspaceItem getChild(String childName) throws ModelWorkspaceException {
        ArgCheck.isNotNull(childName);
        ModelWorkspaceItem[] children = this.getChildren();
        for (int j2 = 0; j2 < children.length; ++j2) {
            ModelWorkspaceItem child = children[j2];
            if (!child.getItemName().equals(childName)) continue;
            return child;
        }
        return null;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public boolean isOpening() {
        return this.opening;
    }
}

