/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Stopwatch;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.ResourceSetFinder;
import com.metamatrix.modeler.core.workspace.ModelBuffer;
import com.metamatrix.modeler.core.workspace.ModelBufferFactory;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.core.workspace.Openable;
import com.metamatrix.modeler.internal.core.container.DefaultContainerResourceSetFinder;
import com.metamatrix.modeler.internal.core.resource.EmfResourceSet;
import com.metamatrix.modeler.internal.core.util.OverflowingLRUCache;
import com.metamatrix.modeler.internal.core.workspace.ModelBufferCache;
import com.metamatrix.modeler.internal.core.workspace.ModelBufferImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ModelBufferManager
implements ModelBufferFactory {
    protected static final int DEFAULT_MODEL_BUFFER_CACHE_LIMIT = 300;
    private static ModelBufferManager DEFAULT_MODEL_BUFFER_MANAGER;
    private final OverflowingLRUCache openBuffers;
    private ResourceSetFinder resourceSetFinder;
    private final Map emfResourceToModelResource;
    static /* synthetic */ Class class$com$metamatrix$modeler$core$workspace$ModelWorkspaceItem;

    public static synchronized ModelBufferManager getDefaultBufferManager() {
        if (DEFAULT_MODEL_BUFFER_MANAGER == null) {
            DEFAULT_MODEL_BUFFER_MANAGER = new ModelBufferManager();
        }
        return DEFAULT_MODEL_BUFFER_MANAGER;
    }

    public ModelBufferManager() {
        this(300);
    }

    protected ModelBufferManager(int cacheSize) {
        Stopwatch stopwatch = null;
        if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
            stopwatch = new Stopwatch();
            stopwatch.start();
        }
        this.openBuffers = new ModelBufferCache(cacheSize);
        this.resourceSetFinder = new DefaultContainerResourceSetFinder();
        if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
            stopwatch.stop();
            ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelBufferManager.Time_to_create_ModelBufferManager", stopwatch));
        }
        this.emfResourceToModelResource = new HashMap();
    }

    protected void registerEmfResource(Resource resource, Openable openable) {
        this.emfResourceToModelResource.put(resource, openable);
    }

    protected void unregisterEmfResource(Resource resource) {
        this.emfResourceToModelResource.remove(resource);
    }

    protected ModelResource getModelResource(Resource resource) {
        ModelResource result = (ModelResource)this.emfResourceToModelResource.get(resource);
        if (result == null) {
            URI normalizedUri;
            ResourceSet resourceSet = resource.getResourceSet();
            try {
                Container container = null;
                if (resourceSet instanceof EmfResourceSet) {
                    container = ((EmfResourceSet)((Object)resourceSet)).getContainer();
                } else if (resourceSet instanceof Container) {
                    container = (Container)resourceSet;
                }
                if (container == null || container != ModelerCore.getModelContainer()) {
                    return null;
                }
                resourceSet = container;
            }
            catch (CoreException e2) {
                ModelerCore.Util.log(e2);
            }
            URI resourceURI = resource.getURI();
            String fileString = null;
            if (resourceURI.isFile()) {
                fileString = resourceURI.toFileString();
            } else {
                IResource iResource = WorkspaceResourceFinderUtil.findIResource(resourceURI);
                if (iResource != null) {
                    fileString = iResource.getLocation().toOSString();
                }
            }
            if (fileString == null) {
                try {
                    URL fileUrl = new URL(resourceURI.toString());
                    URL resolvedFileUrl = Platform.resolve(fileUrl);
                    if (resolvedFileUrl != null) {
                        fileString = resolvedFileUrl.getFile();
                    }
                }
                catch (MalformedURLException e1) {
                }
                catch (IOException e1) {
                    ModelerCore.Util.log(e1);
                }
            }
            if (fileString == null && "file".equals((normalizedUri = resourceSet.getURIConverter().normalize(resourceURI)).scheme())) {
                fileString = normalizedUri.toFileString();
            }
            if (fileString == null) {
                return null;
            }
            Path path = new Path(fileString);
            try {
                IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                IFile resourceFile = wsRoot.getFileForLocation(path);
                if (resourceFile == null) {
                    resourceFile = wsRoot.getFile(path);
                }
                if (resourceFile == null) {
                    return null;
                }
                ModelWorkspaceManager mgr = ModelWorkspaceManager.getModelWorkspaceManager();
                ModelResource mResource = (ModelResource)mgr.findModelWorkspaceItem(resourceFile);
                if (mResource == null) {
                    return null;
                }
                mResource.open(null);
                result = mResource;
            }
            catch (Throwable e2) {
                ModelerCore.Util.log(e2);
            }
        }
        return result;
    }

    OverflowingLRUCache getOpenBufferCache() {
        return this.openBuffers;
    }

    public ModelBuffer createBuffer(Openable owner) throws ModelWorkspaceException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$workspace$ModelWorkspaceItem == null ? (class$com$metamatrix$modeler$core$workspace$ModelWorkspaceItem = ModelBufferManager.class$("com.metamatrix.modeler.core.workspace.ModelWorkspaceItem")) : class$com$metamatrix$modeler$core$workspace$ModelWorkspaceItem, owner);
        ModelWorkspaceItem item = (ModelWorkspaceItem)((Object)owner);
        IResource resource = item.getResource();
        ResourceSet emfResourceSet = this.resourceSetFinder.getResourceSet(resource);
        ModelBufferImpl buffer = new ModelBufferImpl(resource instanceof IFile ? (IFile)resource : null, owner, emfResourceSet, item.isReadOnly());
        return buffer;
    }

    protected void addBuffer(ModelBuffer buffer) {
        this.openBuffers.put(buffer.getOwner(), buffer);
    }

    public ModelBuffer getOpenBuffer(Openable owner) {
        ArgCheck.isNotNull(owner);
        return (ModelBuffer)this.openBuffers.get(owner);
    }

    public ModelBufferFactory getDefaultBufferFactory() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getOpenBuffers() {
        OverflowingLRUCache overflowingLRUCache = this.openBuffers;
        synchronized (overflowingLRUCache) {
            return this.openBuffers.elements();
        }
    }

    protected void removeBuffer(ModelBuffer buffer) {
        this.openBuffers.remove(buffer.getOwner());
    }

    public ResourceSetFinder getResourceSetFinder() {
        return this.resourceSetFinder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

