/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceNotificationImpl;
import com.metamatrix.modeler.internal.core.workspace.ResourceChangeUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;

public class DeltaProcessor
implements IResourceChangeListener {
    private final ModelWorkspaceManager manager;

    DeltaProcessor(ModelWorkspaceManager manager) {
        this.manager = manager;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (ModelerCore.DEBUG_NOTIFICATIONS) {
            ResourceChangeUtilities.debug(event);
        }
        if (ResourceChangeUtilities.isProjectClosing(event)) {
            this.fireProjectClosing(event);
            return;
        }
        if (ResourceChangeUtilities.isPreDelete(event)) {
            this.firePreDelete(event);
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        ArrayList<IResourceDelta> deltaResourceList = new ArrayList<IResourceDelta>();
        deltaResourceList.add(delta);
        this.buildDeltaResourceList(event, delta, deltaResourceList);
        Iterator iter = deltaResourceList.iterator();
        while (iter.hasNext()) {
            IResourceDelta nextDelta = (IResourceDelta)iter.next();
            this.debug(nextDelta, event);
            this.fireNotification(event, nextDelta);
        }
    }

    private void buildDeltaResourceList(IResourceChangeEvent event, IResourceDelta delta, List deltaResourceList) {
        if (delta == null) {
            return;
        }
        IResourceDelta[] deltas = delta.getAffectedChildren();
        if (deltas.length == 0) {
            return;
        }
        if (ResourceChangeUtilities.isRename(event, deltas)) {
            this.fireRename(deltas, event);
            return;
        }
        if (deltas.length > 1 && delta.getKind() == 4) {
            int i2;
            ArrayList<IResourceDelta> newDeltas = new ArrayList<IResourceDelta>();
            for (i2 = 0; i2 < deltas.length; ++i2) {
                IResourceDelta nextDelta = deltas[i2];
                if (nextDelta.getKind() == 2) {
                    newDeltas.add(0, nextDelta);
                    continue;
                }
                newDeltas.add(nextDelta);
            }
            for (i2 = 0; i2 < newDeltas.size(); ++i2) {
                deltas[i2] = (IResourceDelta)newDeltas.get(i2);
            }
        }
        for (int i3 = 0; i3 < deltas.length; ++i3) {
            IResourceDelta nextDelta = deltas[i3];
            deltaResourceList.add(nextDelta);
            this.buildDeltaResourceList(event, nextDelta, deltaResourceList);
        }
    }

    private void fireNotification(IResourceChangeEvent event, IResourceDelta delta) {
        IResource rsrc = delta.getResource();
        if (rsrc.getType() == 1 && !ModelUtil.isModelFile(rsrc, false) && !ModelUtil.isVdbArchiveFile(rsrc)) {
            return;
        }
        int kind = delta.getKind();
        try {
            switch (kind) {
                case 1: {
                    ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(3, delta, event);
                    this.manager.fire(notification);
                    break;
                }
                case 4: {
                    if (!ResourceChangeUtilities.isDescriptionChange(delta) && !ResourceChangeUtilities.isMarkersChange(delta)) {
                        if (ResourceChangeUtilities.isTypeChange(delta)) break;
                        if (ResourceChangeUtilities.isContentChanged(delta)) {
                            ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(50, delta, event);
                            this.manager.fire(notification);
                            break;
                        }
                        if (ResourceChangeUtilities.isReplaced(delta)) {
                            ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(3, delta, event);
                            this.manager.fire(notification);
                            notification = new ModelWorkspaceNotificationImpl(4, delta, event);
                            this.manager.fire(notification);
                            break;
                        }
                        if (ResourceChangeUtilities.isMovedFrom(delta) || ResourceChangeUtilities.isMovedTo(delta)) {
                            ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(7, delta, event);
                            this.manager.fire(notification);
                            break;
                        }
                        if (rsrc != null && rsrc instanceof IProject && ResourceChangeUtilities.isOpened(delta)) {
                            if (((IProject)rsrc).isOpen()) {
                                ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(51, delta, event);
                                this.manager.fire(notification);
                                break;
                            }
                            ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(4, delta, event);
                            this.manager.fire(notification);
                        }
                    }
                    break;
                }
                case 2: {
                    ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(4, delta, event);
                    this.manager.fire(notification);
                    break;
                }
                case 8: 
                case 16: {
                    break;
                }
                default: {
                    throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("DeltaProcessor.Unsupported_Resource_Delta_type___{0}_1", kind));
                }
            }
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(e2);
        }
    }

    private void fireRename(IResourceDelta[] deltas, IResourceChangeEvent event) {
        ArgCheck.isNotNull(deltas);
        if (deltas.length != 2) {
            ArgCheck.isTrue(deltas.length == 2, ModelerCore.Util.getString("DeltaProcessor.Deltas_length_must_be_2_for_a_rename_1"));
        }
        IResourceDelta delta = null;
        if (ResourceChangeUtilities.isAdded(deltas[0])) {
            delta = deltas[0];
        } else if (ResourceChangeUtilities.isAdded(deltas[1])) {
            delta = deltas[1];
        }
        if (delta == null) {
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("DeltaProcessor.Unable_to_find_added_resource_for_rename_notification_2"));
        }
        ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(1, delta, event);
        notification.setIsRename(true);
        try {
            this.manager.fire(notification);
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(e2);
        }
    }

    private void fireProjectClosing(IResourceChangeEvent event) {
        ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(52, null, event);
        try {
            this.manager.fire(notification);
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(e2);
        }
    }

    private void firePreDelete(IResourceChangeEvent event) {
        ModelWorkspaceNotificationImpl notification = new ModelWorkspaceNotificationImpl(4, null, event);
        try {
            this.manager.fire(notification);
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(e2);
        }
    }

    private void debug(IResourceDelta delta, IResourceChangeEvent event) {
        if (ModelerCore.DEBUG_NOTIFICATIONS) {
            System.out.println("--------------------START---------------------------");
            System.out.println("resource = " + delta.getResource());
            System.out.println("isPre = " + ResourceChangeUtilities.isPreEvent(event));
            System.out.println("isPostAutoBuild = " + ResourceChangeUtilities.isPostAutoBuild(event));
            System.out.println("isPostChange = " + ResourceChangeUtilities.isPostChange(event));
            System.out.println("isPreAutoBuild = " + ResourceChangeUtilities.isPreAutoBuild(event));
            System.out.println("kind=" + delta.getKind());
            System.out.println("isAdded=" + ResourceChangeUtilities.isAdded(delta));
            System.out.println("isChanged=" + ResourceChangeUtilities.isChanged(delta));
            System.out.println("isContentChanged=" + ResourceChangeUtilities.isContentChanged(delta));
            System.out.println("isDescriptionChange=" + ResourceChangeUtilities.isDescriptionChange(delta));
            System.out.println("isFile=" + ResourceChangeUtilities.isFile(delta));
            System.out.println("isFolder=" + ResourceChangeUtilities.isFolder(delta));
            System.out.println("isMovedFrom=" + ResourceChangeUtilities.isMovedFrom(delta));
            System.out.println("isMovedTo=" + ResourceChangeUtilities.isMovedTo(delta));
            System.out.println("isOpened=" + ResourceChangeUtilities.isOpened(delta));
            System.out.println("isProject=" + ResourceChangeUtilities.isProject(delta));
            System.out.println("isRemoved=" + ResourceChangeUtilities.isRemoved(delta));
            System.out.println("isReplaced=" + ResourceChangeUtilities.isReplaced(delta));
            System.out.println("isTypeChange=" + ResourceChangeUtilities.isTypeChange(delta));
            System.out.println("----------------------END-------------------------");
        }
    }
}

