/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.validation;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.util.ModelObjectCollector;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.core.validation.ValidationRuleSet;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.validation.ValidationRuleManager;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class Validator {
    private static final String VALIDATING = ModelerCore.Util.getString("Validator.validating");
    private static final String OF = ModelerCore.Util.getString("Validator.of");
    private static final String MODEL_OBJECTS = ModelerCore.Util.getString("Validator.modelObjects");
    private static final String SPACE = " ";

    public static void validate(IProgressMonitor monitor, EmfResource emfResource, ValidationContext context) {
        ArgCheck.isNotNull(emfResource);
        ArgCheck.isNotNull(context);
        monitor = monitor != null ? monitor : new NullProgressMonitor();
        context.clearResults();
        ModelObjectCollector moc = new ModelObjectCollector(emfResource);
        List eObjects = moc.getEObjects();
        int nObjects = eObjects.size();
        int objIncrement = Validator.getIncrement(nObjects);
        Iterator iter = eObjects.iterator();
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100);
        int iObject = 0;
        int incCount = 0;
        String taskMsg = null;
        while (iter.hasNext() && !monitor.isCanceled()) {
            ValidationResult lastResult = context.getLastResult();
            if (lastResult != null && lastResult.isFatalResource()) {
                return;
            }
            if (incCount == objIncrement) {
                incCount = 1;
                taskMsg = VALIDATING + SPACE + iObject + SPACE + OF + SPACE + nObjects + SPACE + MODEL_OBJECTS;
                subMonitor.subTask(taskMsg);
            } else {
                ++incCount;
            }
            Validator.validateObject(monitor, iter.next(), context);
            ++iObject;
        }
        Validator.validateObject(monitor, emfResource, context);
    }

    private static int getIncrement(int nObjects) {
        if (nObjects <= 200) {
            return 10;
        }
        if (nObjects <= 1000) {
            return 50;
        }
        if (nObjects <= 5000) {
            return 100;
        }
        if (nObjects <= 10000) {
            return 200;
        }
        return 500;
    }

    public static void validateObject(IProgressMonitor monitor, Object object, ValidationContext context) {
        ArgCheck.isNotNull(object);
        ArgCheck.isNotNull(context);
        monitor = monitor != null ? monitor : new NullProgressMonitor();
        ValidationRuleManager ruleManager = ModelerCore.getValidationRuleManager();
        ValidationRuleSet ruleSet = ruleManager.getRuleSet(object, context);
        if (ruleSet != null && ruleSet.hasRules()) {
            ruleSet.validate(monitor, object, context);
        }
    }
}

