/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.validation;

import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ResourceValidationRule;
import com.metamatrix.modeler.core.validation.StructuralFeatureValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.core.validation.ValidationRule;
import com.metamatrix.modeler.core.validation.ValidationRuleSet;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class ValidationRuleSetImpl
implements ValidationRuleSet {
    private static final String EXCEPTION_DURING_VALIDATION_MSG = ModelerCore.Util.getString("ValidationRuleSetImpl.An_exception_was_encountered_during_validation._Check_the_log_for_details._1");
    private static final String EXCEPTION_DURING_VALIDATION_LOG_MSG = ModelerCore.Util.getString("ValidationRuleSetImpl.An_exception_was_encountered_during_validation._2");
    private static final ValidationRule[] EMPTY_ARRAY = new ValidationRule[0];
    private ObjectVector ruleSet;

    public void addRule(ValidationRule rule) {
        if (rule == null) {
            return;
        }
        if (this.ruleSet == null) {
            this.ruleSet = new ObjectVector(5);
        }
        if (!this.ruleSet.containsIdentical(rule)) {
            this.ruleSet.add(rule);
        }
    }

    public ValidationRule[] getRules() {
        if (!this.hasRules()) {
            return EMPTY_ARRAY;
        }
        Object[] result = new ValidationRule[this.ruleSet.size()];
        this.ruleSet.copyInto(result);
        return result;
    }

    public boolean hasRules() {
        return this.ruleSet != null && this.ruleSet.size() > 0;
    }

    public void validate(IProgressMonitor progressMonitor, Object object, ValidationContext context) {
        if (!this.hasRules()) {
            return;
        }
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        try {
            int n2 = this.ruleSet.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Collection results;
                if (monitor.isCanceled()) {
                    return;
                }
                if (object instanceof EObject && (results = context.getTargetResults((EObject)object)) != null && !results.isEmpty()) {
                    Iterator itr = results.iterator();
                    while (itr.hasNext()) {
                        ValidationResult result = (ValidationResult)itr.next();
                        if (!result.isFatalResource() && !result.isFatalObject(object)) continue;
                        return;
                    }
                }
                ValidationRule rule = (ValidationRule)this.ruleSet.elementAt(i2);
                if (object instanceof EObject) {
                    EObject target = (EObject)object;
                    if (rule instanceof ObjectValidationRule) {
                        ObjectValidationRule objRule = (ObjectValidationRule)rule;
                        objRule.validate(target, context);
                        continue;
                    }
                    if (!(rule instanceof StructuralFeatureValidationRule)) continue;
                    StructuralFeatureValidationRule featureRule = (StructuralFeatureValidationRule)rule;
                    EList features = target.eClass().getEAllStructuralFeatures();
                    Iterator iter = features.iterator();
                    while (iter.hasNext()) {
                        EStructuralFeature feature = (EStructuralFeature)iter.next();
                        if (feature.isVolatile() && feature.isTransient()) continue;
                        featureRule.validate(feature, target, target.eGet(feature), context);
                    }
                    continue;
                }
                if (!(object instanceof Resource)) continue;
                Resource resource = (Resource)object;
                if (!(rule instanceof ResourceValidationRule)) continue;
                ResourceValidationRule rscRule = (ResourceValidationRule)rule;
                rscRule.validate(resource, context);
            }
        }
        catch (Throwable e2) {
            String errMsg = e2.getMessage();
            if (errMsg != null && errMsg.length() > 0) {
                this.addProblem(object, 0, 4, e2.getMessage(), context);
            }
            this.addProblem(object, 0, 4, EXCEPTION_DURING_VALIDATION_MSG, context);
            ModelerCore.Util.log(4, e2, EXCEPTION_DURING_VALIDATION_LOG_MSG);
        }
    }

    private void addProblem(Object object, int code, int severity, String msg, ValidationContext context) {
        ValidationProblemImpl problem = new ValidationProblemImpl(code, severity, msg);
        ValidationResultImpl result = new ValidationResultImpl(object);
        result.addProblem(problem);
        context.addResult(result);
    }
}

