/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.validation;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ValidationProblemImpl
implements ValidationProblem {
    private final int code;
    private final int severity;
    private final String message;
    private boolean hasPreference;
    private final String uri;
    private final String location;

    public ValidationProblemImpl(IStatus status) {
        this(status.getCode(), status.getSeverity(), status.getMessage());
    }

    public ValidationProblemImpl(int code, int severity, String message) {
        this(code, severity, message, null, null);
    }

    public ValidationProblemImpl(int code, int severity, String message, String location, String uri) {
        this.validateSeverity(severity);
        this.code = code;
        this.severity = severity;
        this.message = message;
        this.uri = uri;
        this.location = location;
    }

    private void validateSeverity(int severity) {
        if (severity == 4 || severity == 1 || severity == 0 || severity == 2) {
            return;
        }
        throw new IllegalArgumentException(ModelerCore.Util.getString("ValidationProblemImpl.Invalid_severity.__Value_must_be_one_of_valid_status_constants_from_IStatus_class_1"));
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        if (!this.hasPreference) {
            return this.message;
        }
        return this.message + ModelerCore.Util.getString("ValidationProblemImpl.option_preference");
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setHasPreference(boolean hasPreference) {
        this.hasPreference = hasPreference;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getSeverityString());
        buffer.append(" - ");
        buffer.append(this.getMessage());
        return buffer.toString();
    }

    private String getSeverityString() {
        switch (this.severity) {
            case 4: {
                return ModelerCore.Util.getString("ValidationProblemImpl.Error_1");
            }
            case 1: {
                return ModelerCore.Util.getString("ValidationProblemImpl.Info_2");
            }
            case 0: {
                return ModelerCore.Util.getString("ValidationProblemImpl.OK_3");
            }
            case 2: {
                return ModelerCore.Util.getString("ValidationProblemImpl.Warning_4");
            }
        }
        return ModelerCore.Util.getString("ValidationProblemImpl.Unknown_Severity_5");
    }

    public IStatus getStatus() {
        return new Status(this.severity, "com.metamatrix.modeler.core", this.code, this.message, null);
    }

    public String getURI() {
        return this.uri;
    }

    public String getLocation() {
        return this.location;
    }
}

