/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.util;

import com.metamatrix.core.plugin.PluginUtilities;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.workspace.ModelStatusImpl;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;

public class Util {
    public static CoreException newCoreException(int errorCode, String msg) {
        return new ModelWorkspaceException(new ModelStatusImpl(errorCode, msg));
    }

    public static CoreException newCoreException(int errorCode, Throwable t2, String msg) {
        return new ModelWorkspaceException(new ModelStatusImpl(errorCode, t2, msg));
    }

    public static void loadExtensionMap(String extensionPointID, Map extensionMap) {
        if (extensionPointID == null) {
            String msg = ModelerCore.Util.getString("Util.The_extension_ID_may_not_be_null_1");
            throw new IllegalArgumentException(msg);
        }
        if (extensionMap == null) {
            String msg = ModelerCore.Util.getString("Util.The_Map_reference_may_not_be_null_2");
            throw new IllegalArgumentException(msg);
        }
        IExtension[] extensions = PluginUtilities.getExtensions(extensionPointID);
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            String uniqueID = extension.getUniqueIdentifier();
            extensionMap.put(uniqueID, extension);
        }
    }

    public static Object createExtensionInstance(String uniqueID, Map extensionMap) throws CoreException {
        if (uniqueID == null) {
            String msg = ModelerCore.Util.getString("Util.The_extension_uniqueID_may_not_be_null_3");
            throw new IllegalArgumentException(msg);
        }
        if (extensionMap == null) {
            String msg = ModelerCore.Util.getString("Util.The_Map_reference_may_not_be_null_4");
            throw new IllegalArgumentException(msg);
        }
        IExtension extension = (IExtension)extensionMap.get(uniqueID);
        if (extension == null) {
            throw Util.newCoreException(1, ModelerCore.Util.getString("Util.Unable_to_find_an_extension_with_unique_ID___5") + uniqueID + "\"");
        }
        return Util.createExecutableExtension(extension);
    }

    public static Object createExecutableExtension(IExtension extension) throws CoreException {
        if (extension == null) {
            String msg = ModelerCore.Util.getString("Util.The_IExtension_reference_may_not_be_null_7");
            throw new IllegalArgumentException(msg);
        }
        try {
            return PluginUtilities.createExecutableExtension(extension, "class", "name");
        }
        catch (CoreException e2) {
            throw Util.newCoreException(1, ModelerCore.Util.getString("Util.Error_creating_instance_of_extension_with_ID___10") + extension.getUniqueIdentifier() + "\"");
        }
    }
}

