/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.transaction;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.transaction.Undoable;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import java.util.Collection;
import org.eclipse.emf.common.command.CompoundCommand;

public class UndoableImpl
implements Undoable {
    private final CompoundCommand command;
    private final Collection resources;
    private final Object id;
    private final Container container;
    private final Object source;
    private String description;
    private boolean significant;

    public UndoableImpl(Container container, CompoundCommand command, Collection resources, Object id, Object source) {
        ArgCheck.isNotNull(container);
        ArgCheck.isNotNull(command);
        ArgCheck.isNotNull(resources);
        ArgCheck.isNotNull(id);
        this.container = container;
        this.command = command;
        this.resources = resources;
        this.id = id;
        this.source = source;
        this.significant = true;
    }

    public UndoableImpl(Container container, CompoundCommand command, Collection resources, Object id) {
        this(container, command, resources, id, null);
    }

    public void undo() throws ModelerCoreException {
        if (this.command.canUndo()) {
            boolean requiredStart = false;
            UnitOfWork uow = this.container.getEmfTransactionProvider().getCurrent();
            if (uow.requiresStart()) {
                uow.begin();
                uow.setUndoable(false);
                requiredStart = true;
            }
            this.command.undo();
            if (requiredStart) {
                try {
                    uow.commit();
                }
                catch (ModelerCoreException e2) {
                    uow.rollback();
                    throw e2;
                }
            }
            return;
        }
        throw new ModelerCoreException(ModelerCore.Util.getString("UndoableImpl.Can_not_perform_undo_for_{0}_1", this.command.getLabel()));
    }

    public boolean canUndo() {
        return this.command.canUndo();
    }

    public void redo() throws ModelerCoreException {
        if (this.command.canExecute()) {
            boolean requiredStart = false;
            UnitOfWork uow = this.container.getEmfTransactionProvider().getCurrent();
            if (!uow.isStarted()) {
                uow.begin();
                uow.setUndoable(false);
                requiredStart = true;
            }
            this.command.execute();
            if (requiredStart) {
                try {
                    uow.commit();
                }
                catch (ModelerCoreException e2) {
                    uow.rollback();
                    throw e2;
                }
            }
            return;
        }
        throw new ModelerCoreException(ModelerCore.Util.getString("UndoableImpl.Can_not_perform_redo_for_{0}_2", this.command.getLabel()));
    }

    public boolean canRedo() {
        return this.command.canExecute();
    }

    public void die() {
        this.resources.clear();
        this.significant = true;
    }

    public String getPresentationName() {
        if (this.description == null) {
            return this.command.getLabel();
        }
        return this.description;
    }

    public String getUndoPresentationName() {
        if (this.description == null) {
            return ModelerCore.Util.getString("UndoableImpl.Undo__3") + this.command.getLabel();
        }
        return ModelerCore.Util.getString("UndoableImpl.Undo__3") + this.description;
    }

    public String getRedoPresentationName() {
        if (this.description == null) {
            return ModelerCore.Util.getString("UndoableImpl.Redo__4") + this.command.getLabel();
        }
        return ModelerCore.Util.getString("UndoableImpl.Redo__4") + this.description;
    }

    public Object getId() {
        return this.id;
    }

    public Collection getResources() {
        return this.resources;
    }

    public CompoundCommand getCommand() {
        return this.command;
    }

    public String toString() {
        if (this.description != null) {
            return this.description;
        }
        return this.command.toString();
    }

    public boolean isSignificant() {
        return this.significant;
    }

    public void setSignificant(boolean isSignificant) {
        this.significant = isSignificant;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Object getSource() {
        return this.source;
    }
}

