/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.search.commands;

import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.search.commands.FindRelatedObjectsCommand;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.index.ModelWorkspaceSearchIndexSelector;
import com.metamatrix.modeler.internal.core.search.runtime.SearchRuntimeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class FindRelatedObjectsCommandImpl
implements FindRelatedObjectsCommand {
    private String modelObjectUri;
    private Collection relatedObjInfo;
    private IndexSelector selector;

    public boolean canExecute() {
        return true;
    }

    public IStatus execute() {
        String objectUUID = null;
        if (!StringUtil.isEmpty(this.modelObjectUri)) {
            URI objectUri = URI.createURI(this.modelObjectUri);
            objectUUID = objectUri.fragment();
            objectUUID = objectUUID.replace('/', ':');
        }
        String searchPrefix = IndexUtil.getPrefixPattern('F', objectUUID);
        try {
            IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), searchPrefix.toCharArray(), true, true);
            this.relatedObjInfo = new ArrayList(results.length);
            for (int i2 = 0; i2 < results.length; ++i2) {
                IEntryResult result = results[i2];
                this.relatedObjInfo.add(SearchRuntimeAdapter.createRelatedObjectRecord(result.getWord()));
            }
        }
        catch (Exception e2) {
            ModelerCore.Util.log(e2);
            return new Status(4, "com.metamatrix.modeler.core", 0, ModelerCore.Util.getString("FindRelatedObjectsCommandImpl.Error_trying_to_execute_command,_problem_trying_to_query_relationship_search_indexes._1"), e2);
        }
        return new Status(0, "com.metamatrix.modeler.core", 0, "", null);
    }

    public Collection getRelatedObjectInfo() {
        if (this.relatedObjInfo == null) {
            return Collections.EMPTY_LIST;
        }
        return this.relatedObjInfo;
    }

    public void setModelObjectUri(String object) {
        ArgCheck.isNotEmpty(object);
        this.modelObjectUri = object;
    }

    private IndexSelector getIndexSelector() {
        this.selector = this.selector != null ? this.selector : new ModelWorkspaceSearchIndexSelector();
        return this.selector;
    }

    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }
}

