/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.resource.xmi;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.metamodels.core.Identifiable;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class MtkXmiSaveImpl
extends XMISaveImpl {
    protected static final String URI_REFERENCE_DELIMITER = "#";
    protected static final String XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX = ModelerCore.XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX;
    protected static final String XML_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX = "XMLSchema.xsd";
    protected static final String XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX = "MagicXMLSchema.xsd";
    protected static final String XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI_SUFFIX = "XMLSchema-instance.xsd";
    protected static final char UUID_PROTOCOL_DELIMITER = '/';
    protected static final String XMI_UUID = "uuid";
    protected static final String XMI_UUID_NS = "xmi:uuid";
    protected static final String BAD_DATATYPE_HREF = "#null";
    private static final String AMP = "&amp;";
    private static final String LT = "&lt;";
    private static final String QUOT = "&quot;";
    private static final String HEX_PREFIX = "&#x";
    private boolean escaped;
    private final MtkXmiResourceImpl xmiResource;
    private final DatatypeManager dtMgr;

    public MtkXmiSaveImpl(XMLHelper helper, MtkXmiResourceImpl xmiResource) {
        super(helper);
        if (xmiResource == null) {
            String msg = ModelerCore.Util.getString("MtkXmiSaveImpl.The_MtkXMIResourceImpl_reference_may_not_be_null_3");
            throw new IllegalArgumentException(msg);
        }
        this.xmiResource = xmiResource;
        this.dtMgr = xmiResource.getContainer().getDatatypeManager();
    }

    protected String getContent(EObject o2, EStructuralFeature[] features) {
        XMLResource.XMLMap map = this.helper.getXMLMap();
        if (map == null) {
            return null;
        }
        for (int i2 = 0; i2 < features.length; ++i2) {
            XMLResource.XMLInfo info = map.getInfo(features[i2]);
            if (info == null || info.getXMLRepresentation() != 2) continue;
            Object value = this.helper.getValue(o2, features[i2]);
            if (value == null) {
                return null;
            }
            EDataType d2 = (EDataType)features[i2].getEType();
            EPackage ePackage = d2.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            String svalue = fac.convertToString(d2, value);
            if (this.escaped) {
                svalue = this.convert(svalue);
            }
            return svalue;
        }
        return null;
    }

    protected void init(XMLResource resource, Map options) {
        super.init(resource, options);
        this.escape = null;
        this.escaped = !Boolean.TRUE.equals(options.get("SKIP_ESCAPE"));
    }

    protected void saveDataTypeElementSingle(EObject o2, EStructuralFeature f2) {
        String name = this.helper.getQName(f2);
        Object value = this.helper.getValue(o2, f2);
        if (value == null) {
            this.doc.startElement(name);
            this.doc.addAttribute("xsi:nil", "true");
            this.doc.endEmptyElement();
            this.declareXSI = true;
        } else {
            EDataType d2 = (EDataType)f2.getEType();
            EPackage ePackage = d2.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            this.doc.startElement(name);
            String svalue = fac.convertToString(d2, value);
            if (this.escaped) {
                svalue = this.convert(svalue);
            }
            this.doc.endContentElement(svalue);
        }
    }

    protected void saveDataTypeSingle(EObject o2, EStructuralFeature f2) {
        EDataType d2 = (EDataType)f2.getEType();
        EPackage ePackage = d2.getEPackage();
        EFactory fac = ePackage.getEFactoryInstance();
        Object value = this.helper.getValue(o2, f2);
        if (value != null) {
            String svalue = fac.convertToString(d2, value);
            if (this.escaped) {
                svalue = this.convert(svalue);
            }
            this.doc.addAttribute(this.helper.getQName(f2), svalue);
        }
    }

    protected void saveDataTypeMany(EObject o2, EStructuralFeature f2) {
        EDataType d2 = (EDataType)f2.getEType();
        EPackage ePackage = d2.getEPackage();
        EFactory fac = ePackage.getEFactoryInstance();
        List values = (List)this.helper.getValue(o2, f2);
        int size = values.size();
        if (size > 0) {
            String name = this.helper.getQName(f2);
            for (int i2 = 0; i2 < size; ++i2) {
                Object value = values.get(i2);
                if (value == null) {
                    this.doc.startElement(name);
                    this.doc.addAttribute("xsi:nil", "true");
                    this.doc.endEmptyElement();
                    this.declareXSI = true;
                    continue;
                }
                this.doc.startElement(name);
                String svalue = fac.convertToString(d2, value);
                if (this.escaped) {
                    svalue = this.convert(svalue);
                }
                this.doc.endContentElement(svalue);
            }
        }
    }

    protected void saveElementID(EObject o2) {
        ObjectID uuid;
        String id = this.helper.getID(o2);
        if (id != null) {
            this.doc.addAttribute(this.idAttributeName, id);
        }
        if ((uuid = o2.getObjectId()) != null) {
            this.doc.addAttribute(XMI_UUID_NS, ((Object)uuid).toString());
            this.xmiResource.recordUUID(o2, false);
        }
        this.saveFeatures(o2);
    }

    protected void saveElementReference(EObject remote, EStructuralFeature f2) {
        if (remote instanceof Identifiable) {
            String name = this.helper.getQName(f2);
            String href = ((Identifiable)remote).getUuid();
            if (href != null) {
                href = href.replace(':', '/');
                this.doc.startElement(name);
                this.doc.endContentElement(href);
            }
            return;
        }
        super.saveElementReference(remote, f2);
    }

    protected void saveHref(EObject remote, EStructuralFeature f2) {
        if (this.saveDatatypeHref(remote, f2)) {
            return;
        }
        if (this.saveIdentifiableHref(remote, f2)) {
            return;
        }
        if (this.saveXmlSchemaHref(remote, f2)) {
            return;
        }
        super.saveHref(remote, f2);
    }

    protected void saveIDRefSingle(EObject eObject, EStructuralFeature f2) {
        EObject value = (EObject)this.helper.getValue(eObject, f2);
        if (value != null && value instanceof Identifiable) {
            String name = this.helper.getQName(f2);
            String id = ((Identifiable)value).getUuid();
            id = id.replace(':', '/');
            this.doc.addAttribute(name, id);
        } else {
            super.saveIDRefSingle(eObject, f2);
        }
    }

    protected void saveIDRefMany(EObject eObject, EStructuralFeature f2) {
        InternalEList values = (InternalEList)this.helper.getValue(eObject, f2);
        if (!values.isEmpty()) {
            String name = this.helper.getQName(f2);
            StringBuffer ids = new StringBuffer(values.size() * 10);
            Iterator i2 = values.basicIterator();
            while (true) {
                EObject value = (EObject)i2.next();
                String id = null;
                if (value instanceof Identifiable) {
                    id = ((Identifiable)value).getUuid();
                    id = id.replace(':', '/');
                } else {
                    id = this.helper.getIDREF(value);
                }
                ids.append(id);
                if (!i2.hasNext()) break;
                ids.append(" ");
            }
            this.doc.addAttribute(name, ids.toString());
        }
    }

    protected void saveHRefMany(EObject o2, EStructuralFeature f2) {
        InternalEList values = (InternalEList)this.helper.getValue(o2, f2);
        Iterator basicIterator = values.basicIterator();
        while (basicIterator.hasNext()) {
            this.saveHref((EObject)basicIterator.next(), f2);
        }
    }

    private String convert(String value) {
        if (value == null) {
            return null;
        }
        char[] chrs = new char[value.length()];
        value.getChars(0, chrs.length, chrs, 0);
        StringBuffer newVal = new StringBuffer();
        int len = chrs.length;
        block5: for (int ndx = 0; ndx < len; ++ndx) {
            char chr = chrs[ndx];
            switch (chr) {
                case '&': {
                    newVal.append(AMP);
                    continue block5;
                }
                case '<': {
                    newVal.append(LT);
                    continue block5;
                }
                case '\"': {
                    newVal.append(QUOT);
                    continue block5;
                }
                default: {
                    if (chr < ' ' || chr > '\u007f') {
                        newVal.append(HEX_PREFIX + Integer.toHexString(chr) + ';');
                        continue block5;
                    }
                    newVal.append(chr);
                }
            }
        }
        return newVal.toString();
    }

    private boolean saveDatatypeHref(EObject remote, EStructuralFeature f2) {
        if (this.dtMgr.isBuiltInDatatype(remote)) {
            String href;
            XSDSimpleTypeDefinition datatype = (XSDSimpleTypeDefinition)remote;
            String name = this.helper.getQName(f2);
            boolean remoteIsProxy = remote.eIsProxy();
            String string = href = remoteIsProxy ? EcoreUtil.getURI(remote).toString() : datatype.getURI();
            if (BAD_DATATYPE_HREF.equals(href)) {
                Object[] params = new Object[]{remote};
                String msg = ModelerCore.Util.getString("MtkXmiSaveImpl.The_href_for_Datatype_0_is_bad._1", params);
                ModelerCore.Util.log(4, msg);
            }
            if (!remoteIsProxy && href.startsWith(URI_REFERENCE_DELIMITER) && remote.eResource() != null) {
                Resource eResource = remote.eResource();
                String resourcePath = WorkspaceResourceFinderUtil.getWorkspaceUri(eResource);
                href = resourcePath != null ? resourcePath + href : eResource.getURI().toString() + href;
            }
            if (href != null) {
                this.doc.startElement(name);
                EClass eClass = remote.eClass();
                EClass expectedType = (EClass)f2.getEType();
                if (eClass != expectedType && expectedType.isAbstract()) {
                    this.saveTypeAttribute(eClass);
                }
                this.doc.addAttribute("href", href);
                this.doc.endEmptyElement();
            }
            return true;
        }
        return false;
    }

    private boolean saveIdentifiableHref(EObject remote, EStructuralFeature f2) {
        if (remote instanceof Identifiable) {
            Identifiable idable = (Identifiable)remote;
            String name = this.helper.getQName(f2);
            boolean remoteIsProxy = remote.eIsProxy();
            String href = null;
            if (!remoteIsProxy) {
                href = idable.getUuid();
                if (remote.eResource() != null) {
                    Resource eResource = remote.eResource();
                    String resourcePath = WorkspaceResourceFinderUtil.getWorkspaceUri(eResource);
                    href = resourcePath != null ? resourcePath + URI_REFERENCE_DELIMITER + href : eResource.getURI().toString() + URI_REFERENCE_DELIMITER + href;
                }
            } else {
                href = EcoreUtil.getURI(remote).toString();
            }
            if (href != null) {
                this.doc.startElement(name);
                EClass eClass = remote.eClass();
                EClass expectedType = (EClass)f2.getEType();
                if (eClass != expectedType && expectedType.isAbstract()) {
                    this.saveTypeAttribute(eClass);
                }
                this.doc.addAttribute("href", href);
                this.doc.endEmptyElement();
            }
            return false;
        }
        return false;
    }

    private boolean saveXmlSchemaHref(EObject remote, EStructuralFeature f2) {
        URI uri = EcoreUtil.getURI(remote);
        URI resourceUri = uri.trimFragment();
        String resourceUriString = resourceUri.toString();
        String href = null;
        if (resourceUriString.startsWith(XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX)) {
            if (resourceUriString.endsWith(XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX)) {
                href = "http://www.w3.org/2001/MagicXMLSchema#" + uri.fragment();
            } else if (resourceUriString.endsWith(XML_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX)) {
                href = "http://www.w3.org/2001/XMLSchema#" + uri.fragment();
            } else if (resourceUriString.endsWith(XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI_SUFFIX)) {
                href = "http://www.w3.org/2001/XMLSchema-instance#" + uri.fragment();
            }
        }
        if (href == null) {
            return false;
        }
        String name = this.helper.getQName(f2);
        this.doc.startElement(name);
        EClass eClass = remote.eClass();
        EClass expectedType = (EClass)f2.getEType();
        if (eClass != expectedType && expectedType.isAbstract()) {
            this.saveTypeAttribute(eClass);
        }
        this.doc.addAttribute("href", href);
        this.doc.endEmptyElement();
        return true;
    }
}

