/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.resource;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.internal.core.xml.xmi.XMIHeaderReader;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.resource.EObjectCache;
import com.metamatrix.modeler.core.resource.EObjectCacheHolder;
import com.metamatrix.modeler.core.resource.EProxyCacheHolder;
import com.metamatrix.modeler.core.resource.EResource;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelObjectCollector;
import com.metamatrix.modeler.internal.core.resource.EObjectCacheImpl;
import com.metamatrix.modeler.internal.core.resource.EResourceLoader;
import com.metamatrix.modeler.internal.core.resource.EResourceXmiHelper;
import com.metamatrix.modeler.internal.core.resource.EResourceXmiSaveImpl;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class EResourceImpl
extends XMIResourceImpl
implements EResource,
EProxyCacheHolder,
EObjectCacheHolder,
EmfResource {
    public static final char UUID_PROTOCOL_DELIMITER = '/';
    private static EObject[] EMPTY_EOBJECT_ARRAY = new EObject[0];
    private static final boolean DEBUG = false;
    private Map prefixesToURIs;
    private ModelContents modelContents;
    private int loadedCount;
    private EObjectCache eProxyCache;
    private EObjectCache eObjectCache;

    public EResourceImpl(URI uri) {
        super(uri);
        ArgCheck.isNotNull(uri);
        this.loadedCount = 0;
        this.modelContents = new ModelContents(this);
        this.prefixesToURIs = new HashMap();
        this.eProxyCache = new EObjectCacheImpl();
        this.eObjectCache = new EObjectCacheImpl();
        this.eAdapters().add(new EObjectCacheAdapter());
    }

    protected XMLHelper createXMLHelper() {
        return new EResourceXmiHelper(this);
    }

    protected XMLSave createXMLSave() {
        return new EResourceXmiSaveImpl(this.createXMLHelper(), this);
    }

    protected XMLLoad createXMLLoad() {
        return new EResourceLoader(this.createXMLHelper());
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        ArgCheck.isNotNull(inputStream);
        ++this.loadedCount;
        XMLLoad xmlLoad = this.createXMLLoad();
        xmlLoad.load((XMLResource)this, inputStream, options);
        this.setPrefixToUriMap(xmlLoad);
        this.getEProxyCache().clear();
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        this.moveModelAnnotation();
        this.setProductInfoOnModelAnnotation();
        super.doSave(outputStream, options);
    }

    protected void doUnload() {
        ModelObjectCollector moc = new ModelObjectCollector(this);
        this.getEProxyCache().clear();
        Iterator iter = moc.getEObjects().iterator();
        while (iter.hasNext()) {
            this.addToEProxyCache((EObject)iter.next());
        }
        super.doUnload();
        this.getEObjectCache().clear();
        this.setModified(false);
        this.modelContents = null;
        iter = moc.getEObjects().iterator();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            EClass eClass = eObject.eClass();
            Iterator iter2 = eClass.getEAllStructuralFeatures().iterator();
            while (iter2.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)iter2.next();
                if (!feature.isChangeable()) continue;
                eObject.eUnset(feature);
            }
        }
    }

    public String getURIFragment(EObject eObject) {
        return eObject != null && eObject.getObjectId() != null ? eObject.getObjectId().toString('/') : null;
    }

    public EObject getEObject(String uriFragment) {
        ObjectID id;
        if (uriFragment != null && uriFragment.startsWith("mmuuid") && (id = this.getObjectIDFromString(uriFragment)) != null) {
            return this.findInEObjectCache(id);
        }
        return null;
    }

    protected EObject getEObjectByID(String id) {
        return this.getEObject(id);
    }

    public EList getContents() {
        if (this.contents == null) {
            this.contents = new EResourceContentsEList(this);
        }
        return this.contents;
    }

    public void detached(EObject eObject) {
        this.removeFromEObjectCache(eObject, true);
        super.detached(eObject);
    }

    public void attached(EObject eObject) {
        this.addToEObjectCache(eObject, true);
        super.attached(eObject);
    }

    public Container getContainer() {
        return null;
    }

    public EObject getEObject(Object key) {
        if (key instanceof URI) {
            return this.getResourceSet().getEObject(this.uri, true);
        }
        if (key instanceof ObjectID) {
            return this.getEObject((ObjectID)key);
        }
        return null;
    }

    public boolean isVisible() {
        boolean isVisible = true;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            isVisible = this.getModelContents().getModelAnnotation().isVisible();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                isVisible = header.isVisible();
            }
        }
        return isVisible;
    }

    public List getNamespacePrefixToUris() {
        return null;
    }

    public int getLoadedCount() {
        return this.loadedCount;
    }

    public String getDescription() {
        String description = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            description = this.getModelContents().getModelAnnotation().getDescription();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                description = header.getDescription();
            }
        }
        return description;
    }

    public ModelType getModelType() {
        ModelType type = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            type = this.getModelContents().getModelAnnotation().getModelType();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                type = ModelType.get(header.getModelType());
            }
        }
        return type;
    }

    public URI getPrimaryMetamodelUri() {
        String primaryMetamodelUri = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            primaryMetamodelUri = this.getModelContents().getModelAnnotation().getPrimaryMetamodelUri();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                primaryMetamodelUri = header.getPrimaryMetamodelURI();
            }
        }
        if (StringUtil.isEmpty(primaryMetamodelUri)) {
            return null;
        }
        return URI.createURI(primaryMetamodelUri);
    }

    public ObjectID getUuid() {
        ObjectID uuid = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            uuid = this.getModelContents().getModelAnnotation().getObjectId();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null && header.getUUID() != null) {
                uuid = this.getObjectIDFromString(header.getUUID());
            }
        }
        return uuid;
    }

    public ModelContents getModelContents() {
        if (this.modelContents == null) {
            this.modelContents = new ModelContents(this);
        }
        return this.modelContents;
    }

    public Map getNamespacePrefixToUrisMap() {
        return this.prefixesToURIs;
    }

    public EObject getEObject(ObjectID key) {
        return this.findInEObjectCache(key);
    }

    public EObject getEProxy(ObjectID key) {
        return this.findInEProxyCache(key);
    }

    public ModelAnnotation getModelAnnotation() {
        ModelAnnotation modelAnnotation = null;
        Iterator iter = this.getContents().iterator();
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (!(eObj instanceof ModelAnnotation)) continue;
            modelAnnotation = (ModelAnnotation)eObj;
            break;
        }
        return modelAnnotation;
    }

    protected void moveModelAnnotation() {
        ModelAnnotation modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation != null) {
            Resource resource = modelAnnotation.eResource();
            if (resource == null) {
                this.getContents().add(0, modelAnnotation);
            } else if (!(this.getContents().get(0) instanceof ModelAnnotation)) {
                this.getContents().move(0, modelAnnotation);
            }
        }
    }

    protected void setProductInfoOnModelAnnotation() {
        ModelAnnotation modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation != null) {
            modelAnnotation.setProducerName("MetaMatrix");
            modelAnnotation.setProducerVersion("5.0");
        }
    }

    protected ObjectID getObjectIDFromString(String uuidString) {
        if (uuidString == null || uuidString.length() == 0) {
            return null;
        }
        try {
            return IDGenerator.getInstance().stringToObject(uuidString);
        }
        catch (InvalidIDException invalidIDException) {
            return null;
        }
    }

    protected XMIHeader doGetXmiHeader(URI theUri) {
        File f2;
        XMIHeader header = null;
        if (theUri != null && theUri.isFile() && (f2 = new File(this.getURI().toFileString())).isFile() && f2.exists()) {
            try {
                header = XMIHeaderReader.readHeader(f2);
            }
            catch (MetaMatrixCoreException e2) {
                ModelerCore.Util.log(e2);
            }
        }
        return header;
    }

    protected XMIHeader doGetXmiHeader() {
        return this.doGetXmiHeader(this.getURI());
    }

    protected void setPrefixToUriMap(XMLLoad xmlLoad) {
        XMLHelper xmiHelper;
        if (xmlLoad instanceof EResourceLoader && (xmiHelper = ((EResourceLoader)xmlLoad).getXMLHelper()) instanceof EResourceXmiHelper) {
            this.prefixesToURIs.clear();
            this.prefixesToURIs = ((EResourceXmiHelper)xmiHelper).getPrefixesToURIs();
        }
    }

    protected void addMany(Collection newRoots) {
        ArrayList allRoots = new ArrayList(this.getContents());
        allRoots.addAll(newRoots);
        Object[] rootArray = allRoots.toArray();
        ((BasicEList)this.getContents()).setData(rootArray.length, rootArray);
        Iterator iter = newRoots.iterator();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (eObject instanceof EObjectImpl) {
                ((EObjectImpl)eObject).eSetResource(this, null);
            }
            this.addToEObjectCache(eObject, true);
        }
    }

    protected void removeMany(Collection roots) {
        ArrayList allRoots = new ArrayList(this.getContents());
        allRoots.removeAll(roots);
        Object[] rootArray = allRoots.toArray();
        ((BasicEList)this.getContents()).setData(rootArray.length, rootArray);
        Iterator iter = roots.iterator();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (eObject instanceof EObjectImpl) {
                ((EObjectImpl)eObject).eSetResource(null, null);
            }
            this.removeFromEObjectCache(eObject, true);
        }
    }

    protected EObjectCache getEProxyCache() {
        return this.eProxyCache;
    }

    protected void addToEProxyCache(EObject eObject) {
        if (eObject != null) {
            this.getEProxyCache().add(eObject, false);
        }
    }

    protected EObject removeFromEProxyCache(ObjectID id) {
        EObject eObject = this.getEProxyCache().get(id);
        this.getEProxyCache().remove(id, false);
        return eObject;
    }

    protected EObject findInEProxyCache(ObjectID id) {
        return id != null ? this.getEProxyCache().get(id) : null;
    }

    protected EObjectCache getEObjectCache() {
        return this.eObjectCache;
    }

    protected void addToEObjectCache(EObject eObject, boolean recurse) {
        if (eObject != null) {
            this.getEObjectCache().add(eObject, recurse);
        }
    }

    protected EObject removeFromEObjectCache(ObjectID id, boolean recurse) {
        EObject eObject = this.getEObjectCache().get(id);
        this.getEObjectCache().remove(id, recurse);
        return eObject;
    }

    protected void removeFromEObjectCache(EObject eObject, boolean recurse) {
        this.getEObjectCache().remove(eObject, recurse);
    }

    protected EObject findInEObjectCache(ObjectID id) {
        EObject eObject = null;
        if (id != null) {
            eObject = this.getEObjectCache().get(id);
        }
        return eObject;
    }

    private class EObjectCacheAdapter
    extends AdapterImpl {
        private EObjectCacheAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.isTouch()) {
                return;
            }
            Object feature = notification.getFeature();
            if (feature == null || feature instanceof EReference && ((EReference)feature).isContainment()) {
                int eventType = notification.getEventType();
                Object oldVal = notification.getOldValue();
                Object newVal = notification.getNewValue();
                switch (eventType) {
                    case 4: {
                        if (!(oldVal instanceof EObject)) break;
                        EResourceImpl.this.getEObjectCache().remove((EObject)oldVal, true);
                        break;
                    }
                    case 6: {
                        if (!(oldVal instanceof Collection)) break;
                        EObject[] oldVals = this.collectionToEObjectArray((Collection)oldVal);
                        EResourceImpl.this.getEObjectCache().remove(oldVals, true);
                        break;
                    }
                    case 3: {
                        if (!(newVal instanceof EObject)) break;
                        EResourceImpl.this.getEObjectCache().add((EObject)newVal, true);
                        break;
                    }
                    case 5: {
                        if (!(newVal instanceof Collection)) break;
                        EObject[] newVals = this.collectionToEObjectArray((Collection)newVal);
                        EResourceImpl.this.getEObjectCache().add(newVals, true);
                        break;
                    }
                }
            }
        }

        private EObject[] collectionToEObjectArray(Collection values) {
            if (values == null || values.isEmpty()) {
                return EMPTY_EOBJECT_ARRAY;
            }
            ArrayList result = new ArrayList(values.size());
            Iterator i2 = values.iterator();
            while (i2.hasNext()) {
                Object obj = i2.next();
                if (!(obj instanceof EObject)) continue;
                result.add(obj);
            }
            return result.toArray(new EObject[result.size()]);
        }
    }

    protected class EResourceContentsEList
    extends ResourceImpl.ContentsEList {
        private final EResourceImpl owner;

        public EResourceContentsEList(EResourceImpl owner) {
            this.owner = owner;
        }

        public boolean addAll(Collection c2) {
            if (c2 == null || c2.isEmpty()) {
                return false;
            }
            ArrayList roots = new ArrayList(c2);
            Iterator i2 = roots.iterator();
            while (i2.hasNext()) {
                EObject root = (EObject)i2.next();
                if (root != null) continue;
                i2.remove();
            }
            int index = this.size;
            this.owner.addMany(roots);
            BasicEList vals = new BasicEList(roots);
            EResourceImpl.this.eNotify(this.createNotification(5, null, vals, index, true));
            return true;
        }

        public boolean removeAll(Collection c2) {
            if (c2 == null || c2.isEmpty()) {
                return false;
            }
            BasicEList vals = new BasicEList(c2);
            int[] removedIndexes = this.getIndexes(vals);
            this.owner.removeMany(c2);
            if (vals.size() == 1) {
                EResourceImpl.this.eNotify(this.createNotification(4, vals.get(0), null, removedIndexes[0]));
            } else {
                EResourceImpl.this.eNotify(this.createNotification(6, vals, removedIndexes, removedIndexes[0], true));
            }
            return true;
        }

        private int[] getIndexes(Collection vals) {
            BasicEList tmp = new BasicEList(this);
            int[] result = new int[vals.size()];
            Iterator it = tmp.iterator();
            int count = 0;
            int index = 0;
            while (it.hasNext()) {
                Object next = it.next();
                if (vals.contains(next)) {
                    result[count++] = index;
                }
                ++index;
            }
            return result;
        }
    }
}

