/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.resource;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.resource.EObjectCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class EObjectCacheImpl
implements EObjectCache {
    private static final int MAX_MAP_SIZE = 1500;
    private static final int MAP_CONSOLIDATION_SIZE = 300;
    private final Collection mapOfMaps;
    private Map currentMap = this.createMap();

    public EObjectCacheImpl() {
        this.mapOfMaps = new ArrayList();
        this.mapOfMaps.add(this.currentMap);
    }

    public void add(EObject[] values, boolean recurse) {
        for (int i2 = 0; i2 != values.length; ++i2) {
            this.add(values[i2], recurse);
        }
    }

    public void add(EObject value, boolean recurse) {
        ArgCheck.isNotNull(value);
        Object key = this.getCacheKey(value);
        Map eObjMap = this.findMapForKey(key);
        if (eObjMap != null) {
            eObjMap.remove(key);
        }
        if (this.currentMap.size() < 1500) {
            this.currentMap.put(key, value);
        } else {
            boolean newMap = true;
            Iterator iter = this.mapOfMaps.iterator();
            while (iter.hasNext()) {
                Map next = (Map)iter.next();
                if (next == this.currentMap || next.size() >= 1500) continue;
                this.currentMap = next;
                this.currentMap.put(key, value);
                newMap = false;
                break;
            }
            if (newMap) {
                this.currentMap = this.createMap();
                this.mapOfMaps.add(this.currentMap);
                this.currentMap.put(key, value);
            }
        }
        if (recurse) {
            Iterator iter = value.eContents().iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof EObject)) continue;
                this.add((EObject)obj, recurse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            Iterator iter = this.mapOfMaps.iterator();
            while (iter.hasNext()) {
                Map next = (Map)iter.next();
                next.clear();
                iter.remove();
            }
            this.currentMap = this.createMap();
            this.mapOfMaps.add(this.currentMap);
        }
        finally {
            this.runGC();
        }
    }

    public boolean containsKey(ObjectID key) {
        if (this.currentMap.containsKey(key)) {
            return true;
        }
        Iterator iter = this.mapOfMaps.iterator();
        while (iter.hasNext()) {
            Map next = (Map)iter.next();
            if (next == this.currentMap || !next.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(EObject value) {
        if (this.currentMap.containsValue(value)) {
            return true;
        }
        Iterator iter = this.mapOfMaps.iterator();
        while (iter.hasNext()) {
            Map next = (Map)iter.next();
            if (next == this.currentMap || !next.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public EObject get(ObjectID key) {
        if (key == null) {
            return null;
        }
        Map map = this.findMapForKey(key);
        if (map != null) {
            return (EObject)map.get(key);
        }
        return null;
    }

    public void remove(EObject value, boolean recurse) {
        ArgCheck.isNotNull(value);
        Object key = this.getCacheKey(value);
        Map map = this.findMapForValue(value);
        if (map != null) {
            map.remove(key);
            if (map != this.currentMap && map.size() < 300) {
                this.consolidateMap(map);
            }
        }
        if (recurse) {
            Iterator iter = value.eContents().iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof EObject)) continue;
                this.remove((EObject)obj, recurse);
            }
        }
    }

    public void remove(EObject[] values, boolean recurse) {
        for (int i2 = 0; i2 != values.length; ++i2) {
            this.remove(values[i2], recurse);
        }
    }

    public void remove(ObjectID key, boolean recurse) {
        ArgCheck.isNotNull(key);
        EObject value = null;
        Map map = this.findMapForKey(key);
        if (map != null) {
            value = (EObject)map.remove(key);
            if (map != this.currentMap && map.size() < 300) {
                this.consolidateMap(map);
            }
        }
        if (recurse && value != null) {
            Iterator iter = value.eContents().iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof EObject)) continue;
                this.remove((EObject)obj, recurse);
            }
        }
    }

    public void remove(ObjectID[] keys, boolean recurse) {
        for (int i2 = 0; i2 != keys.length; ++i2) {
            this.remove(keys[i2], recurse);
        }
    }

    public int size() {
        int size = 0;
        Iterator iter = this.mapOfMaps.iterator();
        while (iter.hasNext()) {
            Map next = (Map)iter.next();
            size += next.size();
        }
        return size;
    }

    public EObject[] values() {
        ArrayList values = new ArrayList(this.size());
        Iterator iter = this.mapOfMaps.iterator();
        while (iter.hasNext()) {
            Map next = (Map)iter.next();
            values.addAll(next.values());
        }
        return values.toArray(new EObject[values.size()]);
    }

    protected Object getCacheKey(EObject value) {
        ArgCheck.isNotNull(value);
        return value.getObjectId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consolidateMap(Map map) {
        if (map == this.currentMap) {
            return;
        }
        try {
            int size = map.size();
            if (this.currentMap.size() + size < 1500) {
                this.currentMap.putAll(map);
                this.mapOfMaps.remove(map);
                return;
            }
            Iterator iter = this.mapOfMaps.iterator();
            while (iter.hasNext()) {
                Map next = (Map)iter.next();
                if (next == this.currentMap || next.size() + size >= 1500) continue;
                next.putAll(map);
                this.mapOfMaps.remove(map);
                return;
            }
        }
        finally {
            this.runGC();
        }
    }

    protected Map findMapForValue(EObject eObject) {
        ObjectID id = eObject.getObjectId();
        return this.findMapForKey(id);
    }

    protected Map findMapForKey(Object id) {
        if (id == null) {
            return null;
        }
        if (this.currentMap.containsKey(id)) {
            return this.currentMap;
        }
        Iterator maps = this.mapOfMaps.iterator();
        while (maps.hasNext()) {
            Map next = (Map)maps.next();
            if (next == this.currentMap || !next.containsKey(id)) continue;
            return next;
        }
        return null;
    }

    protected Collection getMapOfMaps() {
        return this.mapOfMaps;
    }

    protected Map createMap() {
        return new HashMap();
    }

    protected void runGC() {
    }
}

