/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.resource;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.resource.EObjectHrefConverter;
import com.metamatrix.modeler.core.util.ModelObjectCollector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;

public class BuiltInTypesHrefConverter
implements EObjectHrefConverter {
    protected static final String URI_REFERENCE_DELIMITER = "#";
    protected static final String SCHEMA_FOR_SCHEMA_URI_2001_SUFFIX = "www.w3.org/2001/XMLSchema.xsd";
    protected static final String SCHEMA_INSTANCE_URI_2001_SUFFIX = "www.w3.org/2001/XMLSchema-instance.xsd";
    protected static final String MAGIC_SCHEMA_URI_2001_SUFFIX = "www.w3.org/2001/MagicXMLSchema.xsd";
    protected static final URI SCHEMA_FOR_SCHEMA_URI = URI.createURI("http://www.w3.org/2001/XMLSchema");
    protected static final URI SCHEMA_INSTANCE_URI = URI.createURI("http://www.w3.org/2001/XMLSchema-instance");
    protected static final URI XML_MAGIC_SCHEMA_URI = URI.createURI("http://www.w3.org/2001/MagicXMLSchema");
    protected static final URI XML_SCHEMA_URI = URI.createURI("http://www.w3.org/2001/xml.xsd");
    protected static final URI BUILTIN_DATATYPES_URI = URI.createURI("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
    private static final boolean DEBUG = false;
    private Map logicalUriMap = null;
    private Map physicalUriMap = null;
    private ResourceSet eResourceSet = null;

    public BuiltInTypesHrefConverter(ResourceSet theResourceSet) {
        ArgCheck.isNotNull(theResourceSet);
        this.eResourceSet = theResourceSet;
        this.logicalUriMap = new HashMap();
        this.physicalUriMap = new HashMap();
        this.doInit();
    }

    public URI getLogicalURI(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        URI physicalURI = this.createPhysicalURI(eObject);
        return (URI)this.logicalUriMap.get(physicalURI);
    }

    public URI getLogicalURI(URI physicalURI) {
        ArgCheck.isNotNull(physicalURI);
        return (URI)this.logicalUriMap.get(physicalURI);
    }

    public URI getPhysicalURI(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        URI logicalURI = this.createLogicalURI(eObject);
        return (URI)this.physicalUriMap.get(logicalURI);
    }

    public URI getPhysicalURI(URI logicalURI) {
        ArgCheck.isNotNull(logicalURI);
        return (URI)this.physicalUriMap.get(logicalURI);
    }

    protected synchronized void doInit() {
        String msg;
        XSDSchema schema;
        XSDResourceImpl xsdResource = this.getBuiltInTypesResource(BUILTIN_DATATYPES_URI);
        if (xsdResource != null) {
            schema = xsdResource.getSchema();
            Assertion.isNotNull(schema);
            this.addMappings(this.getXsdComponents(schema));
        } else {
            msg = ModelerCore.Util.getString("BuiltInTypesHrefConverter.BuiltInTypes_resource_not_loaded", BUILTIN_DATATYPES_URI);
            ModelerCore.Util.log(msg);
        }
        xsdResource = this.getBuiltInTypesResource(SCHEMA_FOR_SCHEMA_URI);
        if (xsdResource != null) {
            schema = xsdResource.getSchema();
            Assertion.isNotNull(schema);
            this.addMappings(this.getXsdComponents(schema));
        } else {
            msg = ModelerCore.Util.getString("BuiltInTypesHrefConverter.BuiltInTypes_resource_not_loaded", SCHEMA_FOR_SCHEMA_URI);
            ModelerCore.Util.log(msg);
        }
        xsdResource = this.getBuiltInTypesResource(SCHEMA_INSTANCE_URI);
        if (xsdResource != null) {
            schema = xsdResource.getSchema();
            Assertion.isNotNull(schema);
            this.addMappings(this.getXsdComponents(schema));
        } else {
            msg = ModelerCore.Util.getString("BuiltInTypesHrefConverter.BuiltInTypes_resource_not_loaded", SCHEMA_INSTANCE_URI);
            ModelerCore.Util.log(msg);
        }
        xsdResource = this.getBuiltInTypesResource(XML_SCHEMA_URI);
        if (xsdResource != null) {
            schema = xsdResource.getSchema();
            Assertion.isNotNull(schema);
            this.addMappings(this.getXsdComponents(schema));
        } else {
            msg = ModelerCore.Util.getString("BuiltInTypesHrefConverter.BuiltInTypes_resource_not_loaded", XML_SCHEMA_URI);
            ModelerCore.Util.log(msg);
        }
        xsdResource = this.getBuiltInTypesResource(XML_MAGIC_SCHEMA_URI);
        if (xsdResource != null) {
            schema = xsdResource.getSchema();
            Assertion.isNotNull(schema);
            this.addMappings(this.getXsdComponents(schema));
        } else {
            msg = ModelerCore.Util.getString("BuiltInTypesHrefConverter.BuiltInTypes_resource_not_loaded", XML_MAGIC_SCHEMA_URI);
            ModelerCore.Util.log(msg);
        }
    }

    protected XSDResourceImpl getBuiltInTypesResource(URI logicalUri) {
        ArgCheck.isNotNull(logicalUri);
        XSDResourceImpl r2 = (XSDResourceImpl)this.eResourceSet.getResource(logicalUri, false);
        if (r2 != null && !r2.isLoaded()) {
            try {
                r2.load(this.eResourceSet.getLoadOptions());
            }
            catch (Throwable e2) {
                ModelerCore.Util.log(e2);
            }
        }
        return r2;
    }

    protected void addMappings(XSDComponent[] components) {
        ArgCheck.isNotNull(components);
        for (int i2 = 0; i2 != components.length; ++i2) {
            URI logicalURI = this.createLogicalURI(components[i2]);
            URI physicalURI = this.createPhysicalURI(components[i2]);
            this.physicalUriMap.put(logicalURI, physicalURI);
            this.logicalUriMap.put(physicalURI, logicalURI);
        }
    }

    protected XSDComponent[] getXsdComponents(XSDSchema schema) {
        ArgCheck.isNotNull(schema);
        Assertion.isNotNull(schema.eResource());
        ModelObjectCollector moc = new ModelObjectCollector(schema.eResource());
        List result = moc.getEObjects();
        Iterator i2 = result.iterator();
        while (i2.hasNext()) {
            EObject eObject = (EObject)i2.next();
            if (eObject instanceof XSDComponent) continue;
            i2.remove();
        }
        return result.toArray(new XSDComponent[result.size()]);
    }

    protected URI createLogicalURI(EObject eObject) {
        URI logicalURI = null;
        if (eObject instanceof XSDSimpleTypeDefinition) {
            logicalURI = URI.createURI(((XSDSimpleTypeDefinition)eObject).getURI());
        } else {
            URI uri = EcoreUtil.getURI(eObject);
            String uriString = uri.trimFragment().toString();
            if (uriString.endsWith(MAGIC_SCHEMA_URI_2001_SUFFIX)) {
                logicalURI = XML_MAGIC_SCHEMA_URI.appendFragment(uri.fragment());
            } else if (uriString.endsWith(SCHEMA_FOR_SCHEMA_URI_2001_SUFFIX)) {
                logicalURI = SCHEMA_FOR_SCHEMA_URI.appendFragment(uri.fragment());
            } else if (uriString.endsWith(SCHEMA_INSTANCE_URI_2001_SUFFIX)) {
                logicalURI = SCHEMA_INSTANCE_URI.appendFragment(uri.fragment());
            }
        }
        return logicalURI;
    }

    protected URI createPhysicalURI(EObject eObject) {
        return EcoreUtil.getURI(eObject);
    }
}

