/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.reader;

import com.metamatrix.core.util.DateUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.reader.StreamReader;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class XmiStreamReader
implements StreamReader {
    public Collection read(InputStream inputStream, Map options) throws IOException {
        if (inputStream == null) {
            String msg = ModelerCore.Util.getString("XmiStreamReader.The_InputStream_reference_may_not_be_null_1");
            throw new IllegalArgumentException(msg);
        }
        if (options == null) {
            String msg = ModelerCore.Util.getString("XmiStreamReader.The_Map_reference_may_not_be_null_2");
            throw new IllegalArgumentException(msg);
        }
        ArrayList result = Collections.EMPTY_LIST;
        try {
            String tmpCntrName = DateUtil.getCurrentDateAsString() + "TempContainer";
            Container container = ModelerCore.createContainer(tmpCntrName);
            Resource temp = container.createResource(URI.createURI("XmiStreamReader.xmi"));
            temp.load(inputStream, options);
            result = new ArrayList(temp.getContents());
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                EcoreUtil.remove(eObject);
            }
            container.getResources().remove(temp);
            temp = null;
            ModelerCore.getRegistry().unregister(tmpCntrName);
            container = null;
        }
        catch (Exception e2) {
            ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("XmiStreamReader.Error_loading_resource_into_a_temporary_container_1"));
            throw new IOException(e2.getMessage());
        }
        return result;
    }

    public Collection read(InputStream inputStream, Map options, Resource resource) throws IOException {
        throw new UnsupportedOperationException(ModelerCore.Util.getString("XmiStreamReader.Can_not_perform_operation_6"));
    }

    public Collection read(InputStream inputStream, Map options, EObject parent) throws IOException {
        throw new UnsupportedOperationException(ModelerCore.Util.getString("XmiStreamReader.Can_not_perform_operation_7"));
    }

    class DelegatedResourceSet
    extends ResourceSetImpl {
        private MetamodelRegistry registry;

        public DelegatedResourceSet(MetamodelRegistry registry) {
            if (registry == null) {
                String msg = ModelerCore.Util.getString("XmiStreamReader.The_Map_reference_may_not_be_null_2");
                throw new IllegalArgumentException(msg);
            }
            this.registry = registry;
        }

        protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
            if (this.registry != null && this.registry.containsURI(uri)) {
                Resource resource = this.registry.getResourceSet().getResource(uri, loadOnDemand);
                return resource;
            }
            return super.delegatedGetResource(uri, loadOnDemand);
        }
    }
}

