/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.metamodel;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.MetamodelAspect;
import com.metamatrix.modeler.core.metamodel.aspect.MetamodelEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

public class MetamodelEntityImpl
implements MetamodelEntity {
    private final URI metamodelURI;
    private final EClass eClass;
    private Map aspectMap;
    private List referencedClasses;
    private List containedClasses;
    private List attributes;
    private List uniReferences;

    public MetamodelEntityImpl(URI metamodelURI, EClass eClass) {
        if (metamodelURI == null) {
            String msg = ModelerCore.Util.getString("MetamodelEntityImpl.The_metamodel_URI_reference_may_not_be_null_1");
            throw new IllegalArgumentException(msg);
        }
        if (eClass == null) {
            String msg = ModelerCore.Util.getString("MetamodelEntityImpl.The_EObject_reference_may_not_be_null_1");
            throw new IllegalArgumentException(msg);
        }
        this.metamodelURI = metamodelURI;
        this.eClass = eClass;
    }

    public String getDisplayName() {
        return null;
    }

    public String getPluralDisplayName() {
        return null;
    }

    public String getIconPath() {
        return null;
    }

    public String getTooltip() {
        return null;
    }

    public MetamodelAspect getMetamodelAspect(String id) {
        if (this.aspectMap == null) {
            return null;
        }
        return (MetamodelAspect)this.aspectMap.get(id);
    }

    public Collection getMetamodelAspects() {
        if (this.aspectMap == null) {
            return Collections.EMPTY_LIST;
        }
        return this.aspectMap.values();
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public List getAttributes() {
        EClass metamodelClass = this.getEClass();
        if (this.attributes == null) {
            EList attribs = metamodelClass.getEAllAttributes();
            this.attributes = new ArrayList(attribs.size());
        }
        return this.attributes;
    }

    public List getContainedClasses() {
        EClass metamodelClass = this.getEClass();
        if (this.containedClasses == null) {
            EList refs = metamodelClass.getEAllContainments();
            this.containedClasses = new ArrayList(refs.size());
            Iterator iter = refs.iterator();
            while (iter.hasNext()) {
                EReference eRef = (EReference)iter.next();
                if (!(eRef.getEType() instanceof EClass)) continue;
                this.containedClasses.add(eRef.getEType());
            }
        }
        return this.containedClasses;
    }

    public List getReferencedClasses() {
        EClass metamodelClass = this.getEClass();
        if (this.referencedClasses == null) {
            EList refs = metamodelClass.getEAllReferences();
            this.referencedClasses = new ArrayList(refs.size());
            Iterator iter = refs.iterator();
            while (iter.hasNext()) {
                EReference eRef = (EReference)iter.next();
                if (eRef.isContainment() || !(eRef.getEType() instanceof EClass)) continue;
                this.referencedClasses.add(eRef.getEType());
            }
        }
        return this.referencedClasses;
    }

    public List getUniDirectionalReferences() {
        EClass metamodelClass = this.getEClass();
        if (this.uniReferences == null) {
            EList refs = metamodelClass.getEAllReferences();
            this.uniReferences = new ArrayList();
            Iterator iter = refs.iterator();
            while (iter.hasNext()) {
                EReference eRef = (EReference)iter.next();
                if (eRef.isContainment() || eRef.getEOpposite() != null) continue;
                this.uniReferences.add(eRef);
            }
        }
        return this.uniReferences;
    }

    public URI getMetamodelURI() {
        return this.metamodelURI;
    }

    public void addMetamodelAspect(String id, MetamodelAspect aspect) {
        if (this.aspectMap == null) {
            this.aspectMap = new HashMap();
        }
        this.aspectMap.put(id, aspect);
    }
}

