/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.metadata.runtime;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.metadata.runtime.FileRecord;
import com.metamatrix.modeler.internal.core.metadata.runtime.AbstractMetadataRecord;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileRecordImpl
extends AbstractMetadataRecord
implements FileRecord {
    private String pathInVdb;
    private String[] tokens;
    private String[] tokenReplacements;
    private IndexSelector selector;

    public String getPathInVdb() {
        return this.pathInVdb;
    }

    public boolean getBinary() {
        return this.pathInVdb != null && this.pathInVdb.endsWith("INDEX");
    }

    public InputStream getContent() {
        if (this.tokens != null) {
            return this.selector.getFileContent(this.getPathInVdb(), this.tokens, this.tokenReplacements);
        }
        return this.selector.getFileContent(this.getPathInVdb());
    }

    public long getFileLength() {
        return this.selector.getFileSize(this.getPathInVdb());
    }

    public void setPathInVdb(String pathInVdb) {
        this.pathInVdb = pathInVdb;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public String[] getTokenReplacements() {
        return this.tokenReplacements;
    }

    public void setTokens(String[] tokens) {
        this.tokens = tokens;
    }

    public void setTokenReplacements(String[] tokenReplacements) {
        this.tokenReplacements = tokenReplacements;
    }

    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }

    public FileRecord getFileRecord() {
        return this;
    }

    public String getModelName() {
        if (this.isModelFile()) {
            IPath path = new Path(this.pathInVdb);
            path = path.removeFileExtension();
            return path.lastSegment();
        }
        return null;
    }

    public boolean isIndexFile() {
        return this.pathInVdb != null && this.pathInVdb.endsWith("INDEX");
    }

    public boolean isModelFile() {
        if (this.pathInVdb != null) {
            File fileInVdb = this.selector.getFile(this.pathInVdb);
            return ModelUtil.isModelFile(fileInVdb);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FileRecord other = (FileRecord)obj;
        if (!EquivalenceUtil.areEqual(this.getPathInVdb(), other.getPathInVdb())) {
            return false;
        }
        if (!EquivalenceUtil.areEqual(this.getTokens(), other.getTokens())) {
            return false;
        }
        return EquivalenceUtil.areEqual(this.getTokenReplacements(), other.getTokenReplacements());
    }

    public int hashCode() {
        int myHash = 0;
        if (this.pathInVdb != null) {
            myHash = HashCodeUtil.hashCode(myHash, this.pathInVdb);
        }
        if (this.tokens != null) {
            myHash = HashCodeUtil.hashCode(myHash, this.tokens);
        }
        if (this.tokenReplacements != null) {
            myHash = HashCodeUtil.hashCode(myHash, this.tokenReplacements);
        }
        return myHash;
    }

    public String toString() {
        return this.getPathInVdb();
    }
}

