/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.metadata.runtime;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.UUID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractMetadataRecord
implements MetadataRecord {
    private static final int DEFAULT_INDEX_VERSION = 0;
    private String uuid;
    private String parentUUID;
    private String nameInSource;
    private String fullName;
    private String name;
    private String pathString;
    private String modelName;
    private String resourcePath;
    private int indexVersion = 0;
    private char recordType;
    private transient Map propValues;
    private boolean uuidSet;
    private boolean parentUUIDSet;
    private boolean nameInSourceSet;
    private boolean fullNameSet;
    private boolean nameSet;
    protected EObject eObject;
    protected SqlAspect sqlAspect;
    private Container container;

    public AbstractMetadataRecord() {
    }

    public AbstractMetadataRecord(SqlAspect sqlAspect, EObject eObject) {
        ArgCheck.isNotNull(sqlAspect);
        if (eObject == null) {
            String msg = ModelerCore.Util.getString("AbstractMetadataRecord.The_model_object_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        this.eObject = eObject;
        this.sqlAspect = sqlAspect;
    }

    public String getUUID() {
        if (this.eObject != null && !this.uuidSet) {
            this.setUUID(this.getObjectID(this.eObject));
        }
        return this.uuid;
    }

    public String getParentUUID() {
        Object parentID;
        if (this.eObject != null && !this.parentUUIDSet && (parentID = this.sqlAspect.getParentObjectID(this.eObject)) != null) {
            this.setParentUUID(parentID.toString());
        }
        return this.parentUUID;
    }

    public String getNameInSource() {
        if (this.eObject != null && !this.nameInSourceSet) {
            this.setNameInSource(this.sqlAspect.getNameInSource(this.eObject));
        }
        return this.nameInSource;
    }

    public String getModelName() {
        if (this.modelName == null) {
            int prntIdx;
            int n2 = prntIdx = this.getFullName() != null ? this.getFullName().indexOf(46) : -1;
            this.modelName = prntIdx <= 0 ? this.getFullName() : (this.getFullName() != null ? this.getFullName().substring(0, prntIdx) : null);
        }
        return this.modelName;
    }

    public String getFullName() {
        if (this.eObject != null && !this.fullNameSet) {
            this.setFullName(this.sqlAspect.getFullName(this.eObject));
        }
        return this.fullName == null ? this.name : this.fullName;
    }

    public String getName() {
        if (this.eObject != null && !this.nameSet) {
            this.setName(this.sqlAspect.getName(this.eObject));
        }
        if (this.name == null || this.name.trim().length() == 0) {
            int nmIdx;
            int n2 = nmIdx = this.fullName != null ? this.fullName.lastIndexOf(46) : -1;
            this.name = nmIdx == -1 ? this.fullName : (this.fullName != null ? this.fullName.substring(nmIdx + 1) : null);
        }
        return this.name;
    }

    public String getPathString() {
        if (this.pathString == null) {
            this.pathString = this.getFullName() != null ? this.getFullName().replace('.', '/') : null;
        }
        return this.pathString;
    }

    public IPath getPath() {
        return this.getPathString() != null ? new Path(this.getPathString()) : null;
    }

    public String getParentFullName() {
        int prntIdx;
        int n2 = prntIdx = this.getFullName() != null ? this.getFullName().lastIndexOf('.' + this.getName()) : -1;
        if (prntIdx <= 0) {
            return "";
        }
        return this.getFullName().substring(0, prntIdx);
    }

    public String getParentPathString() {
        String parentFullName = this.getParentFullName();
        return parentFullName != null ? parentFullName.replace('.', '/') : null;
    }

    public IPath getParentPath() {
        return this.getParentPathString() != null ? new Path(this.getParentPathString()) : null;
    }

    public char getRecordType() {
        return this.recordType;
    }

    public void setNameInSource(String string) {
        this.nameInSource = string;
        this.nameInSourceSet = true;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
        this.fullNameSet = true;
    }

    public void setName(String name) {
        this.name = name;
        this.nameSet = true;
    }

    public void setUUID(String string) {
        this.uuid = string;
        this.uuidSet = true;
    }

    public void setParentUUID(String string) {
        this.parentUUID = string;
        this.parentUUIDSet = true;
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public void setIndexVersion(int version) {
        this.indexVersion = version;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public EObject getEObject() {
        if (this.eObject != null) {
            return this.eObject;
        }
        Assertion.isNotNull(this.container);
        try {
            String uuid = this.getUUID();
            int delimitIndex = uuid.indexOf(58);
            ObjectID objID = UUID.stringToObject(uuid.substring(delimitIndex + 1));
            return (EObject)this.container.getEObjectFinder().find(objID);
        }
        catch (Exception e2) {
            ModelerCore.Util.log(e2);
            return null;
        }
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String path) {
        this.resourcePath = path;
    }

    public void setRecordType(char c2) {
        this.recordType = c2;
    }

    public Object getPropertyValue(String propertyName) {
        ArgCheck.isNotNull(propertyName);
        if (this.propValues != null) {
            return this.propValues.get(propertyName);
        }
        return null;
    }

    public void setPropertyValue(String propertyName, Object propertyVame) {
        if (propertyName != null && propertyVame != null) {
            if (this.propValues == null) {
                this.propValues = new HashMap();
            }
            this.propValues.put(propertyName, propertyVame);
        }
    }

    public String toString() {
        return this.getFullName();
    }

    protected SqlAspect getSqlAspect() {
        return this.sqlAspect;
    }

    protected String getObjectID(Object object) {
        ObjectID objectID;
        if (object != null && object instanceof EObject && (objectID = (ObjectID)this.sqlAspect.getObjectID((EObject)object)) != null) {
            return ((Object)objectID).toString();
        }
        return null;
    }

    protected List getObjectIDs(Collection eObjs) {
        if (eObjs == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> objIds = new ArrayList<String>(eObjs.size());
        Iterator eIter = eObjs.iterator();
        while (eIter.hasNext()) {
            EObject eObj = (EObject)eIter.next();
            objIds.add(this.getObjectID(eObj));
        }
        return objIds;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractMetadataRecord other = (AbstractMetadataRecord)obj;
        if (this.getRecordType() != other.getRecordType()) {
            return false;
        }
        if (!EquivalenceUtil.areEqual(this.getUUID(), other.getUUID())) {
            return false;
        }
        if (!EquivalenceUtil.areEqual(this.getParentUUID(), other.getParentUUID())) {
            return false;
        }
        if (!EquivalenceUtil.areEqual(this.getFullName(), other.getFullName())) {
            return false;
        }
        return EquivalenceUtil.areEqual(this.getNameInSource(), other.getNameInSource());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.recordType);
        if (this.fullName != null) {
            myHash = HashCodeUtil.hashCode(myHash, this.fullName);
        }
        if (this.uuid != null) {
            myHash = HashCodeUtil.hashCode(myHash, this.uuid);
        }
        if (this.parentUUID != null) {
            myHash = HashCodeUtil.hashCode(myHash, this.parentUUID);
        }
        if (this.nameInSource != null) {
            myHash = HashCodeUtil.hashCode(myHash, this.nameInSource);
        }
        return myHash;
    }
}

