/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.internal.core.index.AbstractIndexSelector;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceFileIndexSelector
extends AbstractIndexSelector {
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static final Index[] EMPTY_INDEX_ARRAY = new Index[0];
    private static final Resource[] EMPTY_RESOURCE_ARRAY = new Resource[0];
    protected static final String TEMP_DIR = FileUtils.TEMP_DIRECTORY + "\\indexes";
    protected final File selectedFile;
    protected Index[] indexes;
    protected String indexDirectoryPath;

    public ResourceFileIndexSelector(String filepath) throws ModelerCoreException {
        if (filepath == null) {
            ArgCheck.isNotNull(filepath, ModelerCore.Util.getString("ResourceFileIndexSelector.The_filepath_string_may_not_be_null_1"));
        }
        this.selectedFile = new File(filepath);
        if (!this.selectedFile.exists()) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("ResourceFileIndexSelector.The_specified_file_does_not_exist._2", filepath));
        }
        if (FileUtils.isArchiveFileName(filepath)) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("ResourceFileIndexSelector.Building_indexes_from_resource_found_in_archive_._3", filepath));
        } else if (this.selectedFile.isDirectory()) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("ResourceFileIndexSelector.Building_indexes_from_resource_found_under_folder_._4", filepath));
        } else if (this.selectedFile.isFile()) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("ResourceFileIndexSelector.Building_indexes_from_resource_at_._5", filepath));
        } else {
            throw new ModelerCoreException(ModelerCore.Util.getString("ResourceFileIndexSelector.The_specified_file_cannot_be_processed_by_the_ResourceFileIndexSelector_6", filepath));
        }
    }

    public Index[] getIndexes() throws IOException {
        if (this.indexes == null || this.indexes.length == 0) {
            this.indexes = this.buildIndexes(this.selectedFile);
        }
        return this.indexes;
    }

    protected Index[] buildIndexes(File f2) throws IOException {
        File[] modelFiles = this.loadModelFiles(f2);
        Resource[] models = EMPTY_RESOURCE_ARRAY;
        try {
            models = this.loadResources(modelFiles);
        }
        catch (Throwable e2) {
            ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ResourceFileIndexSelector.Error_loading_resources_for_7", f2));
        }
        Index[] newIndexes = EMPTY_INDEX_ARRAY;
        try {
            newIndexes = this.indexResources(models);
        }
        catch (Throwable e3) {
            ModelerCore.Util.log(4, e3, ModelerCore.Util.getString("ResourceFileIndexSelector.Error_building_indexes_for_resources_in_8", f2));
        }
        return newIndexes;
    }

    protected Index[] indexResources(Resource[] models) throws CoreException, IOException {
        ObjectVector tmp = new ObjectVector();
        File indexDirectory = new File(this.getIndexDirectoryPath());
        for (int i2 = 0; i2 < models.length; ++i2) {
            EmfResource resource = (EmfResource)models[i2];
            if (resource == null) continue;
            String indexFileName = resource.getURI().lastSegment();
            String extension = resource.getURI().fileExtension();
            if (extension != null) {
                int endIndex = indexFileName.indexOf(extension) - 1;
                indexFileName = indexFileName.substring(0, endIndex);
            }
            indexFileName = indexFileName + "." + "INDEX";
            File indexFilePath = new File(indexDirectory.getAbsolutePath() + File.separator + indexFileName);
            if (indexFilePath.exists()) {
                indexFilePath.delete();
            }
            String resourcePath = resource.getURI().toFileString();
            IndexUtil.indexResource(resource, resourcePath, this.getIndexDirectoryPath(), indexFileName);
            File indexFile = new File(indexDirectory, indexFileName);
            if (!this.isIndexFile(indexFile)) continue;
            tmp.add(new Index(indexFile.getAbsolutePath(), true));
        }
        Object[] result = new Index[tmp.size()];
        tmp.copyInto(result);
        return result;
    }

    protected Resource[] loadResources(File[] modelFiles) throws CoreException {
        ObjectVector tmp = new ObjectVector();
        String tempContainerName = DateUtil.getCurrentDateAsString() + "_Container";
        Container container = this.createContainer(tempContainerName);
        for (int i2 = 0; i2 < modelFiles.length; ++i2) {
            File modelFile = modelFiles[i2];
            Resource resource = this.loadResource(container, modelFile);
            if (resource == null || !(resource instanceof EmfResource)) continue;
            tmp.add(resource);
        }
        Object[] result = new Resource[tmp.size()];
        tmp.copyInto(result);
        return result;
    }

    protected Resource loadResource(Container container, File modelFile) throws CoreException {
        URI uri = URI.createFileURI(modelFile.getAbsolutePath());
        Resource resource = container.getResource(uri, true);
        return resource;
    }

    protected Container createContainer(String name) throws CoreException {
        return ModelerCore.createContainer(name);
    }

    protected File[] loadModelFiles(File f2) throws IOException {
        File[] modelFiles = EMPTY_FILE_ARRAY;
        modelFiles = FileUtils.isArchiveFileName(f2.getName()) ? this.loadModelsFromZip(f2) : (f2.isDirectory() ? this.loadModelsFromFolder(f2) : this.loadModelsFromFile(f2));
        return modelFiles;
    }

    protected File[] loadModelsFromFile(File file) throws IOException {
        File[] result = EMPTY_FILE_ARRAY;
        if (ModelUtil.isModelFile(file)) {
            result = new File[]{file};
        }
        return result;
    }

    protected File[] loadModelsFromFolder(File folder) throws IOException {
        ObjectVector tmp = new ObjectVector();
        File[] files = folder.listFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (!ModelUtil.isModelFile(files[i2])) continue;
            tmp.add(files[i2]);
        }
        Object[] result = new File[tmp.size()];
        tmp.copyInto(result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File[] loadModelsFromZip(File zip) throws IOException {
        Object[] objectArray;
        ZipFile zipFile = null;
        try {
            ZipEntry entry;
            zipFile = new ZipFile(zip);
            ObjectVector tmp = new ObjectVector();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements() && (entry = entries.nextElement()) != null) {
                byte[] buffer;
                Path zipEntryPath = new Path(entry.getName());
                String entryName = zipEntryPath.lastSegment();
                InputStream inputStream = zipFile.getInputStream(entry);
                int length = (int)entry.getSize();
                if (length >= 0) {
                    int n2;
                    buffer = new byte[length];
                    int offset = 0;
                    do {
                        n2 = inputStream.read(buffer, offset, length);
                        offset += n2;
                    } while ((length -= n2) > 0);
                } else {
                    int n3;
                    buffer = new byte[1024];
                    while ((n3 = inputStream.read(buffer, 0, 1024)) >= 0) {
                    }
                }
                File indexDirectory = new File(this.getIndexDirectoryPath());
                if (!indexDirectory.exists()) {
                    indexDirectory.mkdir();
                }
                File entryFile = new File(indexDirectory.getAbsolutePath() + File.separator + entryName);
                entryFile.createNewFile();
                entryFile.deleteOnExit();
                FileOutputStream outputStream = new FileOutputStream(entryFile);
                outputStream.write(buffer);
                outputStream.flush();
                outputStream.close();
                if (!ModelUtil.isModelFile(entryFile)) continue;
                tmp.add(entryFile);
            }
            Object[] result = new File[tmp.size()];
            tmp.copyInto(result);
            objectArray = result;
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            try {
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return objectArray;
        }
        if (zipFile == null) return objectArray;
        zipFile.close();
        return objectArray;
    }

    protected boolean isIndexFile(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        return fileName.endsWith("INDEX");
    }

    protected boolean isIndexFile(File file) {
        if (file != null && file.isFile() && file.exists()) {
            return this.isIndexFile(file.getName());
        }
        return false;
    }

    protected String getIndexDirectoryPath() {
        if (this.indexDirectoryPath == null) {
            this.indexDirectoryPath = TEMP_DIR;
        }
        return this.indexDirectoryPath;
    }

    protected void setIndexDirectoryPath(String path) {
        this.indexDirectoryPath = path;
    }
}

