/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.StringUtilities;
import com.metamatrix.internal.core.index.BlocksIndexInput;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.internal.core.index.IndexInput;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class IndexViewer {
    private static final char[] FORMAT_CHARS = new char[]{'\n', '\r', '\t'};

    public static byte[] getByteContent(File file) throws IOException {
        Assertion.isNotNull(file);
        Assertion.assertTrue(IndexUtil.isIndexFile(file));
        Assertion.assertTrue(IndexUtil.indexFileExists(file.getAbsolutePath()));
        String content = IndexViewer.getStringContent(file);
        return content != null ? content.getBytes() : new byte[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringContent(File file) throws IOException {
        Assertion.isNotNull(file);
        Assertion.assertTrue(IndexUtil.isIndexFile(file));
        Assertion.assertTrue(IndexUtil.indexFileExists(file.getAbsolutePath()));
        BlocksIndexInput input = null;
        try {
            input = new BlocksIndexInput(file);
            ((IndexInput)input).open();
            StringBuffer buffer = new StringBuffer();
            while (input.hasMoreWords()) {
                String word = String.valueOf(input.getCurrentWordEntry().getWord());
                buffer.append(StringUtilities.removeChars(word, FORMAT_CHARS));
                buffer.append(StringUtil.LINE_SEPARATOR);
                ((IndexInput)input).moveToNextWordEntry();
            }
            String string = buffer.toString();
            return string;
        }
        catch (Throwable t2) {
            String string = StringUtil.getStackTrace(t2);
            return string;
        }
        finally {
            if (input != null) {
                ((IndexInput)input).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getWords(String filePath) throws IOException {
        Assertion.isNotNull(filePath);
        Assertion.assertTrue(IndexUtil.isIndexFile(filePath));
        Assertion.assertTrue(IndexUtil.indexFileExists(filePath));
        IndexInput input = null;
        try {
            input = new BlocksIndexInput(new File(filePath));
            input.open();
            ArrayList<char[]> words = new ArrayList<char[]>();
            while (input.hasMoreWords()) {
                words.add(input.getCurrentWordEntry().getWord());
                input.moveToNextWordEntry();
            }
            ArrayList<char[]> arrayList = words;
            return arrayList;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getWords(File file) throws IOException {
        Assertion.isNotNull(file);
        Assertion.assertTrue(IndexUtil.isIndexFile(file));
        Assertion.assertTrue(IndexUtil.indexFileExists(file.getAbsolutePath()));
        BlocksIndexInput input = null;
        try {
            input = new BlocksIndexInput(file);
            ((IndexInput)input).open();
            ArrayList<char[]> words = new ArrayList<char[]>();
            while (input.hasMoreWords()) {
                words.add(input.getCurrentWordEntry().getWord());
                ((IndexInput)input).moveToNextWordEntry();
            }
            ArrayList<char[]> arrayList = words;
            return arrayList;
        }
        finally {
            if (input != null) {
                ((IndexInput)input).close();
            }
        }
    }

    public static void clearIndexFileContents(String filePath) throws IOException {
        Index index = new Index(filePath, true);
        index.empty();
    }

    public static String getStringContent(Index index) throws IOException {
        Assertion.isNotNull(index);
        Assertion.isNotNull(index.getIndexFile());
        Assertion.assertTrue(IndexUtil.isIndexFile(index.getIndexFile()));
        Assertion.assertTrue(IndexUtil.indexFileExists(index.getIndexFile().getAbsolutePath()));
        return IndexViewer.getStringContent(index.getIndexFile());
    }
}

