/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.index.IIndex;
import com.metamatrix.core.index.IIndexer;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.CharOperation;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.index.BlocksIndexInput;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.index.IndexConstants;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.internal.core.index.ModelDocumentImpl;
import com.metamatrix.modeler.internal.core.index.ModelIndexer;
import com.metamatrix.modeler.internal.core.index.ModelSearchIndexer;
import com.metamatrix.modeler.internal.core.metadata.runtime.RuntimeAdapter;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;

public class IndexUtil {
    public static final boolean CASE_SENSITIVE_INDEX_FILE_NAMES = false;
    private static final CRC32 CHECK_SUM_CALCULATOR = new CRC32();
    public static String INDEX_PATH;

    public static void indexResource(IResource resource, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        ModelWorkspace workspace = ModelerCore.getModelWorkspace();
        ModelResource mResource = workspace.findModelResource(resource);
        ModelIndexer indexer = new ModelIndexer();
        IndexUtil.indexResource(indexer, mResource, INDEX_PATH, reuseExistingFile, addResource);
    }

    public static IIndex indexResource(Resource resource, String resourcePath, String indexDirectoryPath, String indexFileName) throws ModelerCoreException {
        if (resource == null) {
            Assertion.isNotNull(resource, ModelerCore.Util.getString("IndexUtil.The_Resource_reference_may_not_be_null_1"));
        }
        try {
            ModelIndexer indexer = new ModelIndexer();
            String indexFilePath = IndexUtil.getIndexFilePath(indexDirectoryPath, indexFileName);
            Index runtimeIndex = new Index(indexFilePath, false);
            ModelDocumentImpl document = new ModelDocumentImpl(resource);
            runtimeIndex.add(document, indexer);
            runtimeIndex.save();
            return runtimeIndex;
        }
        catch (Exception e2) {
            Status status = new Status(4, "com.metamatrix.modeler.core", 0, ModelerCore.Util.getString("ModelBuilder.IO_Error_trying_to_index_an_EmfResource_2"), e2);
            throw new ModelerCoreException(status);
        }
    }

    public static void indexResource(EmfResource emfresource, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        ModelIndexer indexer = new ModelIndexer();
        ModelResource mResource = ModelWorkspaceManager.getModelWorkspaceManager().findModelResource(emfresource);
        IndexUtil.indexResource(indexer, mResource, INDEX_PATH, reuseExistingFile, addResource);
    }

    public static void indexResource(ModelResource mResource, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        ModelIndexer indexer = new ModelIndexer();
        IndexUtil.indexResource(indexer, mResource, INDEX_PATH, reuseExistingFile, addResource);
    }

    public static void indexResource(IIndexer indexer, ModelResource mResource, String indexPath, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        if (mResource == null) {
            Assertion.isNotNull(mResource, ModelerCore.Util.getString("IndexUtil.The_Resource_reference_may_not_be_null_1"));
        }
        try {
            String indexFileName = IndexUtil.getRuntimeIndexFileName(mResource);
            String indexFilePath = IndexUtil.getIndexFilePath(indexPath, indexFileName);
            Index runtimeIndex = new Index(indexFilePath, reuseExistingFile);
            IResource resource = mResource.getResource();
            String resourcePath = ((Object)resource.getFullPath()).toString();
            resourcePath = resourcePath.replace('/', File.separatorChar);
            if (ModelerCore.DEBUG || ModelerCore.DEBUG_PROJECT_BUILDER) {
                Object[] params = new Object[]{indexFileName, resourcePath};
                String msg = ModelerCore.Util.getString("IndexUtil.DEBUG.Creating_index_file_0_for_resource_1_1", params);
                ModelerCore.Util.log(1, msg);
            }
            ModelDocumentImpl document = new ModelDocumentImpl(resource, mResource.getEmfResource());
            if (addResource) {
                runtimeIndex.add(document, indexer);
            } else {
                runtimeIndex.remove(document.getName());
            }
            runtimeIndex.save();
            if (mResource != null) {
                if (indexer instanceof ModelIndexer) {
                    mResource.setIndexType(3);
                }
                if (indexer instanceof ModelSearchIndexer && mResource.getIndexType() == 0) {
                    mResource.setIndexType(2);
                }
            }
        }
        catch (Exception e2) {
            Status status = new Status(4, "com.metamatrix.modeler.core", 0, ModelerCore.Util.getString("ModelBuilder.IO_Error_trying_to_index_an_EmfResource_2"), e2);
            throw new ModelerCoreException(status);
        }
    }

    public static String getIndexFilePath(String indexDirectoryPath, String indexFileName) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(indexDirectoryPath);
        if (!indexDirectoryPath.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append(indexFileName);
        return sb.toString();
    }

    public static IEntryResult[] queryIndex(Index[] indexes, char[] pattern, char fieldDelimiter) throws ModelerCoreException {
        boolean isCaseSensitive = false;
        ObjectVector queryResult = new ObjectVector();
        try {
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                Object[] partialResults = indexes[i2].queryEntriesMatching(pattern, false);
                if (partialResults != null) {
                    partialResults = IndexUtil.addContinuationRecords(indexes[i2], (IEntryResult[])partialResults);
                }
                if (partialResults == null) continue;
                queryResult.addAll(partialResults);
            }
        }
        catch (IOException e2) {
            throw new ModelerCoreException((Throwable)e2, ModelerCore.Util.getString("IndexUtil.Error_trying_to_query_index_files_for_pattern_1", new String(pattern)));
        }
        ArrayList<IEntryResult> resultsToRemove = new ArrayList<IEntryResult>(queryResult.size());
        int n2 = queryResult.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            IEntryResult record = (IEntryResult)queryResult.elementAt(i3);
            if (record != null && IndexUtil.entryMatches(record.getWord(), pattern, fieldDelimiter)) continue;
            resultsToRemove.add(record);
        }
        Iterator iter = resultsToRemove.iterator();
        while (iter.hasNext()) {
            IEntryResult record = (IEntryResult)iter.next();
            queryResult.remove(record);
        }
        Object[] result = new IEntryResult[queryResult.size()];
        queryResult.copyInto(result);
        return result;
    }

    protected static boolean entryMatches(char[] record, char[] pattern, char fieldDelimiter) {
        boolean isCaseSensitive = false;
        if (record == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        String delimiter = new Character(fieldDelimiter).toString();
        List recordTokens = StringUtil.split(new String(record), delimiter);
        List patternTokens = StringUtil.split(new String(pattern), delimiter);
        if (patternTokens.size() > recordTokens.size()) {
            return false;
        }
        int n2 = patternTokens.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            char[] recordToken;
            char[] patternToken = ((String)patternTokens.get(i2)).toCharArray();
            if (CharOperation.match(patternToken, recordToken = ((String)recordTokens.get(i2)).toCharArray(), false)) continue;
            return false;
        }
        return true;
    }

    public static IEntryResult[] queryIndex(Index[] indexes, char[] pattern, boolean isPrefix, boolean returnFirstMatch) throws ModelerCoreException {
        return IndexUtil.queryIndex(null, indexes, pattern, isPrefix, true, returnFirstMatch);
    }

    public static IEntryResult[] queryIndex(IProgressMonitor monitor, Index[] indexes, char[] pattern, boolean isPrefix, boolean returnFirstMatch) throws ModelerCoreException {
        return IndexUtil.queryIndex(monitor, indexes, pattern, isPrefix, true, returnFirstMatch);
    }

    public static IEntryResult[] queryIndex(IProgressMonitor monitor, Index[] indexes, char[] pattern, boolean isPrefix, boolean isCaseSensitive, boolean returnFirstMatch) throws ModelerCoreException {
        ObjectVector queryResult = new ObjectVector();
        if (monitor != null) {
            monitor.beginTask(null, indexes.length);
        }
        try {
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                if (monitor != null) {
                    monitor.worked(1);
                }
                IEntryResult[] partialResults = null;
                partialResults = isPrefix ? indexes[i2].queryEntries(pattern, isCaseSensitive) : indexes[i2].queryEntriesMatching(pattern, isCaseSensitive);
                if (partialResults != null) {
                    partialResults = IndexUtil.addContinuationRecords(indexes[i2], partialResults);
                }
                if (partialResults != null) {
                    for (int j2 = 0; j2 < partialResults.length; ++j2) {
                        IEntryResult result = partialResults[j2];
                        if (result == null || result.getWord()[0] == '&') continue;
                        queryResult.add(partialResults[j2]);
                    }
                }
                if (!returnFirstMatch || queryResult.size() <= 0) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e2) {
            Object[] params = new Object[]{new String(pattern)};
            throw new ModelerCoreException((Throwable)e2, ModelerCore.Util.getString("IndexUtil.Error_trying_to_query_index_files_for_pattern_1", params));
        }
        Object[] result = new IEntryResult[queryResult.size()];
        queryResult.copyInto(result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IEntryResult[] queryIndex(IProgressMonitor monitor, Index[] indexes, Collection patterns, boolean isPrefix, boolean isCaseSensitive, boolean returnFirstMatch) throws ModelerCoreException {
        ObjectVector queryResult = new ObjectVector();
        if (monitor != null) {
            monitor.beginTask(null, indexes.length);
        }
        BlocksIndexInput input = null;
        try {
            try {
                block7: for (int i2 = 0; i2 < indexes.length; ++i2) {
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    input = new BlocksIndexInput(indexes[i2].getIndexFile());
                    IEntryResult[] partialResults = null;
                    Iterator patternIter = patterns.iterator();
                    while (patternIter.hasNext()) {
                        char[] pattern = ((String)patternIter.next()).toCharArray();
                        partialResults = isPrefix ? input.queryEntriesPrefixedBy(pattern, isCaseSensitive) : input.queryEntriesMatching(pattern, isCaseSensitive);
                        if (partialResults != null) {
                            partialResults = IndexUtil.addContinuationRecords(indexes[i2], partialResults);
                        }
                        if (partialResults != null) {
                            for (int j2 = 0; j2 < partialResults.length; ++j2) {
                                char[] recordWord;
                                IEntryResult record = partialResults[j2];
                                if (record == null || (recordWord = partialResults[j2].getWord())[0] == '&') continue;
                                if (!isPrefix) {
                                    if (!IndexUtil.entryMatches(recordWord, pattern, '\u00a0')) continue;
                                    queryResult.add(partialResults[j2]);
                                    continue;
                                }
                                queryResult.add(partialResults[j2]);
                            }
                        }
                        if (returnFirstMatch && queryResult.size() > 0) continue block7;
                        if (input == null) continue;
                        input.close();
                    }
                }
                Object var16_18 = null;
            }
            catch (IOException e2) {
                Object[] params = new Object[]{patterns};
                throw new ModelerCoreException((Throwable)e2, ModelerCore.Util.getString("IndexUtil.Error_trying_to_query_index_files_for_pattern_1", params));
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            try {
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            catch (IOException io) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException io) {}
        if (input != null) {
            input.close();
        }
        Object[] result = new IEntryResult[queryResult.size()];
        queryResult.copyInto(result);
        return result;
    }

    private static IEntryResult[] addContinuationRecords(Index index, IEntryResult[] partialResults) throws IOException {
        int blockSize = 8160;
        IEntryResult[] results = partialResults;
        for (int i2 = 0; i2 < results.length; ++i2) {
            IEntryResult partialResult = results[i2];
            char[] word = partialResult.getWord();
            if (word.length < 8160 || word[8159] != '&') continue;
            String objectID = RuntimeAdapter.extractUUIDString(partialResult);
            String patternStr = "&" + word[0] + '\u00a0' + objectID + '\u00a0';
            IEntryResult[] continuationResults = index.queryEntries(patternStr.toCharArray(), true);
            if (continuationResults == null || continuationResults.length <= 0) continue;
            results[i2] = RuntimeAdapter.joinEntryResults(partialResult, continuationResults, 8160);
        }
        return results;
    }

    public static String getRuntimeIndexFileName(ModelResource model) {
        ArgCheck.isNotNull(model);
        return IndexUtil.getRuntimeIndexFileName(model.getResource());
    }

    public static String getRuntimeIndexFileName(Resource model) {
        ArgCheck.isNotNull(model);
        ModelResource mResource = ModelWorkspaceManager.getModelWorkspaceManager().findModelResource(model);
        return IndexUtil.getRuntimeIndexFileName(mResource);
    }

    public static String getRuntimeIndexFileName(IResource resource) {
        ArgCheck.isNotNull(resource);
        String resourcePath = ((Object)resource.getFullPath()).toString();
        return IndexUtil.getRuntimeIndexFileName(resourcePath);
    }

    public static String getRuntimeIndexFileName(String fullPath) {
        ArgCheck.isNotNull(fullPath);
        return IndexUtil.getIndexFileName(fullPath, "INDEX");
    }

    public static String getSearchIndexFileName(ModelResource model) {
        ArgCheck.isNotNull(model);
        return IndexUtil.getSearchIndexFileName(model.getResource());
    }

    public static String getSearchIndexFileName(Resource model) {
        ArgCheck.isNotNull(model);
        ModelResource mResource = ModelWorkspaceManager.getModelWorkspaceManager().findModelResource(model);
        return IndexUtil.getSearchIndexFileName(mResource);
    }

    public static String getSearchIndexFileName(IResource resource) {
        ArgCheck.isNotNull(resource);
        String resourcePath = ((Object)resource.getFullPath()).toString();
        return IndexUtil.getSearchIndexFileName(resourcePath);
    }

    public static String getSearchIndexFileName(String fullPath) {
        ArgCheck.isNotNull(fullPath);
        return IndexUtil.getIndexFileName(fullPath, "SEARCH_INDEX");
    }

    public static String getIndexFileName(String fullPath, String extension) {
        ArgCheck.isNotNull(fullPath);
        ArgCheck.isNotNull(extension);
        String pathForName = fullPath;
        pathForName = pathForName.toUpperCase();
        CHECK_SUM_CALCULATOR.reset();
        CHECK_SUM_CALCULATOR.update(pathForName.getBytes());
        String indexFileName = CHECK_SUM_CALCULATOR.getValue() + "." + extension;
        return indexFileName;
    }

    public static boolean indexFileExists(String indexFilePath) {
        if (indexFilePath == null) {
            return false;
        }
        String filePath = indexFilePath.replace('/', File.separatorChar);
        File indexFile = new File(filePath);
        return IndexUtil.indexFileExists(indexFile);
    }

    public static boolean indexFileExists(File indexFile) {
        if (indexFile.exists() && indexFile.length() > 0L) {
            return IndexUtil.isIndexFile(indexFile.getName());
        }
        return false;
    }

    public static boolean isModelIndex(String indexFileName) {
        if (!IndexUtil.isIndexFile(indexFileName)) {
            return false;
        }
        return !IndexConstants.INDEX_NAME.isKnownIndex(indexFileName);
    }

    public static boolean isIndexFile(String indexFileName) {
        Path path;
        String extension;
        return !StringUtil.isEmpty(indexFileName) && ((extension = (path = new Path(indexFileName)).getFileExtension()).equals("INDEX") || extension.equals("SEARCH_INDEX"));
    }

    public static boolean isIndexFile(File indexFile) {
        if (indexFile != null && indexFile.isFile()) {
            return IndexUtil.isIndexFile(indexFile.getName());
        }
        return false;
    }

    public static Index[] getIndexes(String indexName, IndexSelector selector) throws ModelerCoreException {
        ArgCheck.isNotEmpty(indexName);
        try {
            Index[] indexes = selector.getIndexes();
            ArrayList<Index> tmp = new ArrayList<Index>(indexes.length);
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                String indexFileName;
                Index coreIndex = indexes[i2];
                if (coreIndex == null || !indexName.equals(indexFileName = indexes[i2].getIndexFile().getName())) continue;
                tmp.add(coreIndex);
            }
            return tmp.toArray(new Index[tmp.size()]);
        }
        catch (IOException e2) {
            throw new ModelerCoreException((Throwable)e2, ModelerCore.Util.getString("IndexUtil.Error_trying_to_obtain_indexs_for_index_file.", indexName));
        }
    }

    public static String getIndexFileNameForRecordType(char recordType) throws ModelerCoreException {
        switch (recordType) {
            case 'G': {
                return "COLUMNS.INDEX";
            }
            case 'B': {
                return "TABLES.INDEX";
            }
            case 'A': {
                return "MODELS.INDEX";
            }
            case 'C': 
            case 'E': 
            case 'F': {
                return "PROCEDURES.INDEX";
            }
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': {
                return "KEYS.INDEX";
            }
            case 'P': {
                return "SELECT_TRANSFORM.INDEX";
            }
            case 'Q': {
                return "INSERT_TRANSFORM.INDEX";
            }
            case 'R': {
                return "UPDATE_TRANSFORM.INDEX";
            }
            case 'S': {
                return "DELETE_TRANSFORM.INDEX";
            }
            case 'T': {
                return "PROC_TRANSFORM.INDEX";
            }
            case 'U': {
                return "MAPPING_TRANSFORM.INDEX";
            }
            case 'M': {
                return "DATATYPES.INDEX";
            }
            case 'V': {
                return "VDBS.INDEX";
            }
            case 'W': {
                return "ANNOTATION.INDEX";
            }
            case 'X': {
                return "PROPERTIES.INDEX";
            }
            case 'Z': {
                return "FILES.INDEX";
            }
        }
        throw new ModelerCoreException(ModelerCore.Util.getString("IndexUtil.No_known_index_file_type_associated_with_the_rcordType_1", new Character(recordType)));
    }

    /*
     * WARNING - void declaration
     */
    public static String getRecordTypeForIndexFileName(String indexName) {
        void var1_1;
        int recordType;
        if (indexName.equalsIgnoreCase("COLUMNS.INDEX")) {
            recordType = 71;
        } else if (indexName.equalsIgnoreCase("TABLES.INDEX")) {
            recordType = 66;
        } else if (indexName.equalsIgnoreCase("MODELS.INDEX")) {
            recordType = 65;
        } else if (indexName.equalsIgnoreCase("DATATYPES.INDEX")) {
            recordType = 77;
        } else if (indexName.equalsIgnoreCase("VDBS.INDEX")) {
            recordType = 86;
        } else if (indexName.equalsIgnoreCase("ANNOTATION.INDEX")) {
            recordType = 87;
        } else if (indexName.equalsIgnoreCase("PROPERTIES.INDEX")) {
            recordType = 88;
        } else if (indexName.equalsIgnoreCase("SELECT_TRANSFORM.INDEX")) {
            recordType = 80;
        } else if (indexName.equalsIgnoreCase("INSERT_TRANSFORM.INDEX")) {
            recordType = 81;
        } else if (indexName.equalsIgnoreCase("UPDATE_TRANSFORM.INDEX")) {
            recordType = 82;
        } else if (indexName.equalsIgnoreCase("DELETE_TRANSFORM.INDEX")) {
            recordType = 83;
        } else if (indexName.equalsIgnoreCase("PROC_TRANSFORM.INDEX")) {
            recordType = 84;
        } else if (indexName.equalsIgnoreCase("MAPPING_TRANSFORM.INDEX")) {
            recordType = 85;
        } else if (indexName.equalsIgnoreCase("FILES.INDEX")) {
            recordType = 90;
        } else {
            return null;
        }
        return "" + (char)var1_1;
    }

    public static String getPrefixPattern(char recordType, String uuid) {
        String patternStr = "" + recordType + '\u00a0';
        if (uuid != null && !uuid.equals("")) {
            patternStr = patternStr + uuid.trim() + '\u00a0';
        }
        return patternStr;
    }

    public static boolean deleteIndexFiles(File[] theFiles, boolean theContinueOnErrorFlag) {
        boolean result = true;
        int i2 = theFiles.length;
        while (--i2 >= 0) {
            boolean temp;
            File file = theFiles[i2];
            if (!IndexUtil.isIndexFile(file) || (temp = file.delete())) continue;
            result = false;
            if (theContinueOnErrorFlag) continue;
            break;
        }
        return result;
    }

    static {
        try {
            Plugin plugin = ModelerCore.getPlugin();
            INDEX_PATH = plugin != null ? ((Object)plugin.getStateLocation().addTrailingSeparator()).toString() : System.getProperty("user.dir") + "\\indexes";
        }
        catch (Throwable t2) {
            INDEX_PATH = System.getProperty("user.dir") + "\\indexes";
        }
    }
}

