/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.container;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.ResourceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ResourceDescriptorImpl
implements ResourceDescriptor {
    private ClassLoader factoryClassLoader;
    private String factoryClassName;
    private final String uniqueID;
    private final List protocols;
    private final List extensions;

    public ResourceDescriptorImpl(String uniqueID) {
        Assertion.isNotNull(uniqueID);
        Assertion.isNotZeroLength(uniqueID);
        this.uniqueID = uniqueID;
        this.protocols = new ArrayList();
        this.extensions = new ArrayList();
        this.factoryClassLoader = this.getClass().getClassLoader();
    }

    protected ClassLoader getClassLoader() {
        return this.factoryClassLoader;
    }

    public String getUniqueIdentifier() {
        return this.uniqueID;
    }

    public List getExtensions() {
        return this.extensions;
    }

    public List getProtocols() {
        return this.protocols;
    }

    public Resource.Factory getResourceFactory() throws ModelerCoreException {
        try {
            Class<?> factoryClass = this.factoryClassLoader.loadClass(this.factoryClassName);
            return (Resource.Factory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e2) {
            Object[] params = new Object[]{this.factoryClassName, this.factoryClassLoader};
            throw new ModelerCoreException((Throwable)e2, ModelerCore.Util.getString("ResourceDescriptorImpl.Unable_to_load_class_using_classLoader", params));
        }
        catch (InstantiationException e3) {
            Object[] params = new Object[]{this.factoryClassName, this.factoryClassLoader};
            throw new ModelerCoreException((Throwable)e3, ModelerCore.Util.getString("ResourceDescriptorImpl.Unable_to_instantiate_class_using_classLoader", params));
        }
        catch (IllegalAccessException e4) {
            Object[] params = new Object[]{this.factoryClassName, this.factoryClassLoader};
            throw new ModelerCoreException((Throwable)e4, ModelerCore.Util.getString("ResourceDescriptorImpl.Unable_to_instantiate_and_access_class_using_classLoader", params));
        }
    }

    public void setResourceFactoryClass(String className) {
        this.setResourceFactoryClass(className, null);
    }

    public void setResourceFactoryClass(String className, ClassLoader classLoader) {
        if (className == null) {
            ArgCheck.isNotNull(className, ModelerCore.Util.getString("ResourceDescriptorImpl.The_class_name_string_may_not_be_null"));
        }
        if (classLoader != null) {
            this.factoryClassLoader = classLoader;
        }
        this.factoryClassName = className;
    }

    protected String getResourceFactoryClassName() {
        return this.factoryClassName;
    }

    public static void register(ResourceDescriptor resourceDescriptor, ResourceSet resourceSet) throws ModelerCoreException {
        List protocols = resourceDescriptor.getProtocols();
        List fileExtensions = resourceDescriptor.getExtensions();
        String factoryExtensionID = resourceDescriptor.getUniqueIdentifier();
        if (protocols.size() != 0 || fileExtensions.size() != 0) {
            try {
                Resource.Factory factory = resourceDescriptor.getResourceFactory();
                String factoryClassName = factory.getClass().getName();
                Resource.Factory.Registry registry = resourceSet.getResourceFactoryRegistry();
                Map extensionToFactoryMap = registry.getExtensionToFactoryMap();
                Map protocolToFactoryMap = registry.getProtocolToFactoryMap();
                Iterator iter = protocols.iterator();
                while (iter.hasNext()) {
                    Resource.Factory prevFactory;
                    String protocol = (String)iter.next();
                    if (ModelerCore.DEBUG) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("ResourceDescriptorImpl.DEBUG.Registering_resource_factory_for_URI_protocol", factoryClassName, protocol));
                    }
                    if ((prevFactory = protocolToFactoryMap.put(protocol, factory)) == null || prevFactory.getClass() == factory.getClass()) continue;
                    ModelerCore.Util.log(2, ModelerCore.Util.getString("ResourceDescriptorImpl.Replaced_resource_factory_for_URI_protocol", prevFactory.getClass().getName(), factoryClassName, protocol));
                }
                Iterator iter2 = fileExtensions.iterator();
                while (iter2.hasNext()) {
                    Resource.Factory prevFactory;
                    String fileExtension = (String)iter2.next();
                    if (ModelerCore.DEBUG) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("ResourceDescriptorImpl.DEBUG.Registering_resource_factory_for_URI_extension", factoryClassName, fileExtension));
                    }
                    if ((prevFactory = extensionToFactoryMap.put(fileExtension, factory)) == null || prevFactory.getClass() == factory.getClass()) continue;
                    ModelerCore.Util.log(2, ModelerCore.Util.getString("ResourceDescriptorImpl.Replaced_resource_factory_for_URI_extension", prevFactory.getClass().getName(), factoryClassName, fileExtension));
                }
            }
            catch (CoreException e2) {
                String msg = ModelerCore.Util.getString("ResourceDescriptorImpl.Error_while_loading_resource_factory_extension", factoryExtensionID);
                throw new ModelerCoreException(msg);
            }
        }
    }

    public boolean equals(Object obj) {
        ResourceDescriptorImpl that = (ResourceDescriptorImpl)obj;
        if (!this.uniqueID.equals(that.uniqueID)) {
            return false;
        }
        if (!this.factoryClassName.equals(that.factoryClassName)) {
            return false;
        }
        if (!this.protocols.containsAll(that.protocols) || !that.protocols.containsAll(this.protocols)) {
            return false;
        }
        if (!this.extensions.containsAll(that.extensions) || !that.extensions.containsAll(this.extensions)) {
            return false;
        }
        return this.factoryClassLoader.equals(that.factoryClassLoader);
    }

    public int hashCode() {
        return this.uniqueID.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ResourceDescriptor ");
        sb.append(this.uniqueID);
        sb.append(" protocols=[");
        boolean first = true;
        Iterator iter = this.protocols.iterator();
        while (iter.hasNext()) {
            if (!first) {
                sb.append(',');
            }
            sb.append(iter.next());
            first = false;
        }
        sb.append("], extensions=[");
        first = true;
        iter = this.extensions.iterator();
        while (iter.hasNext()) {
            if (!first) {
                sb.append(',');
            }
            sb.append(iter.next());
            first = false;
        }
        sb.append(']');
        return sb.toString();
    }
}

