/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.container;

import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.transformation.MappingClassSetContainer;
import com.metamatrix.metamodels.transformation.TransformationContainer;
import com.metamatrix.metamodels.transformation.TransformationPackage;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.IPasteContributor;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.ModelEditorImpl;
import com.metamatrix.modeler.internal.core.container.ContainerEditingDomain;
import com.metamatrix.modeler.internal.core.container.PasteFromClipboardWithMappingCommand;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class PasteWithRelatedFromClipboardCommand
extends CompoundCommand {
    protected static final String LABEL = ModelerCore.Util.getString("PasteWithRelatedFromClipboardCommand.Label");
    protected static final String DESCRIPTION = ModelerCore.Util.getString("PasteWithRelatedFromClipboardCommand.Description");
    private static final String PASTE_CONTRIBUTOR_EXT_PT = "pasteContributor";
    private static final String NAME_ATTR = "name";
    protected EditingDomain domain;
    protected Object owner;
    protected Object feature;
    protected int index;
    protected boolean optimize;
    protected PasteFromClipboardWithMappingCommand pasteCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$PasteFromClipboardCommand;

    public static Command create(EditingDomain domain, Object owner, Object feature) {
        return PasteWithRelatedFromClipboardCommand.create(domain, owner, feature, -1);
    }

    public static Command create(EditingDomain domain, Object owner, Object feature, int index) {
        if (domain == null) {
            return new PasteWithRelatedFromClipboardCommand(domain, owner, feature, index, true);
        }
        Command command = domain.createCommand(class$org$eclipse$emf$edit$command$PasteFromClipboardCommand == null ? (class$org$eclipse$emf$edit$command$PasteFromClipboardCommand = PasteWithRelatedFromClipboardCommand.class$("org.eclipse.emf.edit.command.PasteFromClipboardCommand")) : class$org$eclipse$emf$edit$command$PasteFromClipboardCommand, new CommandParameter(owner, feature, Collections.EMPTY_LIST, index));
        return command;
    }

    public PasteWithRelatedFromClipboardCommand(EditingDomain domain, Object owner, Object feature, int index) {
        this(domain, owner, feature, index, true);
    }

    public PasteWithRelatedFromClipboardCommand(EditingDomain domain, Object owner, Object feature, int index, boolean optimize) {
        super(Integer.MAX_VALUE, LABEL, DESCRIPTION);
        this.domain = domain;
        this.owner = owner;
        this.feature = feature;
        this.index = index;
        this.optimize = optimize;
        this.pasteCommand = new PasteFromClipboardWithMappingCommand(this.domain, this.owner, this.feature, this.index);
        this.append(this.pasteCommand);
    }

    public void execute() {
        ContainerEditingDomain ctnrDomain;
        super.execute();
        ModelContents clipboardModelContents = null;
        if (this.domain instanceof ContainerEditingDomain && (clipboardModelContents = (ctnrDomain = (ContainerEditingDomain)this.domain).getClipboardModelContents(false)) != null) {
            Resource targetResource = null;
            if (this.owner instanceof Resource) {
                targetResource = (Resource)this.owner;
            } else if (this.owner instanceof EObject) {
                targetResource = ((EObject)this.owner).eResource();
            } else if (this.owner instanceof ModelResource) {
                try {
                    targetResource = ((ModelResource)this.owner).getEmfResource();
                }
                catch (ModelWorkspaceException e1) {
                    ModelerCore.Util.log(e1);
                }
            }
            if (targetResource != null && targetResource instanceof EmfResource) {
                IConfigurationElement[] elems;
                ModelContents targetContents = ((EmfResource)targetResource).getModelContents();
                this.doCreateAdditionalCommands(clipboardModelContents, targetContents);
                Map map = ctnrDomain.getClipboardContentsOriginalToCopyMapping();
                if (map != null && (elems = Platform.getExtensionRegistry().getConfigurationElementsFor("com.metamatrix.modeler.core", PASTE_CONTRIBUTOR_EXT_PT)) != null) {
                    map = ctnrDomain.getClipboardContentsCopyToOriginalMapping();
                    CopyCommand.Helper helper = this.pasteCommand.getHelper();
                    HashMap origPastedMap = new HashMap(map.size());
                    Iterator iter = helper.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        origPastedMap.put(map.get(entry.getKey()), entry.getValue());
                    }
                    int ndx = elems.length;
                    while (--ndx >= 0) {
                        try {
                            Object obj = elems[ndx].createExecutableExtension(NAME_ATTR);
                            if (!(obj instanceof IPasteContributor)) continue;
                            targetContents.getAnnotationContainer(true);
                            String uri = targetContents.getModelAnnotation().getPrimaryMetamodelUri();
                            ((IPasteContributor)obj).contribute(origPastedMap, uri);
                        }
                        catch (CoreException err) {
                            ModelerCore.Util.log(err);
                        }
                    }
                }
            }
        }
    }

    protected void doCreateAdditionalCommands(ModelContents clipboardModelContents, ModelContents targetContents) {
        AnnotationContainer clipboardAnnContainer = clipboardModelContents.getAnnotationContainer(false);
        if (clipboardAnnContainer != null && clipboardAnnContainer.getAnnotations().size() != 0) {
            AnnotationContainer container = targetContents.getAnnotationContainer(true);
            EReference feature = CorePackage.eINSTANCE.getAnnotationContainer_Annotations();
            this.copyAndAdd(clipboardAnnContainer.getAnnotations(), container, feature);
        }
        if (targetContents.getModelAnnotation().getModelType() == ModelType.VIRTUAL_LITERAL) {
            TransformationContainer clipboardTransContainer;
            MappingClassSetContainer clipboardMCSetContainer = clipboardModelContents.getMappingClassSetContainer(false);
            if (clipboardMCSetContainer != null && clipboardMCSetContainer.getMappingClassSets().size() != 0) {
                MappingClassSetContainer container = targetContents.getMappingClassSetContainer(true);
                EReference feature = TransformationPackage.eINSTANCE.getMappingClassSetContainer_MappingClassSets();
                this.copyAndAdd(clipboardMCSetContainer.getMappingClassSets(), container, feature);
            }
            if ((clipboardTransContainer = clipboardModelContents.getTransformationContainer(false)) != null && clipboardTransContainer.getTransformationMappings().size() != 0) {
                TransformationContainer container = targetContents.getTransformationContainer(true);
                EReference feature = TransformationPackage.eINSTANCE.getTransformationContainer_TransformationMappings();
                this.copyAndAdd(clipboardTransContainer.getTransformationMappings(), container, feature);
            }
        }
    }

    protected void copyAndAdd(Collection additionalObjects, EObject container, EStructuralFeature feature) {
        Collection copiedAnnotations;
        Command addCommand;
        boolean added;
        CopyCommand.Helper helper = this.pasteCommand.getHelper();
        Command copyCommand = ModelEditorImpl.createCopyCommand(this.domain, additionalObjects, helper);
        boolean copied = this.appendAndExecute(copyCommand);
        if (copied && !(added = this.appendAndExecute(addCommand = AddCommand.create(this.domain, (Object)container, (Object)feature, copiedAnnotations = copyCommand.getResult())))) {
            URI uri = EcoreUtil.getURI(container);
            Object[] params = new Object[]{new Integer(copiedAnnotations.size()), feature.getName(), uri != null ? uri.trimFragment().toString() : "<unknown>"};
            String msg = ModelerCore.Util.getString("PasteWithRelatedFromClipboardCommand.Failed_to_paste_{0}_{1}_from_clipboard_to_{2}", params);
            ModelerCore.Util.log(msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

