/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.container;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.ObjectManager;
import com.metamatrix.modeler.core.transaction.SourcedNotification;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.xsd.util.XSDResourceImpl;

public class ObjectManagerImpl
implements ObjectManager {
    private static final int MAX_MAP_SIZE = 1500;
    private static final int MAP_CONSOLIDATION_SIZE = 300;
    private final LinkedList objectIDToEObjectMaps;
    private HashMap currentMap;
    private final ContainerImpl container;
    private ObjectChangeListner listner;

    public ObjectManagerImpl(ContainerImpl container) {
        ArgCheck.isNotNull(container);
        this.objectIDToEObjectMaps = new LinkedList();
        this.currentMap = new HashMap();
        this.objectIDToEObjectMaps.add(this.currentMap);
        this.container = container;
    }

    public void clear() {
        Iterator maps = this.objectIDToEObjectMaps.iterator();
        while (maps.hasNext()) {
            HashMap next = (HashMap)maps.next();
            if (next == null) continue;
            next.clear();
        }
        this.objectIDToEObjectMaps.clear();
        this.currentMap = new HashMap();
        this.objectIDToEObjectMaps.add(this.currentMap);
    }

    public int size() {
        int size = 0;
        Iterator maps = this.objectIDToEObjectMaps.iterator();
        while (maps.hasNext()) {
            HashMap next = (HashMap)maps.next();
            if (next == null) continue;
            size += next.size();
        }
        return size;
    }

    public EObject findEObject(Object key) {
        HashMap map;
        if (key != null && key instanceof ObjectID && (map = this.findMapForObjectID(key)) != null) {
            EObject eObject = (EObject)map.get(key);
            if (eObject != null && eObject.eIsProxy()) {
                this.removeEObject(eObject);
                eObject = this.resolve(eObject);
                if (eObject != null) {
                    this.addEObject(eObject);
                }
            }
            return eObject;
        }
        return null;
    }

    public void addEObject(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        ObjectID id = eObject.getObjectId();
        HashMap eObjMap = this.findMapForObjectID(id);
        if (eObjMap != null) {
            eObjMap.remove(id);
        }
        if (this.currentMap.size() < 1500) {
            this.currentMap.put(id, eObject);
        } else {
            boolean newMap = true;
            Iterator maps = this.objectIDToEObjectMaps.iterator();
            while (maps.hasNext()) {
                HashMap next = (HashMap)maps.next();
                if (next == this.currentMap || next.size() >= 1500) continue;
                this.currentMap = next;
                this.currentMap.put(id, eObject);
                newMap = false;
                break;
            }
            if (newMap) {
                this.currentMap = new HashMap();
                this.objectIDToEObjectMaps.add(this.currentMap);
                this.currentMap.put(id, eObject);
            }
        }
        Iterator children = eObject.eContents().iterator();
        while (children.hasNext()) {
            Object next = children.next();
            if (!(next instanceof EObject)) continue;
            this.addEObject((EObject)next);
        }
    }

    public void removeEObject(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        ObjectID id = eObject.getObjectId();
        HashMap map = this.findMapForEObject(eObject);
        if (map != null) {
            map.remove(id);
            if (map != this.currentMap && map.size() < 300) {
                this.consolidateMap(map);
            }
        }
        Iterator children = eObject.eContents().iterator();
        while (children.hasNext()) {
            Object next = children.next();
            if (!(next instanceof EObject)) continue;
            this.removeEObject((EObject)next);
        }
    }

    public void processResourceChange(Object eObject, Resource newResource, Resource oldResource) {
        EObject eObj;
        if (eObject instanceof EObject && !(eObj = (EObject)eObject).eIsProxy() && oldResource != newResource) {
            if (newResource == null) {
                this.removeEObject(eObj);
            } else if (oldResource == null) {
                this.addEObject(eObj);
            }
        }
    }

    public void processMassAdd(Collection newObjects) {
        Iterator objIter = newObjects.iterator();
        while (objIter.hasNext()) {
            Object nextObj = objIter.next();
            if (!(nextObj instanceof EObject)) continue;
            EObject eObj = (EObject)nextObj;
            this.processResourceChange(eObj, eObj.eResource(), null);
        }
    }

    public void processMassRemove(Collection objects) {
        Iterator roots = objects.iterator();
        while (roots.hasNext()) {
            Object next = roots.next();
            if (!(next instanceof EObject)) continue;
            this.removeEObject((EObject)next);
        }
    }

    private EObject resolve(EObject proxy) {
        if (proxy != null && proxy.eIsProxy()) {
            ResourceSet resourceSet = this.container.getResourceSet();
            URI proxyURI = ((InternalEObject)proxy).eProxyURI();
            return resourceSet.getEObject(proxyURI, true);
        }
        return null;
    }

    private void consolidateMap(HashMap map) {
        if (map == this.currentMap) {
            return;
        }
        int size = map.size();
        if (this.currentMap.size() + size < 1500) {
            this.currentMap.putAll(map);
            this.objectIDToEObjectMaps.remove(map);
            return;
        }
        Iterator maps = this.objectIDToEObjectMaps.iterator();
        while (maps.hasNext()) {
            HashMap next = (HashMap)maps.next();
            if (next == this.currentMap || next.size() + size >= 1500) continue;
            next.putAll(map);
            this.objectIDToEObjectMaps.remove(map);
            return;
        }
    }

    private HashMap findMapForEObject(EObject eObject) {
        ObjectID id = eObject.getObjectId();
        return this.findMapForObjectID(id);
    }

    private HashMap findMapForObjectID(Object id) {
        if (id == null) {
            return null;
        }
        if (this.currentMap.containsKey(id)) {
            return this.currentMap;
        }
        Iterator maps = this.objectIDToEObjectMaps.iterator();
        while (maps.hasNext()) {
            HashMap next = (HashMap)maps.next();
            if (next == this.currentMap || !next.containsKey(id)) continue;
            return next;
        }
        return null;
    }

    public INotifyChangedListener getObjectChangeListner() {
        if (this.listner == null) {
            this.listner = new ObjectChangeListner();
        }
        return this.listner;
    }

    private boolean isContainment(Object feature) {
        boolean isContainment = false;
        if (feature instanceof EReference) {
            EReference ref = (EReference)feature;
            isContainment = ref.isContainment();
        }
        return isContainment;
    }

    Container testGetContainer() {
        return this.container;
    }

    Map testGetCurrentMap() {
        return this.currentMap;
    }

    int testGetMapConsolidationSize() {
        return 300;
    }

    Collection testGetMaps() {
        return this.objectIDToEObjectMaps;
    }

    int testGetMaxMapSize() {
        return 1500;
    }

    private class ObjectChangeListner
    implements INotifyChangedListener {
        private ObjectChangeListner() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.isTouch()) {
                return;
            }
            if (notification instanceof SourcedNotification) {
                Collection chain = ((SourcedNotification)notification).getNotifications();
                Iterator iter = chain.iterator();
                while (iter.hasNext()) {
                    Notification n2 = (Notification)iter.next();
                    this.manageObjects(n2);
                }
            } else {
                this.manageObjects(notification);
            }
        }

        private void manageObjects(Notification notification) {
            int eventType = notification.getEventType();
            Object feature = notification.getFeature();
            Object oldVal = notification.getOldValue();
            Object newVal = notification.getNewValue();
            if (ObjectManagerImpl.this.isContainment(feature) || this.isXSDRootNotification(notification)) {
                switch (eventType) {
                    case 4: {
                        if (!(oldVal instanceof EObject)) break;
                        ObjectManagerImpl.this.removeEObject((EObject)oldVal);
                        break;
                    }
                    case 6: {
                        if (!(oldVal instanceof Collection)) break;
                        ObjectManagerImpl.this.processMassRemove((Collection)oldVal);
                        break;
                    }
                    case 3: {
                        if (!(newVal instanceof EObject)) break;
                        ObjectManagerImpl.this.addEObject((EObject)newVal);
                        break;
                    }
                    case 5: {
                        if (!(newVal instanceof Collection)) break;
                        ObjectManagerImpl.this.processMassAdd((Collection)newVal);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (newVal == null && oldVal != null && oldVal instanceof EObject) {
                            ObjectManagerImpl.this.removeEObject((EObject)oldVal);
                            break;
                        }
                        if (newVal == null || oldVal != null || !(newVal instanceof EObject)) break;
                        ObjectManagerImpl.this.addEObject((EObject)newVal);
                        break;
                    }
                }
            }
        }

        private boolean isXSDRootNotification(Notification notification) {
            Object feature = notification.getFeature();
            Object oldVal = notification.getOldValue();
            Object newVal = notification.getNewValue();
            if (feature == null && notification.getNotifier() instanceof XSDResourceImpl) {
                EObject eoj = null;
                if (newVal instanceof EObject) {
                    eoj = (EObject)newVal;
                } else if (oldVal instanceof EObject) {
                    eoj = (EObject)oldVal;
                }
                if (eoj != null && eoj.eResource() instanceof XSDResourceImpl) {
                    return true;
                }
            }
            return false;
        }
    }
}

