/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.container;

import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.transformation.MappingClassSet;
import com.metamatrix.metamodels.transformation.TransformationFactory;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TransformationPackage;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.internal.core.ModelEditorImpl;
import com.metamatrix.modeler.internal.core.container.ContainerEditingDomain;
import com.metamatrix.modeler.internal.core.search.ModelWorkspaceSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CutWithRelatedToClipboardCommand
extends CompoundCommand {
    private final Collection originals;
    private final Command mainCommand;
    private final EditingDomain domain;
    private final List additionalObjs;
    private ModelContents clipboardModelContents = null;

    public CutWithRelatedToClipboardCommand(Command command, EditingDomain domain, Collection collection) {
        this.originals = collection;
        this.domain = domain;
        this.mainCommand = command;
        this.additionalObjs = ((ModelEditorImpl)ModelerCore.getModelEditor()).findRelatedObjects(this.originals, this.domain);
        try {
            this.handleReferencingObjects();
        }
        catch (ModelerCoreException err) {
            // empty catch block
        }
        if (this.originals != null && this.originals.size() != 0) {
            this.clipboardModelContents = this.createAddCommandsForRelatedObjects();
        }
        this.append(this.mainCommand);
    }

    protected void handleReferencingObjects() throws ModelerCoreException {
        ModelEditor modelEditor = ModelerCore.getModelEditor();
        ArrayList<EObject> originalsToProcess = new ArrayList<EObject>(this.originals.size());
        ArrayList additionalCommands = new ArrayList();
        ModelWorkspaceSearch workspaceSearch = new ModelWorkspaceSearch();
        Iterator iter = this.originals.iterator();
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (eObj.eResource() == null) continue;
            originalsToProcess.add(eObj);
        }
        Collection allDeleted = modelEditor.findOtherObjectsToBeDeleted(originalsToProcess, this.domain, additionalCommands, workspaceSearch);
        modelEditor.findReferencesToObjectsBeingDeleted(allDeleted, this.domain, additionalCommands, workspaceSearch);
        Iterator cmdIter = additionalCommands.iterator();
        while (cmdIter.hasNext()) {
            this.append((Command)cmdIter.next());
        }
    }

    protected ModelContents createAddCommandsForRelatedObjects() {
        if (this.additionalObjs.size() != 0) {
            ContainerEditingDomain containerEdDomain = (ContainerEditingDomain)this.domain;
            ModelContents modelContents = containerEdDomain.createClipboardModelContents();
            this.doCreateAdditionalCommands(modelContents);
            containerEdDomain.setClipboardMapping(new SelfKnowledgableCopyHelper());
            return modelContents;
        }
        return null;
    }

    protected Collection doCreateAdditionalCommands(ModelContents targetContents) {
        EReference feature;
        EObject container;
        if (this.additionalObjs.isEmpty()) {
            return this.additionalObjs;
        }
        HashSet annotations = new HashSet();
        HashSet mappingClassSets = new HashSet();
        HashSet transformations = new HashSet();
        ArrayList remaining = new ArrayList();
        Iterator iter = this.additionalObjs.iterator();
        while (iter.hasNext()) {
            Object additionalObj = iter.next();
            if (additionalObj instanceof Annotation) {
                annotations.add(additionalObj);
                continue;
            }
            if (additionalObj instanceof MappingClassSet) {
                mappingClassSets.add(additionalObj);
                continue;
            }
            if (additionalObj instanceof TransformationMappingRoot) {
                transformations.add(additionalObj);
                continue;
            }
            remaining.add(additionalObj);
        }
        if (annotations.size() != 0) {
            container = targetContents.getAnnotationContainer(true);
            if (container == null) {
                container = CoreFactory.eINSTANCE.createAnnotationContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = CorePackage.eINSTANCE.getAnnotationContainer_Annotations();
            this.createAndAppendAddCommand(annotations, container, feature);
        }
        if (mappingClassSets.size() != 0) {
            container = targetContents.getMappingClassSetContainer(true);
            if (container == null) {
                container = TransformationFactory.eINSTANCE.createMappingClassSetContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = TransformationPackage.eINSTANCE.getMappingClassSetContainer_MappingClassSets();
            this.createAndAppendAddCommand(mappingClassSets, container, feature);
        }
        if (transformations.size() != 0) {
            container = targetContents.getTransformationContainer(true);
            if (container == null) {
                container = TransformationFactory.eINSTANCE.createTransformationContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = TransformationPackage.eINSTANCE.getTransformationContainer_TransformationMappings();
            this.createAndAppendAddCommand(transformations, container, feature);
        }
        return null;
    }

    protected void createAndAppendAddCommand(Set objectsToAdd, EObject container, EStructuralFeature feature) {
        Command addCommand = AddCommand.create(this.domain, (Object)container, (Object)feature, objectsToAdd);
        this.append(addCommand);
    }

    public void execute() {
        this.domain.setClipboard(null);
        super.execute();
        if (this.clipboardModelContents != null && this.domain instanceof ContainerEditingDomain) {
            ContainerEditingDomain containerEdDomain = (ContainerEditingDomain)this.domain;
            ModelContents existingContents = containerEdDomain.getClipboardModelContents(false);
            if (existingContents == null) {
                containerEdDomain.setClipboardModelContents(this.clipboardModelContents);
            } else if (existingContents != this.clipboardModelContents) {
                String msg = ModelerCore.Util.getString("CutWithRelatedToClipboardCommand.Unexpected_existing_model_contents_on_clipboard");
                ModelerCore.Util.log(2, msg);
                containerEdDomain.setClipboardModelContents(this.clipboardModelContents);
            }
        }
    }

    public class SelfKnowledgableCopyHelper
    extends CopyCommand.Helper {
        public Object get(Object key) {
            Object result = super.get(key);
            if (result == null) {
                result = key;
            }
            return result;
        }

        public EObject getCopy(EObject object) {
            EObject result = super.getCopy(object);
            if (result == null) {
                result = object;
            }
            return result;
        }
    }
}

