/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.container;

import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.transformation.MappingClassSet;
import com.metamatrix.metamodels.transformation.TransformationFactory;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TransformationPackage;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import com.metamatrix.modeler.internal.core.FindRelatedObjectsToBeCopied;
import com.metamatrix.modeler.internal.core.ModelEditorImpl;
import com.metamatrix.modeler.internal.core.container.ContainerEditingDomain;
import com.metamatrix.modeler.internal.core.container.CopyToClipboardCommandWithMapping;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CopyWithRelatedToClipboardCommand
extends CompoundCommand {
    private final Collection originals;
    private final CopyToClipboardCommandWithMapping mainCopyCommand;
    private final EditingDomain domain;

    public CopyWithRelatedToClipboardCommand(EditingDomain domain, Collection collection) {
        this.originals = collection;
        this.domain = domain;
        this.mainCopyCommand = new CopyToClipboardCommandWithMapping(domain, collection);
        this.append(this.mainCopyCommand);
    }

    public void execute() {
        super.execute();
        if (this.originals != null && this.originals.size() != 0) {
            this.doCopyRelatedObjects();
        }
    }

    protected void doCopyRelatedObjects() {
        if (this.domain instanceof ContainerEditingDomain) {
            FindRelatedObjectsToBeCopied visitor = new FindRelatedObjectsToBeCopied();
            ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
            try {
                processor.walk(this.originals, 2);
            }
            catch (ModelerCoreException e2) {
                ModelerCore.Util.log(e2);
            }
            Collection additionalObjs = visitor.getAdditionalObjects();
            if (additionalObjs.size() != 0) {
                ModelContents modelContents = ((ContainerEditingDomain)this.domain).getClipboardModelContents(true);
                this.doCreateAdditionalCommands(additionalObjs, modelContents);
            }
        }
    }

    protected Collection doCreateAdditionalCommands(Collection additionalObjs, ModelContents targetContents) {
        EReference feature;
        EObject container;
        if (additionalObjs.isEmpty()) {
            return additionalObjs;
        }
        HashSet annotations = new HashSet();
        HashSet transformations = new HashSet();
        HashSet mappingClassSets = new HashSet();
        LinkedList remaining = new LinkedList();
        Iterator iter = additionalObjs.iterator();
        while (iter.hasNext()) {
            Object additionalObj = iter.next();
            if (additionalObj instanceof Annotation) {
                annotations.add(additionalObj);
                continue;
            }
            if (additionalObj instanceof TransformationMappingRoot) {
                transformations.add(additionalObj);
                continue;
            }
            if (additionalObj instanceof MappingClassSet) {
                mappingClassSets.add(additionalObj);
                continue;
            }
            remaining.add(additionalObj);
        }
        if (annotations.size() != 0) {
            container = targetContents.getAnnotationContainer(true);
            if (container == null) {
                container = CoreFactory.eINSTANCE.createAnnotationContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = CorePackage.eINSTANCE.getAnnotationContainer_Annotations();
            this.copyAndAdd(annotations, container, feature);
        }
        if (mappingClassSets.size() != 0) {
            container = targetContents.getMappingClassSetContainer(true);
            if (container == null) {
                container = TransformationFactory.eINSTANCE.createMappingClassSetContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = TransformationPackage.eINSTANCE.getMappingClassSetContainer_MappingClassSets();
            this.copyAndAdd(mappingClassSets, container, feature);
        }
        if (transformations.size() != 0) {
            container = targetContents.getTransformationContainer(true);
            if (container == null) {
                container = TransformationFactory.eINSTANCE.createTransformationContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = TransformationPackage.eINSTANCE.getTransformationContainer_TransformationMappings();
            this.copyAndAdd(transformations, container, feature);
        }
        return null;
    }

    protected void copyAndAdd(Set additionalObjects, EObject container, EStructuralFeature feature) {
        Collection copiedAnnotations;
        Command addCommand;
        boolean added;
        CopyCommand.Helper helper = this.mainCopyCommand.getCopyKeyedByOriginalMap();
        Command copyCommand = ModelEditorImpl.createCopyCommand(this.domain, additionalObjects, helper);
        boolean copied = this.appendAndExecute(copyCommand);
        if (copied && !(added = this.appendAndExecute(addCommand = AddCommand.create(this.domain, (Object)container, (Object)feature, copiedAnnotations = copyCommand.getResult())))) {
            Object[] params = new Object[]{new Integer(copiedAnnotations.size()), feature.getName()};
            String msg = ModelerCore.Util.getString("CopyWithRelatedToClipboardCommand.Failed_to_add_{0}_copied_{1}_to_clipboard", params);
            ModelerCore.Util.log(msg);
        }
    }
}

