/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.extension.XAttribute;
import com.metamatrix.metamodels.core.extension.XClass;
import com.metamatrix.metamodels.core.extension.XPackage;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.internal.core.ObjectExtension;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XsdObjectExtension
extends ObjectExtension {
    public static final String EXTENSION_PACKAGE = "extensionPackage";

    public XsdObjectExtension() {
    }

    public XsdObjectExtension(EObject extendedObject, XClass xclass, ModelEditor editor) {
        super(extendedObject, xclass, editor);
    }

    protected void doDynamicSet(EStructuralFeature eFeature, Object newValue) {
        XSDConcreteComponent comp;
        EObject eObject = super.getExtendedObject();
        if (eObject != null && eObject instanceof XSDConcreteComponent && XsdObjectExtension.canAnnotate(comp = (XSDConcreteComponent)eObject)) {
            EDataType dt = (EDataType)eFeature.getEType();
            EPackage ePackage = dt.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            String newStringValue = null;
            if (eFeature.isMany()) {
                List values = (List)newValue;
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    Object value = iter.next();
                    if (newStringValue == null) {
                        newStringValue = fac.convertToString(dt, value);
                        continue;
                    }
                    newStringValue = newStringValue + " " + fac.convertToString(dt, value);
                }
            } else {
                newStringValue = fac.convertToString(dt, newValue);
            }
            String name = eFeature.getName();
            XsdObjectExtension.addAppInfoAttribute(comp, name, newStringValue);
            this.setAndResetTargetNamespace(comp.getSchema());
        }
    }

    private void setAndResetTargetNamespace(XSDSchema schema) {
        if (schema != null) {
            EStructuralFeature feature;
            Resource xsdResource = schema.eResource();
            if (xsdResource != null) {
                schema.eResource().setModified(true);
            }
            if ((feature = schema.eClass().getEStructuralFeature("targetNamespace")) != null) {
                Object origValue = schema.eGet(feature);
                schema.eSet(feature, null);
                schema.eSet(feature, origValue);
            }
        }
    }

    protected Object doDynamicGet(EStructuralFeature eFeature, Object result) {
        XSDConcreteComponent comp;
        EObject eObject = super.getExtendedObject();
        if (eObject != null && eObject instanceof XSDConcreteComponent && XsdObjectExtension.canAnnotate(comp = (XSDConcreteComponent)eObject)) {
            String name = eFeature.getName();
            EDataType dt = (EDataType)eFeature.getEType();
            EPackage ePackage = dt.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            String value = XsdObjectExtension.getAppInfoAttributeValue(comp, name);
            if (value == null || "".equals(value)) {
                Object defaultValue = eFeature.getDefaultValue();
                if (defaultValue != null && !"".equals(defaultValue)) {
                    value = defaultValue.toString();
                } else {
                    Object typeDefault = dt.getDefaultValue();
                    String string = value = typeDefault != null ? typeDefault.toString() : null;
                }
            }
            if (eFeature.isMany()) {
                BasicEList values = new BasicEList();
                result = values;
                StringTokenizer stringTokenizer = new StringTokenizer(value, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String token = stringTokenizer.nextToken();
                    values.add(fac.createFromString(dt, token));
                }
            } else {
                result = fac.createFromString(dt, value);
            }
        }
        return result;
    }

    protected boolean doDynamicIsSet(EStructuralFeature eFeature) {
        XSDConcreteComponent comp;
        EObject eObject = super.getExtendedObject();
        if (eObject != null && eObject instanceof XSDConcreteComponent && XsdObjectExtension.canAnnotate(comp = (XSDConcreteComponent)eObject)) {
            String name = eFeature.getName();
            String value = XsdObjectExtension.getAppInfoAttributeValue(comp, name);
            return value != null;
        }
        return super.eDynamicIsSet(eFeature);
    }

    protected void doDynamicUnset(EStructuralFeature eFeature) {
        XSDConcreteComponent comp;
        EObject eObject = super.getExtendedObject();
        if (eObject != null && eObject instanceof XSDConcreteComponent && XsdObjectExtension.canAnnotate(comp = (XSDConcreteComponent)eObject)) {
            String name = eFeature.getName();
            XsdObjectExtension.removeAppInfoAttribute(comp, name);
        }
    }

    public static boolean isWritable(XSDConcreteComponent component) {
        if (component == null) {
            return false;
        }
        XSDResourceImpl rsrc = (XSDResourceImpl)component.eResource();
        return XsdObjectExtension.isWritable(rsrc);
    }

    public static boolean isWritable(XSDResourceImpl rsrc) {
        File file;
        if (rsrc == null) {
            return false;
        }
        URI uri = rsrc.getURI();
        if (uri != null && uri.toFileString() != null && (file = new File(uri.toFileString())).exists()) {
            return file.canWrite();
        }
        return true;
    }

    public static boolean canAnnotate(XSDConcreteComponent comp) {
        ArgCheck.isNotNull(comp);
        boolean writable = XsdObjectExtension.isWritable(comp);
        if (!writable) {
            return false;
        }
        return comp instanceof XSDSchema || comp instanceof XSDAttributeDeclaration || comp instanceof XSDAttributeGroupDefinition || comp instanceof XSDElementDeclaration || comp instanceof XSDNotationDeclaration || comp instanceof XSDModelGroup || comp instanceof XSDModelGroupDefinition || comp instanceof XSDIdentityConstraintDefinition || comp instanceof XSDTypeDefinition || comp instanceof XSDWildcard || comp instanceof XSDFacet;
    }

    public static XSDAnnotation getAnnotation(XSDConcreteComponent comp) {
        ArgCheck.isNotNull(comp);
        XSDAnnotation annotation = null;
        if (comp instanceof XSDSchema) {
            EList annotations = ((XSDSchema)comp).getAnnotations();
            if (annotations != null) {
                Iterator iter = annotations.iterator();
                while (iter.hasNext() && (annotation = (XSDAnnotation)iter.next()) == null) {
                }
            }
        } else if (comp instanceof XSDAttributeDeclaration) {
            annotation = ((XSDAttributeDeclaration)comp).getAnnotation();
        } else if (comp instanceof XSDAttributeGroupDefinition) {
            annotation = ((XSDAttributeGroupDefinition)comp).getAnnotation();
        } else if (comp instanceof XSDElementDeclaration) {
            annotation = ((XSDElementDeclaration)comp).getAnnotation();
        } else if (comp instanceof XSDNotationDeclaration) {
            annotation = ((XSDNotationDeclaration)comp).getAnnotation();
        } else if (comp instanceof XSDModelGroup) {
            annotation = ((XSDModelGroup)comp).getAnnotation();
        } else if (comp instanceof XSDModelGroupDefinition) {
            annotation = ((XSDModelGroupDefinition)comp).getAnnotation();
        } else if (comp instanceof XSDIdentityConstraintDefinition) {
            annotation = ((XSDIdentityConstraintDefinition)comp).getAnnotation();
        } else if (comp instanceof XSDTypeDefinition) {
            annotation = ((XSDTypeDefinition)comp).getAnnotation();
        } else if (comp instanceof XSDWildcard) {
            annotation = ((XSDWildcard)comp).getAnnotation();
        } else if (comp instanceof XSDFacet) {
            annotation = ((XSDFacet)comp).getAnnotation();
        }
        return annotation;
    }

    public static void setAnnotation(XSDConcreteComponent comp, XSDAnnotation annotation) {
        ArgCheck.isNotNull(comp);
        if (annotation == null) {
            return;
        }
        if (comp instanceof XSDSchema) {
            EList annotations = ((XSDSchema)comp).getAnnotations();
            if (annotations != null) {
                annotations.add(annotations);
            }
        } else if (comp instanceof XSDAttributeDeclaration) {
            ((XSDAttributeDeclaration)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDAttributeGroupDefinition) {
            ((XSDAttributeGroupDefinition)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDElementDeclaration) {
            ((XSDElementDeclaration)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDNotationDeclaration) {
            ((XSDNotationDeclaration)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDModelGroup) {
            ((XSDModelGroup)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDModelGroupDefinition) {
            ((XSDModelGroupDefinition)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDIdentityConstraintDefinition) {
            ((XSDIdentityConstraintDefinition)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDTypeDefinition) {
            ((XSDTypeDefinition)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDWildcard) {
            ((XSDWildcard)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDFacet) {
            ((XSDFacet)comp).setAnnotation(annotation);
        }
    }

    public static void addAppInfoAttribute(XSDConcreteComponent comp, String name, String value) {
        ArgCheck.isNotNull(comp);
        if (!XsdObjectExtension.canAnnotate(comp)) {
            return;
        }
        XSDAnnotation annotation = XsdObjectExtension.getAnnotation(comp);
        if (annotation == null) {
            annotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            XsdObjectExtension.setAnnotation(comp, annotation);
        }
        XsdObjectExtension.addAppInfoAttribute(annotation, name, value);
    }

    public static void addAppInfoAttribute(XSDAnnotation annotation, String name, String value) {
        ArgCheck.isNotNull(annotation);
        ArgCheck.isNotZeroLength(name);
        EList appInfos = annotation.getApplicationInformation();
        Iterator iter = appInfos.iterator();
        while (iter.hasNext()) {
            Element appInfo = (Element)iter.next();
            if (appInfo == null || appInfo.getAttribute(name) == null) continue;
            if (value == null || "".equals(value)) {
                appInfo.removeAttribute(name);
            } else {
                appInfo.setAttribute(name, value);
            }
            return;
        }
        Element appInfo = null;
        if (annotation.getApplicationInformation().isEmpty()) {
            appInfo = annotation.createApplicationInformation(null);
            annotation.getElement().appendChild(appInfo);
        } else {
            appInfo = (Element)annotation.getApplicationInformation().iterator().next();
        }
        appInfo.setAttribute(name, value);
    }

    public static void removeAppInfoAttribute(XSDConcreteComponent comp, String name) {
        ArgCheck.isNotNull(comp);
        ArgCheck.isNotZeroLength(name);
        if (!XsdObjectExtension.canAnnotate(comp)) {
            return;
        }
        XSDAnnotation annotation = XsdObjectExtension.getAnnotation(comp);
        if (annotation == null) {
            return;
        }
        EList appInfos = annotation.getApplicationInformation();
        Iterator iter = appInfos.iterator();
        while (iter.hasNext()) {
            Element appInfo = (Element)iter.next();
            if (appInfo == null || appInfo.getAttribute(name) == null) continue;
            appInfo.removeAttribute(name);
        }
    }

    public static String getAppInfoAttributeValue(XSDConcreteComponent comp, String name) {
        ArgCheck.isNotNull(comp);
        ArgCheck.isNotZeroLength(name);
        return (String)XsdObjectExtension.getAppInfoAttributeMap(comp).get(name);
    }

    public static Map getAppInfoAttributeMap(XSDConcreteComponent comp) {
        ArgCheck.isNotNull(comp);
        if (!XsdObjectExtension.canAnnotate(comp)) {
            return Collections.EMPTY_MAP;
        }
        XSDAnnotation annotation = XsdObjectExtension.getAnnotation(comp);
        if (annotation == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        EList appInfos = annotation.getApplicationInformation();
        Iterator iter = appInfos.iterator();
        while (iter.hasNext()) {
            Element appInfo = (Element)iter.next();
            if (appInfo == null) continue;
            NamedNodeMap map = appInfo.getAttributes();
            int length = map.getLength();
            if (map == null || length <= 0) continue;
            for (int i2 = 0; i2 < length; ++i2) {
                Node mapNode = map.item(i2);
                if (mapNode == null) continue;
                result.put(mapNode.getNodeName(), mapNode.getNodeValue());
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public static XPackage getExtensionPackage(XSDResourceImpl xsdResource) throws ModelerCoreException {
        ArgCheck.isNotNull(xsdResource);
        XSDSchema schema = xsdResource.getSchema();
        if (schema != null) {
            return XsdObjectExtension.getExtensionPackage(schema);
        }
        return null;
    }

    public static XPackage getExtensionPackage(XSDSchema schema) throws ModelerCoreException {
        ArgCheck.isNotNull(schema);
        Map extMap = XsdObjectExtension.getAppInfoAttributeMap(schema);
        String extPkgLocation = (String)extMap.get(EXTENSION_PACKAGE);
        if (extPkgLocation != null && extPkgLocation.length() > 0) {
            XPackage extPackage = null;
            try {
                URI extPkgURI = URI.createURI(extPkgLocation);
                extPkgURI = extPkgURI.resolve(schema.eResource().getURI());
                extPackage = (XPackage)ModelerCore.getModelContainer().getEObject(extPkgURI, true);
                if (extPackage == null) {
                    extPackage = (XPackage)schema.eResource().getResourceSet().getEObject(extPkgURI, true);
                }
            }
            catch (CoreException err) {
                String msg = ModelerCore.Util.getString("XsdObjectExtension.getExtension_1");
                ModelerCore.Util.log(4, err, msg);
            }
            if (extPackage != null) {
                return extPackage;
            }
            String msg = ModelerCore.Util.getString("XsdObjectExtension.getExtension_0");
            throw new ModelerCoreException(msg);
        }
        return null;
    }

    public static void removeExtensionPackage(XSDResourceImpl xsdResource) throws ModelerCoreException {
        ArgCheck.isNotNull(xsdResource);
        XPackage extPackage = XsdObjectExtension.getExtensionPackage(xsdResource);
        XSDSchema schema = xsdResource.getSchema();
        if (extPackage != null && schema != null) {
            boolean incrementalUpdate = schema.isIncrementalUpdate();
            schema.setIncrementalUpdate(false);
            TreeIterator iter = xsdResource.getAllContents();
            while (iter.hasNext()) {
                XSDConcreteComponent comp;
                EClass eClass;
                XClass xClass;
                Object obj = iter.next();
                if (!(obj instanceof XSDConcreteComponent) || (xClass = extPackage.findXClass(eClass = (comp = (XSDConcreteComponent)obj).eClass())) == null) continue;
                TreeIterator iter2 = xClass.eAllContents();
                while (iter2.hasNext()) {
                    EObject eObj = (EObject)iter2.next();
                    if (!(eObj instanceof XAttribute)) continue;
                    XsdObjectExtension.removeAppInfoAttribute(comp, ((XAttribute)eObj).getName());
                }
            }
            schema.setIncrementalUpdate(incrementalUpdate);
        }
        if (schema != null) {
            XsdObjectExtension.removeAppInfoAttribute(schema, EXTENSION_PACKAGE);
        }
    }

    public static void setExtensionPackage(XSDResourceImpl xsdResource, XPackage extPackage) throws ModelerCoreException {
        ArgCheck.isNotNull(xsdResource);
        XsdObjectExtension.setExtensionPackage(xsdResource.getSchema(), extPackage);
    }

    public static void setExtensionPackage(XSDSchema schema, XPackage extPackage) throws ModelerCoreException {
        ArgCheck.isNotNull(schema);
        ArgCheck.isNotNull(extPackage);
        Resource xsdResource = schema.eResource();
        Resource extResource = extPackage.eResource();
        if (xsdResource != null && extResource != null) {
            URI xsdURI = xsdResource.getURI();
            URI extURI = extResource.getURI();
            URI relativeURI = (extURI = extURI.appendFragment(extResource.getURIFragment(extPackage))).deresolve(xsdURI);
            if (relativeURI != null) {
                XsdObjectExtension.addAppInfoAttribute(schema, EXTENSION_PACKAGE, relativeURI.toString());
            }
        } else {
            String msg = ModelerCore.Util.getString("XsdObjectExtension.setExtension_2");
            ModelerCore.Util.log(4, msg);
        }
    }
}

