/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.MetamodelRootClassDescriptor;
import com.metamatrix.modeler.core.ModelInitializer;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.MetamodelAspectFactory;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EFactory;

public class MetamodelDescriptorImpl
implements MetamodelDescriptor {
    private static final String[] INVALID_EXTENSIONS_FOR_INPUTSTREAM = new String[]{".jar", ".zip"};
    private static final ModelType[] EMPTY_MODEL_TYPE_ARRAY = new ModelType[0];
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private static final String CREATE_AS_NEW_MODEL_PROPERTY_DEFAULT_VALUE = TRUE;
    private static final String PARTICIPATORY_ONLY_PROPERTY_DEFAULT_VALUE = FALSE;
    private static final String REQUIRES_PROXIES_PROPERTY_DEFAULT_VALUE = FALSE;
    private String pluginID;
    private String extensionID;
    private String name;
    private String uri;
    private List alternateURIs;
    private String internalURI;
    private String namespacePrefix;
    private String resourceURL;
    private Properties properties;
    private List allowableTypes;
    private String fileExtension;
    private boolean canGetInputStream;
    private ClassLoader resourceClassLoader;
    private DescriptorClassLoader eFactoryClassLoader;
    private DescriptorClassLoader ePackageClassLoader;
    private DescriptorClassLoader adapterFactoryClassLoader;
    private List rootClassDescriptors;
    private final Map modelInitializerDescriptorClassLoadersByName;
    private final Map modelInitializerDescriptionsByName;
    private final List modelInitializerNames;
    private final List readOnlyModelInitializerNames;
    private final Map metamodelAspectClassLoaderByID = new HashMap();

    public MetamodelDescriptorImpl() {
        this.properties = new Properties();
        this.modelInitializerDescriptorClassLoadersByName = new HashMap();
        this.modelInitializerDescriptionsByName = new HashMap();
        this.modelInitializerNames = new ArrayList();
        this.readOnlyModelInitializerNames = Collections.unmodifiableList(this.modelInitializerNames);
        this.alternateURIs = new ArrayList();
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public String getExtensionID() {
        return this.extensionID;
    }

    public String getName() {
        return this.name;
    }

    public String getURI() {
        return this.uri;
    }

    public List getAlternateURIs() {
        return this.alternateURIs;
    }

    public boolean isPrimaryMetamodel() {
        String value;
        boolean isPrimary = true;
        if (this.properties != null && (value = (String)this.properties.get("participatoryOnly")) != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
            isPrimary = false;
        }
        return isPrimary;
    }

    public boolean requiresProxies() {
        String value;
        boolean requiresProxies = false;
        if (this.properties != null && (value = (String)this.properties.get("requiresProxies")) != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
            requiresProxies = true;
        }
        return requiresProxies;
    }

    public boolean supportsExtension() {
        String value;
        boolean supportsExtension = false;
        if (this.properties != null && (value = (String)this.properties.get("supportsExtension")) != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
            supportsExtension = true;
        }
        return supportsExtension;
    }

    public boolean supportsDiagrams() {
        String value;
        boolean supportsDiagrams = false;
        if (this.properties != null && (value = (String)this.properties.get("supportsDiagrams")) != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
            supportsDiagrams = true;
        }
        return supportsDiagrams;
    }

    public boolean canCreateNewModel() {
        String value;
        boolean createAsNewModel = false;
        if (this.properties != null && (value = (String)this.properties.get("createAsNewModel")) != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
            createAsNewModel = true;
        }
        return createAsNewModel;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public Class getFactoryClass() {
        return this.eFactoryClassLoader != null ? this.eFactoryClassLoader.getLoadedClass() : null;
    }

    public EFactory getFactoryClassInstance() {
        return (EFactory)(this.eFactoryClassLoader != null ? this.eFactoryClassLoader.getClassInstance() : null);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ModelType[] getAllowableModelTypes() {
        if (this.allowableTypes == null || this.allowableTypes.size() == 0) {
            return EMPTY_MODEL_TYPE_ARRAY;
        }
        ModelType[] tmp = new ModelType[this.allowableTypes.size()];
        return this.allowableTypes.toArray(tmp);
    }

    public String getFileExtension() {
        if (this.fileExtension == null) {
            this.fileExtension = ".xmi";
        }
        return this.fileExtension;
    }

    public InputStream getInputStream() {
        if (this.resourceURL != null && this.resourceClassLoader != null && this.canGetInputStream) {
            return this.resourceClassLoader.getResourceAsStream(this.resourceURL);
        }
        return null;
    }

    public String getInternalURI() {
        return this.internalURI;
    }

    public String getResourceURL() {
        return this.resourceURL;
    }

    public MetamodelRootClassDescriptor[] getRootClassDescriptors() {
        if (this.rootClassDescriptors == null) {
            return new MetamodelRootClassDescriptor[0];
        }
        MetamodelRootClassDescriptor[] result = new MetamodelRootClassDescriptor[this.rootClassDescriptors.size()];
        return this.rootClassDescriptors.toArray(result);
    }

    public ClassLoader getFactoryClassLoader() {
        return this.eFactoryClassLoader != null ? this.eFactoryClassLoader.getClassLoader() : null;
    }

    public Class getPackageClass() {
        return this.ePackageClassLoader != null ? this.ePackageClassLoader.getLoadedClass() : null;
    }

    public Class getAdapterFactoryClass() {
        return this.adapterFactoryClassLoader != null ? this.adapterFactoryClassLoader.getLoadedClass() : null;
    }

    public AdapterFactory getAdapterFactoryClassInstance() {
        return (AdapterFactory)(this.adapterFactoryClassLoader != null ? this.adapterFactoryClassLoader.getClassInstance() : null);
    }

    public Class getMetamodelAspectFactoryClass(String extensionPointID) {
        DescriptorClassLoader loader = (DescriptorClassLoader)this.metamodelAspectClassLoaderByID.get(extensionPointID);
        return loader != null ? loader.getLoadedClass() : null;
    }

    public MetamodelAspectFactory getMetamodelAspectFactoryClassInstance(String extensionPointID) {
        DescriptorClassLoader loader = (DescriptorClassLoader)this.metamodelAspectClassLoaderByID.get(extensionPointID);
        return (MetamodelAspectFactory)(loader != null ? loader.getClassInstance() : null);
    }

    public void setExtensionID(String extensionID) {
        ArgCheck.isNotNull(extensionID);
        this.extensionID = extensionID;
    }

    public void setName(String name) {
        ArgCheck.isNotNull(name);
        this.name = name;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        ArgCheck.isNotNull(namespacePrefix);
        this.namespacePrefix = namespacePrefix;
    }

    public void setURI(String uri) {
        ArgCheck.isNotNull(uri);
        this.uri = uri;
    }

    public void setProperties(Properties properties) {
        ArgCheck.isNotNull(properties);
        this.properties = properties;
        MetamodelDescriptorImpl.addDefaultPropertyValues(this.properties);
    }

    public void setInternalURI(String internalURI) {
        ArgCheck.isNotNull(internalURI);
        this.internalURI = internalURI;
    }

    public void setResourceURL(String resourceURL, ClassLoader resourceClassLoader) {
        ArgCheck.isNotNull(resourceURL);
        MetamodelDescriptorImpl.argCheckClassLoader(resourceClassLoader);
        this.resourceURL = resourceURL;
        this.resourceClassLoader = resourceClassLoader;
        this.canGetInputStream = true;
        for (int i2 = 0; i2 < INVALID_EXTENSIONS_FOR_INPUTSTREAM.length; ++i2) {
            String invalidFileExtension = INVALID_EXTENSIONS_FOR_INPUTSTREAM[i2];
            if (!resourceURL.endsWith(invalidFileExtension)) continue;
            this.canGetInputStream = false;
            break;
        }
    }

    public void setEFactoryClassLoader(String className, ClassLoader classLoader) {
        this.eFactoryClassLoader = new DescriptorClassLoader(className, classLoader);
    }

    public void setEPackageClassLoader(String className, ClassLoader classLoader) {
        this.ePackageClassLoader = new DescriptorClassLoader(className, classLoader);
    }

    public void setAdapterFactoryClassLoader(String className, ClassLoader classLoader) {
        this.adapterFactoryClassLoader = new DescriptorClassLoader(className, classLoader);
    }

    public void addAlternateURI(String alternateURI) {
        ArgCheck.isNotNull(alternateURI);
        this.alternateURIs.add(alternateURI);
    }

    public void addAllowableModelType(String modelTypeName) {
        ModelType type;
        ArgCheck.isNotNull(modelTypeName);
        if (this.allowableTypes == null) {
            this.allowableTypes = new ArrayList();
        }
        if ((type = ModelType.get(modelTypeName)) != null && !this.allowableTypes.contains(type)) {
            this.allowableTypes.add(type);
        }
    }

    public void setFileExtension(String string) {
        ArgCheck.isNotZeroLength(string);
        String extension = string.trim();
        this.fileExtension = extension.charAt(0) == '.' ? extension : "." + extension;
    }

    public void addRootClassDescriptor(MetamodelRootClassDescriptor descriptor) {
        ArgCheck.isNotNull(descriptor);
        if (this.rootClassDescriptors == null) {
            this.rootClassDescriptors = new ArrayList();
        }
        this.rootClassDescriptors.add(descriptor);
    }

    public void addMetamodelAspectClassLoader(String extensionPointID, String className, ClassLoader classLoader) {
        MetamodelDescriptorImpl.argCheckClassName(className);
        MetamodelDescriptorImpl.argCheckClassLoader(classLoader);
        if (extensionPointID == null || extensionPointID.length() == 0) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MetamodelDescriptorImpl.The_extension_point_ID_string_may_not_be_null_or_empty_1"));
        }
        String extensionID = StringUtil.getLastToken(extensionPointID, ".");
        Object value = this.metamodelAspectClassLoaderByID.get(extensionID);
        if (value != null) {
            if (ModelerCore.DEBUG_METAMODEL) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelDescriptorImpl.DEBUG.Removing_MetamodelAspectFactory_for_extension_point_ID", new Object[]{value, extensionID}));
            }
            this.metamodelAspectClassLoaderByID.remove(extensionID);
        }
        if (ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelDescriptorImpl.DEBUG.Adding_MetamodelAspectFactory,_for_extension_point_1", new Object[]{className, extensionID}));
        }
        this.metamodelAspectClassLoaderByID.put(extensionID, new DescriptorClassLoader(className, classLoader));
    }

    public void setPluginID(String string) {
        this.pluginID = string;
    }

    public void printMetamodelAspects(PrintStream stream) {
        stream.println("MetamodelAspects registered for descriptor " + this.extensionID);
        Iterator iter = this.metamodelAspectClassLoaderByID.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            stream.println("  key = " + entry.getKey() + " value = " + entry.getValue());
        }
    }

    public String toString() {
        Object[] params = new Object[]{this.getName(), this.getURI()};
        return ModelerCore.Util.getString("MetamodelDescriptorImpl.MetamodelDescriptorImpl__name,_URI", params);
    }

    public List getModelInitializerNames() {
        return this.readOnlyModelInitializerNames;
    }

    public String getModelInitializerDescription(String name) {
        return (String)this.modelInitializerDescriptionsByName.get(name);
    }

    public ModelInitializer getModelInitializer(String name) {
        Object instance;
        DescriptorClassLoader loader = (DescriptorClassLoader)this.modelInitializerDescriptorClassLoadersByName.get(name);
        if (loader != null && (instance = loader.getClassInstance()) instanceof ModelInitializer) {
            return (ModelInitializer)instance;
        }
        return null;
    }

    public void addModelInitializer(String name, String desc, String className, ClassLoader classLoader) {
        DescriptorClassLoader loader = new DescriptorClassLoader(className, classLoader);
        try {
            this.modelInitializerDescriptorClassLoadersByName.put(name, loader);
            this.modelInitializerDescriptionsByName.put(name, desc);
            this.modelInitializerNames.add(name);
        }
        catch (Throwable e2) {
            try {
                this.modelInitializerDescriptorClassLoadersByName.remove(name);
                this.modelInitializerDescriptionsByName.remove(name);
            }
            catch (RuntimeException e1) {
                ModelerCore.Util.log(e1);
            }
        }
    }

    private static void addDefaultPropertyValues(Properties props) {
        String key = "participatoryOnly";
        if (props.getProperty(key) == null) {
            props.setProperty(key, PARTICIPATORY_ONLY_PROPERTY_DEFAULT_VALUE);
        }
        if (props.getProperty(key = "requiresProxies") == null) {
            props.setProperty(key, REQUIRES_PROXIES_PROPERTY_DEFAULT_VALUE);
        }
        if (props.getProperty(key = "createAsNewModel") == null) {
            String participatoryOnly = props.getProperty("participatoryOnly");
            if (participatoryOnly != null && participatoryOnly.equalsIgnoreCase(TRUE)) {
                props.setProperty(key, FALSE);
            } else {
                props.setProperty(key, CREATE_AS_NEW_MODEL_PROPERTY_DEFAULT_VALUE);
            }
        }
    }

    private static void argCheckClassName(String className) {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MetamodelDescriptorImpl.The_class_name_string_may_not_be_null_or_empty_2"));
        }
    }

    private static void argCheckClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MetamodelDescriptorImpl.The_class_loader_reference_may_not_be_null_3"));
        }
    }

    private class DescriptorClassLoader {
        private final String className;
        private final ClassLoader classLoader;
        private boolean loadClassFailure;
        private boolean newInstanceFailure;
        private Class loadedClass;
        private Object classInstance;

        public DescriptorClassLoader(String className, ClassLoader classLoader) {
            MetamodelDescriptorImpl.argCheckClassName(className);
            MetamodelDescriptorImpl.argCheckClassLoader(classLoader);
            this.className = className;
            this.classLoader = classLoader;
            this.loadClassFailure = false;
            this.newInstanceFailure = false;
            this.loadedClass = null;
            this.classInstance = null;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Class getLoadedClass() {
            if (!this.loadClassFailure && this.loadedClass == null) {
                try {
                    this.loadedClass = this.classLoader.loadClass(this.className);
                    this.loadClassFailure = false;
                }
                catch (Throwable e2) {
                    ModelerCore.Util.log(4, ModelerCore.Util.getString("ExtensionDescriptorImpl.Unable_to_load_class_using_classLoader_4", this.className, this.classLoader));
                    this.loadedClass = null;
                    this.loadClassFailure = true;
                }
            }
            return this.loadedClass;
        }

        public Object getClassInstance() {
            if (!this.newInstanceFailure && this.classInstance == null && this.getLoadedClass() != null) {
                try {
                    this.classInstance = this.getLoadedClass().newInstance();
                    this.newInstanceFailure = false;
                }
                catch (InstantiationException e2) {
                    ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ExtensionDescriptorImpl.Creating_an_instance_of_5", this.loadedClass, e2.getMessage()));
                    this.classInstance = null;
                    this.newInstanceFailure = true;
                }
                catch (IllegalAccessException e3) {
                    ModelerCore.Util.log(4, e3, ModelerCore.Util.getString("ExtensionDescriptorImpl.Creating_an_instance_of_6", this.loadedClass, e3.getMessage()));
                    this.classInstance = null;
                    this.newInstanceFailure = true;
                }
            }
            return this.classInstance;
        }

        public String toString() {
            Object[] params = new Object[]{this.className, this.classLoader, new Boolean(this.loadedClass != null)};
            return ModelerCore.Util.getString("MetamodelDescriptorImpl.MetamodelDescriptorLoader__className,_classLoader,_isLoaded", params);
        }
    }
}

