/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.MappingClassSet;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class FindRelatedObjectsToBeCopied
implements ModelVisitor {
    private final Set objectsToBeCopied = new HashSet();
    private final Map modelContentsByResource = new HashMap();

    public void addModelContents(ModelContents contents, Resource emfResource) {
        ArgCheck.isNotNull(contents);
        ArgCheck.isNotNull(emfResource);
        this.modelContentsByResource.put(emfResource, contents);
    }

    public ModelContents getModelContents(Resource emfResource) {
        ModelContents result = (ModelContents)this.modelContentsByResource.get(emfResource);
        if (result == null && emfResource instanceof EmfResource && (result = ((EmfResource)emfResource).getModelContents()) != null) {
            this.addModelContents(result, emfResource);
        }
        return result;
    }

    public boolean visit(EObject object) throws ModelerCoreException {
        ModelContents modelContents;
        if (object instanceof Annotation) {
            return true;
        }
        Resource emfResource = object.eResource();
        if (emfResource != null && (modelContents = this.getModelContents(emfResource)) != null) {
            this.addAnnotation(object, modelContents);
            this.addTransformations(object, modelContents);
            this.addMappings(object, modelContents);
        }
        return true;
    }

    protected void addMappings(EObject object, ModelContents modelContents) {
        List mappingClassSets = modelContents.getMappingClassSets(object);
        if (mappingClassSets != null && mappingClassSets.size() != 0) {
            this.objectsToBeCopied.addAll(mappingClassSets);
            Iterator iter = mappingClassSets.iterator();
            while (iter.hasNext()) {
                MappingClassSet mcSet = (MappingClassSet)iter.next();
                EList mappingClasses = mcSet.getMappingClasses();
                Iterator mcIterator = mappingClasses.iterator();
                while (mcIterator.hasNext()) {
                    MappingClass mc = (MappingClass)mcIterator.next();
                    this.addAnnotation(mc, modelContents);
                    this.addTransformations(mc, modelContents);
                }
            }
        }
    }

    protected void addTransformations(EObject object, ModelContents modelContents) {
        List transformations = modelContents.getTransformationsForOutput(object);
        if (transformations != null && transformations.size() != 0) {
            this.objectsToBeCopied.addAll(transformations);
        }
    }

    protected void addAnnotation(EObject object, ModelContents modelContents) {
        Annotation existingAnnotation = modelContents.getAnnotation(object);
        if (existingAnnotation != null) {
            this.objectsToBeCopied.add(existingAnnotation);
        }
    }

    public boolean visit(Resource resource) throws ModelerCoreException {
        return resource != null;
    }

    public Collection getAdditionalObjects() {
        return this.objectsToBeCopied;
    }
}

