/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;

public class FindReferencesToDeletedObjects
implements ModelVisitor {
    private final Collection allDeletedObjects;
    private final Collection referencesToDeleted;

    public FindReferencesToDeletedObjects(Collection allDeletedObjects) {
        Assertion.isNotNull(allDeletedObjects);
        this.allDeletedObjects = new HashSet(allDeletedObjects);
        this.referencesToDeleted = new HashSet();
    }

    public boolean visit(EObject object) throws ModelerCoreException {
        EClass eclass = object.eClass();
        EList allRefs = eclass.getEAllReferences();
        Iterator iter = allRefs.iterator();
        while (iter.hasNext()) {
            EReference reference = (EReference)iter.next();
            EReference opposite = reference.getEOpposite();
            if (reference.isContainment() || opposite == null || opposite.isContainment()) continue;
            if (reference.isMany()) {
                Collection values = (Collection)object.eGet(reference);
                Iterator valueIter = values.iterator();
                while (valueIter.hasNext()) {
                    Object value = valueIter.next();
                    if (!this.allDeletedObjects.contains(value) || this.referencesToDeleted.contains(value)) continue;
                    this.referencesToDeleted.add(value);
                }
                continue;
            }
            Object value = object.eGet(reference);
            if (!this.allDeletedObjects.contains(value) || this.referencesToDeleted.contains(value)) continue;
            this.referencesToDeleted.add(value);
        }
        return true;
    }

    public boolean visit(Resource resource) throws ModelerCoreException {
        return resource != null;
    }

    public Collection getReferencesToDeletedObjects() {
        return this.referencesToDeleted;
    }
}

