/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;

public class ClearEObjectReferences
implements ModelVisitor {
    private final EObject refdObject;
    private final Set affectedObjects;

    public ClearEObjectReferences(EObject refdObject) {
        ArgCheck.isNotNull(refdObject);
        this.refdObject = refdObject;
        this.affectedObjects = new HashSet();
    }

    public boolean visit(EObject object) throws ModelerCoreException {
        EClass eclass = object.eClass();
        EList allRefs = eclass.getEAllReferences();
        Iterator i2 = allRefs.iterator();
        while (i2.hasNext()) {
            EReference reference = (EReference)i2.next();
            if (reference.isContainment() || reference.isContainer() || reference.isVolatile()) continue;
            Object value = object.eGet(reference, false);
            if (reference.isMany()) {
                boolean removeRefdValue = false;
                Iterator j2 = ((List)value).iterator();
                while (j2.hasNext()) {
                    Object valueInList = j2.next();
                    if (!(valueInList instanceof EObject) || valueInList != this.refdObject) continue;
                    removeRefdValue = true;
                }
                if (!removeRefdValue || !reference.isChangeable()) continue;
                ((List)value).remove(this.refdObject);
                this.affectedObjects.add(object);
                continue;
            }
            if (!(value instanceof EObject) || value != this.refdObject || !reference.isChangeable()) continue;
            object.eUnset(reference);
            this.affectedObjects.add(object);
        }
        return true;
    }

    public boolean visit(Resource resource) throws ModelerCoreException {
        return resource != null;
    }

    public Collection getAffectedObjects() {
        return this.affectedObjects;
    }
}

