/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.StructuralFeatureValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.rules.CoreValidationRulesUtil;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class StringNameRule
implements StructuralFeatureValidationRule {
    private char[] invalidChars;
    private final int featureID;
    private boolean nameCanBeNull = false;

    public StringNameRule(char[] invalidChars, int featureID) {
        ArgCheck.isNotNull(invalidChars);
        this.invalidChars = invalidChars;
        this.featureID = featureID;
    }

    public StringNameRule(int featureID) {
        this.featureID = featureID;
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        String name = (String)value;
        ValidationResultImpl result = new ValidationResultImpl(eObject);
        if (name == null) {
            if (!this.nameCanBeNull) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, ModelerCore.Util.getString("StringNameRule.The_entity_name_may_not_be_null._1"));
                result.addProblem(problem);
            }
        } else if (this.validateCharacters()) {
            CoreValidationRulesUtil.validateStringNameChars(result, name, this.invalidChars, this.getInvalidCharactersSeverityCode());
        }
        context.addResult(result);
        String objType = eObject.eClass().getName();
        if (!context.hasRunRule(eObject, this.getRuleName() + objType) && this.validateUniqueness()) {
            List siblings = this.getSiblingsForUniquenessCheck(eObject);
            CoreValidationRulesUtil.validateUniqueness(context, siblings, this.featureID);
            context.recordRuleRun(eObject, this.getRuleName() + objType);
        }
    }

    protected String getRuleName() {
        return this.getClass().getName();
    }

    protected boolean validateUniqueness() {
        return true;
    }

    protected boolean validateCharacters() {
        return true;
    }

    protected int getInvalidCharactersSeverityCode() {
        return 4;
    }

    protected int getFeatureID() {
        return this.featureID;
    }

    protected List getSiblingsForUniquenessCheck(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent != null) {
            return parent.eContents();
        }
        Resource resource = eObject.eResource();
        if (resource != null) {
            return resource.getContents();
        }
        return Collections.EMPTY_LIST;
    }

    public void setNameCanBeNull(boolean b2) {
        this.nameCanBeNull = b2;
    }
}

