/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.validation.rules;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.StructuralFeatureValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MultiplicityRule
implements StructuralFeatureValidationRule {
    private static final String NONE_STRING = ModelerCore.Util.getString("MultiplicityRule.NO_VALUE_STRING");
    private static final String ONE_VALUE_STRING = ModelerCore.Util.getString("MultiplicityRule.ONE_VALUE_STRING");

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        boolean upperViolated;
        int lowerBound = eStructuralFeature.getLowerBound();
        int upperBound = eStructuralFeature.getUpperBound();
        int featureReferences = 0;
        if (value instanceof EList) {
            EList eList = (EList)value;
            featureReferences = eList.size();
        } else if (value != null) {
            featureReferences = 1;
        }
        boolean lowerViolated = lowerBound != -1 && featureReferences < lowerBound;
        boolean bl = upperViolated = upperBound != -1 && featureReferences > upperBound;
        if (lowerViolated || upperViolated) {
            String featureName;
            String msg = null;
            if (lowerBound == 1 && upperBound == 1) {
                featureName = eStructuralFeature.getName();
                msg = ModelerCore.Util.getString("MultiplicityRule.Missing_value", featureName);
            } else {
                Object[] params;
                EReference eRef;
                EReference oppositeRef;
                featureName = eStructuralFeature.getName();
                String className = ModelerCore.getMetamodels().getMetaClassLabel(eObject.eClass());
                String oppositeName = null;
                boolean containment = false;
                if (eStructuralFeature instanceof EReference && (oppositeRef = (eRef = (EReference)eStructuralFeature).getEOpposite()) != null) {
                    oppositeName = oppositeRef.getContainerClass().getName();
                    containment = oppositeRef.isContainment();
                }
                String actual = NONE_STRING;
                actual = featureReferences == 0 ? NONE_STRING : (featureReferences == 1 ? ONE_VALUE_STRING : ModelerCore.Util.getString("MultiplicityRule.MULTI_VALUE_STRING", featureReferences));
                if (lowerViolated) {
                    if (oppositeName != null) {
                        if (containment) {
                            if (upperBound == -1) {
                                params = new Object[]{className, new Integer(lowerBound), featureName, actual};
                                msg = ModelerCore.Util.getString("MultiplicityRule.The_METACLASSNAME_must_contain_LOWERBOUND_or_more_FEATURENAME_when_there_are_ACTUAL", params);
                            } else {
                                params = new Object[]{className, new Integer(lowerBound), new Integer(upperBound), featureName, actual};
                                msg = ModelerCore.Util.getString("MultiplicityRule.The_METACLASSNAME_must_contain_between_LOWERBOUND_and_UPPERBOUND_FEATURENAME_when_there_are_ACTUAL", params);
                            }
                        } else if (upperBound == -1) {
                            params = new Object[]{className, new Integer(lowerBound), featureName, actual};
                            msg = ModelerCore.Util.getString("MultiplicityRule.The_METACLASSNAME_must_reference_LOWERBOUND_or_more_FEATURENAME_when_there_are_ACTUAL", params);
                        } else {
                            params = new Object[]{className, new Integer(lowerBound), new Integer(upperBound), featureName, actual};
                            msg = ModelerCore.Util.getString("MultiplicityRule.The_METACLASSNAME_must_reference_between_LOWERBOUND_and_UPPERBOUND_FEATURENAME_when_there_are_ACTUAL", params);
                        }
                    } else if (upperBound == -1) {
                        params = new Object[]{new Integer(lowerBound), featureName, actual};
                        msg = ModelerCore.Util.getString("MultiplicityRule.There_must_be_LOWERBOUND_or_more_FEATURENAME_when_there_are_ACTUAL", params);
                    } else {
                        params = new Object[]{new Integer(lowerBound), new Integer(upperBound), featureName, actual};
                        msg = ModelerCore.Util.getString("MultiplicityRule.There_must_be_between_LOWERBOUND_and_UPPERBOUND_FEATURENAME_when_there_are_ACTUAL", params);
                    }
                } else if (upperViolated) {
                    if (oppositeName != null) {
                        if (containment) {
                            if (lowerBound == 0) {
                                params = new Object[]{className, new Integer(upperBound), featureName, actual};
                                msg = ModelerCore.Util.getString("MultiplicityRule.The_METACLASSNAME_must_contain_no_more_than_UPPERBOUND_FEATURENAME_when_there_are_ACTUAL", params);
                            } else {
                                params = new Object[]{className, new Integer(lowerBound), new Integer(upperBound), featureName, actual};
                                msg = ModelerCore.Util.getString("MultiplicityRule.The_METACLASSNAME_must_contain_between_LOWERBOUND_and_UPPERBOUND_FEATURENAME_when_there_are_ACTUAL", params);
                            }
                        } else if (lowerBound == 0) {
                            params = new Object[]{className, new Integer(upperBound), featureName, actual};
                            msg = ModelerCore.Util.getString("MultiplicityRule.The_METACLASSNAME_must_reference_no_more_than_UPPERBOUND_FEATURENAME_when_there_are_ACTUAL", params);
                        } else {
                            params = new Object[]{className, new Integer(lowerBound), new Integer(upperBound), featureName, actual};
                            msg = ModelerCore.Util.getString("MultiplicityRule.The_METACLASSNAME_must_reference_between_LOWERBOUND_and_UPPERBOUND_FEATURENAME_when_there_are_ACTUAL", params);
                        }
                    } else if (lowerBound == 0) {
                        params = new Object[]{new Integer(upperBound), featureName, actual};
                        msg = ModelerCore.Util.getString("MultiplicityRule.There_must_be_less_than_LOWERBOUND_FEATURENAME_when_there_are_ACTUAL", params);
                    } else {
                        params = new Object[]{new Integer(lowerBound), new Integer(upperBound), featureName, actual};
                        msg = ModelerCore.Util.getString("MultiplicityRule.There_must_be_between_LOWERBOUND_and_UPPERBOUND_FEATURENAME_when_there_are_ACTUAL", params);
                    }
                }
            }
            Assertion.isNotNull(msg);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            ValidationResultImpl result = new ValidationResultImpl(eObject);
            result.addProblem(problem);
            context.addResult(result);
        }
    }
}

