/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.validation.rules;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import org.eclipse.emf.ecore.EObject;

public class EObjectUuidRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        ArgCheck.isNotNull(context);
        ArgCheck.isNotNull(eObject);
        int status = context.getPreferenceStatus("corePreferences.eObjectUuidUniquess", 4);
        if (status == 0) {
            return;
        }
        if (eObject instanceof ModelAnnotation) {
            return;
        }
        ModelEditor editor = ModelerCore.getModelEditor();
        ObjectID objectID = eObject.getObjectId();
        if (objectID == null) {
            String pathInModel = ((Object)editor.getModelRelativePathIncludingModel(eObject)).toString();
            ValidationResultImpl result = new ValidationResultImpl(eObject);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, ModelerCore.Util.getString("EObjectUuidRule.0", pathInModel));
            problem.setHasPreference(context.hasPreferences());
            result.addProblem(problem);
            context.addResult(result);
        } else {
            String uuidString = ((Object)objectID).toString();
            boolean isDuplicate = context.containsUuid(uuidString);
            if (isDuplicate) {
                String pathInModel = ((Object)editor.getModelRelativePathIncludingModel(eObject)).toString();
                ValidationResultImpl result = new ValidationResultImpl(eObject);
                String modelName = editor.getModelName(eObject);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, status, ModelerCore.Util.getString("EObjectUuidRule.1", pathInModel, uuidString, modelName));
                problem.setHasPreference(context.hasPreferences());
                result.addProblem(problem);
                context.addResult(result);
            } else {
                context.addUuidToContext(uuidString);
            }
        }
    }
}

