/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CoreValidationRulesUtil {
    public static void validateStringLength(ValidationResult result, int maxLength, String stringToValidate) {
        ArgCheck.isNotNull(stringToValidate);
        ArgCheck.isNotNull(result);
        StringNameValidator validator = new StringNameValidator(maxLength);
        String reasonInvalid = validator.checkNameLength(stringToValidate);
        if (reasonInvalid != null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, reasonInvalid);
            result.addProblem(problem);
        }
    }

    public static void validateStringLength(ValidationResult result, String stringToValidate) {
        ArgCheck.isNotNull(stringToValidate);
        ArgCheck.isNotNull(result);
        StringNameValidator validator = new StringNameValidator();
        String reasonInvalid = validator.checkNameLength(stringToValidate);
        if (reasonInvalid != null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, reasonInvalid);
            result.addProblem(problem);
        }
    }

    public static void validateStringNameChars(ValidationResult result, String stringToValidate, char[] invalidChars, int invalidCharacterSeverity) {
        ArgCheck.isNotNull(stringToValidate);
        ArgCheck.isNotNull(result);
        StringNameValidator validator = new StringNameValidator(invalidChars);
        String reasonInvalid = validator.checkNameCharacters(stringToValidate);
        if (reasonInvalid != null) {
            int severity = invalidCharacterSeverity;
            if (severity != 4 && severity != 1 && severity != 0 && severity != 2) {
                severity = 4;
            }
            ValidationProblemImpl problem = new ValidationProblemImpl(0, severity, reasonInvalid);
            result.addProblem(problem);
        }
    }

    public static void validateStringNameChars(ValidationResult result, String stringToValidate, char[] invalidChars) {
        CoreValidationRulesUtil.validateStringNameChars(result, stringToValidate, invalidChars, 4);
    }

    public static void validateStringName(ValidationResult result, int maxLength, String stringToValidate, char[] invalidChars) {
        ArgCheck.isNotNull(stringToValidate);
        ArgCheck.isNotNull(result);
        StringNameValidator validator = new StringNameValidator(maxLength, invalidChars);
        String reasonInvalid = validator.checkValidName(stringToValidate);
        if (reasonInvalid != null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, reasonInvalid);
            result.addProblem(problem);
        }
    }

    public static void validateUniqueness(ValidationContext context, List siblings, int nameFeatureID) {
        StringNameValidator validator = new StringNameValidator();
        CoreValidationRulesUtil.validateUniqueness(context, validator, siblings, nameFeatureID);
    }

    public static void validateUniqueness(ValidationContext context, StringNameValidator validator, List siblings, int nameFeatureID) {
        Map objectCountMap = validator.getDuplicateNamesMap(siblings, nameFeatureID);
        if (objectCountMap.size() > 0) {
            Iterator keyIter = objectCountMap.keySet().iterator();
            while (keyIter.hasNext()) {
                EObject eObject = (EObject)keyIter.next();
                EStructuralFeature eFeature = eObject.eClass().getEStructuralFeature(nameFeatureID);
                String name = (String)eObject.eGet(eFeature);
                Integer count = (Integer)objectCountMap.get(eObject);
                ValidationResultImpl result = new ValidationResultImpl(eObject);
                String msg = validator.isCaseSensitive() ? ModelerCore.Util.getString("StringNameValidator.sameNameCaseSensitive", name, count) : ModelerCore.Util.getString("StringNameValidator.The_name_{0}_is_the_same_as_{1}_other_objects_under_the_same_parent", name, count);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem(problem);
                context.addResult(result);
            }
        }
    }

    public static Collection validateUniqueness(List features) {
        StringNameValidator validator = new StringNameValidator();
        Map objectCountMap = validator.getDuplicateNamesMap(features);
        if (objectCountMap.size() > 0) {
            ArrayList<Status> statusList = new ArrayList<Status>(objectCountMap.size());
            Iterator keyIter = objectCountMap.keySet().iterator();
            while (keyIter.hasNext()) {
                EObject eObject = (EObject)keyIter.next();
                String name = ModelerCore.getModelEditor().getName(eObject);
                Integer count = (Integer)objectCountMap.get(eObject);
                Status status = new Status(4, "com.metamatrix.modeler.core", 0, ModelerCore.Util.getString("CoreValidationRulesUtil.The_name_of_feature_{0}_is_the_same_as_name_of_{1}_other_features._1", name, count), null);
                statusList.add(status);
            }
            return statusList;
        }
        return Collections.EMPTY_LIST;
    }

    public static String getValidString(String name, char[] invalidChars, int maxLength) {
        StringNameValidator validator = new StringNameValidator(maxLength, invalidChars);
        return validator.createValidName(name);
    }
}

