/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtil {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public static Method getMethod(Class c2, String name) {
        return ReflectionUtil.getMethod(c2, name, EMPTY_CLASS_ARRAY);
    }

    public static Method getMethod(Class c2, String name, Class[] parameterTypes) {
        if (c2 == null) {
            ArgCheck.isNotNull(c2, ModelerCore.Util.getString("ReflectionUtil.The_Class_instance_may_not_be_null_1"));
        }
        if (name == null) {
            ArgCheck.isNotNull(name, ModelerCore.Util.getString("ReflectionUtil.The_method_name_may_not_be_null_2"));
        }
        Class[] paramTypes = parameterTypes;
        if (parameterTypes == null) {
            paramTypes = EMPTY_CLASS_ARRAY;
        }
        try {
            Method m2 = c2.getMethod(name, paramTypes);
            ReflectionUtil.log(ModelerCore.Util.getString("ReflectionUtil.Found_method__3") + ReflectionUtil.getMethodString(m2));
            return m2;
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
    }

    public static Object invokeMethod(Method m2, Object obj, Object[] args) {
        if (m2 == null) {
            ArgCheck.isNotNull(m2, ModelerCore.Util.getString("ReflectionUtil.The_Method_instance_may_not_be_null_4"));
        }
        if (obj == null) {
            ArgCheck.isNotNull(obj, ModelerCore.Util.getString("ReflectionUtil.The_invocation_target_may_not_be_null_5"));
        }
        Object[] methodArgs = args;
        if (args == null) {
            methodArgs = EMPTY_OBJECT_ARRAY;
        }
        Object result = null;
        try {
            result = m2.invoke(obj, methodArgs);
            ReflectionUtil.log(ModelerCore.Util.getString("ReflectionUtil.Invoked_method__6") + ReflectionUtil.getMethodString(m2));
        }
        catch (IllegalAccessException e2) {
            ReflectionUtil.log(ModelerCore.Util.getString("ReflectionUtil.>>_ERROR_invoking_method__7") + ReflectionUtil.getMethodString(m2) + ", " + e2.getMessage());
            e2.printStackTrace(System.err);
        }
        catch (InvocationTargetException e3) {
            ReflectionUtil.log(ModelerCore.Util.getString("ReflectionUtil.>>_ERROR_invoking_method__9") + ReflectionUtil.getMethodString(m2) + ", " + e3.getMessage());
            e3.printStackTrace(System.err);
        }
        return result;
    }

    public static void printMethods(Class c2, PrintStream stream) {
        stream.println(ModelerCore.Util.getString("ReflectionUtil.Methods_for__11") + c2);
        Method[] methods = c2.getMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method m2 = methods[i2];
            stream.println("  " + ReflectionUtil.getMethodString(m2));
        }
    }

    public static String getMethodString(Method m2) {
        StringBuffer sb = new StringBuffer(100);
        if (m2 == null) {
            return ModelerCore.Util.getString("ReflectionUtil.null_13");
        }
        sb.append(m2.getName());
        sb.append("(");
        Class<?>[] paramTypes = m2.getParameterTypes();
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            Class<?> paramType = paramTypes[i2];
            if (i2 > 0) {
                sb.append(",");
            }
            sb.append(StringUtil.getLastToken(paramType.getName(), "."));
        }
        sb.append("):");
        Class<?> returnType = m2.getReturnType();
        if (returnType != null) {
            sb.append(StringUtil.getLastToken(returnType.getName(), "."));
        } else {
            sb.append(ModelerCore.Util.getString("ReflectionUtil.void_19"));
        }
        return sb.toString();
    }

    private static void log(String msg) {
        if (ModelerCore.DEBUG) {
            ModelerCore.Util.log(msg);
        }
    }
}

