/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.core.util.ModelVisitorWithFinish;
import com.metamatrix.modeler.core.workspace.ModelFolder;
import com.metamatrix.modeler.core.workspace.ModelProject;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

public class ModelVisitorProcessor {
    public static final int DEPTH_ZERO = 0;
    public static final int DEPTH_ONE = 1;
    public static final int DEPTH_INFINITE = 2;
    public static final int MODE_ALL_CONTAINMENTS = 0;
    public static final int MODE_VISIBLE_CONTAINMENTS = 1;
    public static final int MODE_DEFAULT = 0;
    protected ModelVisitor visitor;
    protected Navigator navigator;
    static /* synthetic */ Class class$org$eclipse$emf$edit$provider$ITreeItemContentProvider;

    public ModelVisitorProcessor(ModelVisitor visitor) {
        this(visitor, 0);
    }

    public ModelVisitorProcessor(ModelVisitor visitor, int mode) {
        ArgCheck.isNotNull(visitor);
        this.assertValidMode(mode);
        this.visitor = visitor;
        switch (mode) {
            case 1: {
                this.navigator = new ItemProviderNavigator();
                break;
            }
            case 0: {
                this.navigator = new ContainmentNavigator();
            }
        }
    }

    public ModelVisitor getModelVisitor() {
        return this.visitor;
    }

    protected void assertValidMode(int mode) {
        if (mode == 0 || mode == 1) {
            return;
        }
        String msg = ModelerCore.Util.getString("ModelVisitorProcessor.Invalid_mode");
        throw new IllegalArgumentException(msg);
    }

    protected void assertValidDepth(int depth) {
        if (depth == 2 || depth == 1 || depth == 0) {
            return;
        }
        String msg = ModelerCore.Util.getString("ModelVisitorProcessor.Invalid_depth");
        throw new IllegalArgumentException(msg);
    }

    public void walk(ModelWorkspace workspace, int depth) throws ModelerCoreException {
        ArgCheck.isNotNull(workspace);
        this.assertValidDepth(depth);
        if (depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        ModelWorkspaceItem[] children = workspace.getChildren();
        for (int i2 = 0; i2 < children.length; ++i2) {
            ModelWorkspaceItem child = children[i2];
            if (child instanceof ModelProject) {
                this.walk((ModelProject)child, nextDepth);
                continue;
            }
            if (child instanceof ModelFolder) {
                this.walk((ModelFolder)child, nextDepth);
                continue;
            }
            if (!(child instanceof ModelResource)) continue;
            this.walk((ModelResource)child, nextDepth);
        }
    }

    public void walk(ModelProject project, int depth) throws ModelerCoreException {
        ArgCheck.isNotNull(project);
        this.assertValidDepth(depth);
        if (depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        ModelWorkspaceItem[] children = project.getChildren();
        for (int i2 = 0; i2 < children.length; ++i2) {
            ModelWorkspaceItem child = children[i2];
            if (child instanceof ModelFolder) {
                this.walk((ModelFolder)child, nextDepth);
                continue;
            }
            if (!(child instanceof ModelResource)) continue;
            this.walk((ModelResource)child, nextDepth);
        }
    }

    public void walk(ModelFolder folder, int depth) throws ModelerCoreException {
        ArgCheck.isNotNull(folder);
        this.assertValidDepth(depth);
        if (depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        ModelWorkspaceItem[] children = folder.getChildren();
        for (int i2 = 0; i2 < children.length; ++i2) {
            ModelWorkspaceItem child = children[i2];
            if (child instanceof ModelFolder) {
                this.walk((ModelFolder)child, nextDepth);
                continue;
            }
            if (!(child instanceof ModelResource)) continue;
            this.walk((ModelResource)child, nextDepth);
        }
    }

    public void walk(ModelResource startingResource, int depth) throws ModelerCoreException {
        ArgCheck.isNotNull(startingResource);
        this.assertValidDepth(depth);
        Resource resource = startingResource.getEmfResource();
        this.walk(resource, depth);
    }

    public void walk(Resource startingResource, int depth) throws ModelerCoreException {
        ArgCheck.isNotNull(startingResource);
        this.assertValidDepth(depth);
        if (!this.getModelVisitor().visit(startingResource) || depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        EList children = startingResource.getContents();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            EObject object = (EObject)iter.next();
            this.walk(object, nextDepth);
        }
    }

    public void walk(EObject startingObject, int depth) throws ModelerCoreException {
        ArgCheck.isNotNull(startingObject);
        this.assertValidDepth(depth);
        if (!this.visitor.visit(startingObject) || depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        Object children = this.navigator.getChildren(startingObject);
        if (children instanceof List) {
            Iterator valueIter = ((List)children).iterator();
            while (valueIter.hasNext()) {
                Object obj = valueIter.next();
                if (!(obj instanceof EObject)) continue;
                this.walk((EObject)obj, nextDepth);
            }
        } else if (children instanceof EObject) {
            this.walk((EObject)children, nextDepth);
        }
        if (this.visitor instanceof ModelVisitorWithFinish) {
            ((ModelVisitorWithFinish)this.visitor).postVisit(startingObject);
        }
    }

    public void walk(Collection startingObjects, int depth) throws ModelerCoreException {
        this.walk(startingObjects, depth, true);
    }

    public void walk(Collection startingObjects, int depth, boolean skipDuplicateBranches) throws ModelerCoreException {
        ArgCheck.isNotNull(startingObjects);
        this.assertValidDepth(depth);
        Collection roots = skipDuplicateBranches ? this.removeDuplicates(startingObjects) : startingObjects;
        Iterator iter = roots.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object == null) continue;
            if (object instanceof Resource) {
                this.walk((Resource)object, depth);
                continue;
            }
            if (object instanceof EObject) {
                this.walk((EObject)object, depth);
                continue;
            }
            if (object instanceof ModelResource) {
                this.walk((ModelResource)object, depth);
                continue;
            }
            if (object instanceof ModelProject) {
                this.walk((ModelProject)object, depth);
                continue;
            }
            if (object instanceof ModelFolder) {
                this.walk((ModelFolder)object, depth);
                continue;
            }
            if (!(object instanceof ModelWorkspace)) continue;
            this.walk((ModelWorkspace)object, depth);
        }
    }

    protected Collection removeDuplicates(Collection startingObjects) {
        if (startingObjects.size() < 2) {
            return startingObjects;
        }
        if (startingObjects instanceof Set) {
            return startingObjects;
        }
        LinkedList copy = new LinkedList(startingObjects);
        HashSet setOfUnique = new HashSet();
        boolean includesModelWorkspaceItems = false;
        Iterator iter = copy.iterator();
        while (iter.hasNext() && !includesModelWorkspaceItems) {
            Object obj = iter.next();
            if (obj instanceof ModelWorkspaceItem) {
                includesModelWorkspaceItems = true;
            }
            if (setOfUnique.contains(obj)) {
                iter.remove();
            }
            setOfUnique.add(obj);
        }
        Iterator iter2 = copy.iterator();
        while (iter2.hasNext()) {
            Object obj = iter2.next();
            boolean foundDuplicateBranch = this.isAncestorInList(obj, copy, includesModelWorkspaceItems);
            if (!foundDuplicateBranch) continue;
            iter2.remove();
        }
        return copy;
    }

    protected boolean isAncestorInList(Object child, Collection inputs, boolean useModelWorkspace) {
        Object parent = null;
        ModelResource modelResource = null;
        if (child instanceof EObject) {
            EObject childObject = (EObject)child;
            parent = childObject.eContainer();
            if (parent == null) {
                parent = childObject.eResource();
                if (useModelWorkspace && parent instanceof Resource) {
                    modelResource = ModelWorkspaceManager.getModelWorkspaceManager().findModelResource((Resource)parent);
                }
            }
        } else if (useModelWorkspace) {
            if (child instanceof Resource) {
                ModelResource mr = ModelWorkspaceManager.getModelWorkspaceManager().findModelResource((Resource)child);
                if (mr != null) {
                    parent = mr.getParent();
                }
            } else {
                if (child instanceof ModelWorkspace) {
                    return false;
                }
                if (child instanceof ModelWorkspaceItem) {
                    parent = ((ModelWorkspaceItem)child).getParent();
                }
            }
        }
        if (parent == null) {
            return false;
        }
        if (inputs.contains(parent)) {
            return true;
        }
        if (modelResource != null && inputs.contains(modelResource)) {
            return true;
        }
        return this.isAncestorInList(parent, inputs, useModelWorkspace);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ItemProviderNavigator
    extends Navigator {
        private AdapterFactory adapterFactory = ModelerCore.getMetamodels().getEmfAdapterFactory();

        public Object getChildren(EObject parent) {
            ITreeItemContentProvider provider = (ITreeItemContentProvider)((Object)this.adapterFactory.adapt(parent, (Object)(class$org$eclipse$emf$edit$provider$ITreeItemContentProvider == null ? (class$org$eclipse$emf$edit$provider$ITreeItemContentProvider = ModelVisitorProcessor.class$("org.eclipse.emf.edit.provider.ITreeItemContentProvider")) : class$org$eclipse$emf$edit$provider$ITreeItemContentProvider)));
            if (provider != null) {
                return provider.getChildren(parent);
            }
            return null;
        }
    }

    protected class ContainmentNavigator
    extends Navigator {
        protected ContainmentNavigator() {
        }

        public Object getChildren(EObject parent) {
            return parent.eContents();
        }
    }

    protected abstract class Navigator {
        protected Navigator() {
        }

        public abstract Object getChildren(EObject var1);
    }
}

