/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.util;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelObjectCollector {
    private final Resource resource;
    private final Class eObjectType;
    private List result;

    public ModelObjectCollector(Resource resource) {
        this(resource, null);
    }

    public ModelObjectCollector(Resource resource, Class objectType) {
        this.resource = resource;
        this.eObjectType = objectType;
        this.result = null;
    }

    public List getEObjects() {
        if (this.result == null) {
            Object obj;
            this.result = new ArrayList();
            Object[] children = this.resource.getContents().toArray();
            for (int i2 = 0; i2 != children.length; ++i2) {
                obj = children[i2];
                if (!(obj instanceof EObject)) continue;
                this.result.add(obj);
                ModelObjectCollector.addChildrenToList((EObject)obj, this.result);
            }
            if (this.eObjectType != null) {
                Iterator iter = this.result.iterator();
                while (iter.hasNext()) {
                    obj = (EObject)iter.next();
                    if (this.eObjectType.isInstance(obj)) continue;
                    iter.remove();
                }
            }
        }
        return this.result;
    }

    private static void addChildrenToList(EObject eObject, List contents) {
        if (eObject == null || contents == null) {
            return;
        }
        int currentIndex = contents.size();
        try {
            EList children = eObject.eContents();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof EObject)) continue;
                contents.add(obj);
            }
        }
        catch (ConcurrentModificationException err) {
            int n2 = contents.size();
            for (int i2 = currentIndex; i2 < n2; ++i2) {
                contents.remove(i2);
            }
            Object[] children = eObject.eContents().toArray();
            for (int i3 = 0; i3 != children.length; ++i3) {
                Object obj = children[i3];
                if (!(obj instanceof EObject)) continue;
                contents.add(obj);
            }
        }
        int n3 = contents.size();
        for (int i4 = currentIndex; i4 < n3; ++i4) {
            EObject obj = (EObject)contents.get(i4);
            ModelObjectCollector.addChildrenToList(obj, contents);
        }
    }
}

