/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.refactor;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.refactor.ModelRefactorCommand;
import com.metamatrix.modeler.core.refactor.OrganizeImportCommandHelper;
import com.metamatrix.modeler.core.refactor.OrganizeImportCommandHelperNonXsd;
import com.metamatrix.modeler.core.refactor.OrganizeImportCommandHelperXsd;
import com.metamatrix.modeler.core.refactor.OrganizeImportHandler;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;

public class OrganizeImportCommand
implements ModelRefactorCommand {
    private OrganizeImportCommandHelper organizeImportCommandHelper;
    private CoreFactory factory;
    private Resource resource;
    private OrganizeImportHandler handler;
    private Map paths;
    private final Object factoryLock = new Object();

    public OrganizeImportCommand() {
        this.organizeImportCommandHelper = this.createOrganizeImportHelper();
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setHandler(OrganizeImportHandler handler) {
        this.handler = handler;
    }

    public OrganizeImportHandler getHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreFactory getFactory() {
        if (this.factory == null) {
            Object object = this.factoryLock;
            synchronized (object) {
                if (this.factory == null) {
                    this.factory = CoreFactory.eINSTANCE;
                }
            }
        }
        return this.factory;
    }

    public void setFactory(CoreFactory factory) {
        this.factory = factory;
    }

    public boolean isIncludeDiagramReferences() {
        return this.organizeImportCommandHelper.isIncludeDiagramReferences();
    }

    public void setIncludeDiagramReferences(boolean includeDiagramReferences) {
        this.organizeImportCommandHelper.setIncludeDiagramReferences(includeDiagramReferences);
    }

    public IStatus canExecute() {
        if (this.resource == null) {
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.Organizing_imports_must_be_performed_on_a_Resource");
            Status status = new Status(4, "com.metamatrix.modeler.core", 1001, msg, null);
            return status;
        }
        IResource iResource = WorkspaceResourceFinderUtil.findIResource(this.resource);
        if (iResource != null && ModelUtil.isIResourceReadOnly(iResource)) {
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.0", iResource.getFullPath());
            Status status = new Status(4, "com.metamatrix.modeler.core", 1001, msg, null);
            return status;
        }
        String msg = ModelerCore.Util.getString("OrganizeImportCommand.Ready_to_organize_import", new Object[]{this.resource.getURI()});
        return new Status(0, "com.metamatrix.modeler.core", 1000, msg, null);
    }

    public IStatus execute(IProgressMonitor monitor) {
        this.organizeImportCommandHelper = this.createOrganizeImportHelper();
        return this.organizeImportCommandHelper.execute(monitor);
    }

    public List getModelImports() {
        return this.organizeImportCommandHelper.getModelImports();
    }

    public boolean canUndo() {
        return false;
    }

    public Collection getAffectedObjects() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getLabel() {
        return null;
    }

    public Collection getPostExecuteMessages() {
        return null;
    }

    public Collection getResult() {
        return null;
    }

    public void redo() {
    }

    public void undo() {
    }

    public boolean canRedo() {
        return false;
    }

    protected void setRefactoredPaths(Map paths) {
        this.paths = paths;
    }

    protected String getUUIDMatchPattern(char recordType, String uuid) {
        Assertion.isNotNull(uuid);
        String patternStr = null;
        patternStr = 'M' == recordType ? "" + recordType + '\u00a0' + '*' + '\u00a0' + '*' + '\u00a0' + '*' + '\u00a0' + uuid + '\u00a0' + '*' : "" + recordType + '\u00a0' + '*' + '\u00a0' + uuid + '\u00a0' + '*';
        return patternStr;
    }

    protected ModelAnnotation getModelAnnotation(Resource resource) {
        if (resource instanceof EmfResource) {
            EmfResource emfResource = (EmfResource)resource;
            return emfResource.getModelAnnotation();
        }
        return null;
    }

    protected String getModelName(URI resourceUri) {
        int index;
        String modelNameWithExt = resourceUri.lastSegment();
        String extension = resourceUri.fileExtension();
        if (extension != null && (index = modelNameWithExt.indexOf(extension)) > 1) {
            return modelNameWithExt.substring(0, index - 1);
        }
        return modelNameWithExt;
    }

    private OrganizeImportCommandHelper createOrganizeImportHelper() {
        OrganizeImportCommandHelper organizeImportCommandHelper = this.resource instanceof XSDResourceImpl ? new OrganizeImportCommandHelperXsd() : new OrganizeImportCommandHelperNonXsd();
        organizeImportCommandHelper.setResource(this.resource);
        organizeImportCommandHelper.setHandler(this.handler);
        organizeImportCommandHelper.setFactory(this.factory);
        organizeImportCommandHelper.setRefactoredPaths(this.paths);
        return organizeImportCommandHelper;
    }
}

